# generated by datamodel-codegen:
#   filename:  allof_root_model_constraints.json
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Any

from pydantic import BaseModel, EmailStr, Field, conint, constr


class StringDatatype(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$') = Field(
        ..., description='A base string type.'
    )


class ConstrainedStringDatatype(BaseModel):
    __root__: constr(regex=r'^[A-Z].*', min_length=1) = Field(
        ..., description='A constrained string.'
    )


class IntegerDatatype(BaseModel):
    __root__: int = Field(..., description='A whole number.')


class NonNegativeIntegerDatatype(BaseModel):
    __root__: conint(ge=0) = Field(..., description='Non-negative integer.')


class BoundedIntegerDatatype(BaseModel):
    __root__: conint(ge=0, le=100) = Field(
        ..., description='Integer between 0 and 100.'
    )


class EmailDatatype(BaseModel):
    __root__: EmailStr = Field(..., description='Email with format.')


class FormattedStringDatatype(BaseModel):
    __root__: EmailStr = Field(..., description='A string with email format.')


class ObjectBase(BaseModel):
    id: int | None = None


class ObjectWithAllOf(ObjectBase):
    name: str | None = None


class MultiRefAllOf(BaseModel):
    pass


class NoConstraintAllOf(BaseModel):
    pass


class IncompatibleTypeAllOf(BaseModel):
    pass


class ConstraintWithProperties(BaseModel):
    extra: str | None = None


class ConstraintWithItems(BaseModel):
    pass


class NumberIntegerCompatible(BaseModel):
    __root__: conint(ge=0) = Field(
        ..., description='Number and integer are compatible.'
    )


class RefWithSchemaKeywords(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$', min_length=5, max_length=100) = Field(
        ..., description='Ref with additional schema keywords.'
    )


class ArrayDatatype(BaseModel):
    __root__: list[str]


class RefToArrayAllOf(BaseModel):
    pass


class ObjectNoPropsDatatype(BaseModel):
    pass


class RefToObjectNoPropsAllOf(ObjectNoPropsDatatype):
    pass


class PatternPropsDatatype(BaseModel):
    __root__: dict[constr(regex=r'^S_'), str]


class RefToPatternPropsAllOf(BaseModel):
    pass


class NestedAllOfDatatype(BaseModel):
    pass


class RefToNestedAllOfAllOf(NestedAllOfDatatype):
    pass


class ConstraintsOnlyDatatype(BaseModel):
    __root__: Any = Field(..., description='Constraints only, no type.')


class RefToConstraintsOnlyAllOf(BaseModel):
    __root__: Any = Field(..., description='Ref to constraints-only schema.')


class NoDescriptionAllOf(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$', min_length=5) = Field(
        ..., description='A base string type.'
    )


class EmptyConstraintItemAllOf(BaseModel):
    __root__: constr(regex=r'^\S(.*\S)?$', max_length=50) = Field(
        ..., description='AllOf with empty constraint item.'
    )


class ConflictingFormatAllOf(BaseModel):
    pass


class Model(BaseModel):
    name: ConstrainedStringDatatype | None = None
    count: NonNegativeIntegerDatatype | None = None
    percentage: BoundedIntegerDatatype | None = None
    email: EmailDatatype | None = None
    obj: ObjectWithAllOf | None = None
    multi: MultiRefAllOf | None = None
    noconstraint: NoConstraintAllOf | None = None
    incompatible: IncompatibleTypeAllOf | None = None
    withprops: ConstraintWithProperties | None = None
    withitems: ConstraintWithItems | None = None
    numint: NumberIntegerCompatible | None = None
    refwithkw: RefWithSchemaKeywords | None = None
    refarr: RefToArrayAllOf | None = None
    refobjnoprops: RefToObjectNoPropsAllOf | None = None
    refpatternprops: RefToPatternPropsAllOf | None = None
    refnestedallof: RefToNestedAllOfAllOf | None = None
    refconstraintsonly: RefToConstraintsOnlyAllOf | None = None
    nodescription: NoDescriptionAllOf | None = None
    emptyconstraint: EmptyConstraintItemAllOf | None = None
    conflictingformat: ConflictingFormatAllOf | None = None
