"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrScanNotifier = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process_1 = require("child_process");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
class EcrScanNotifier extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        const handler = this.createFunction();
        const ecrScanTarget = new aws_events_targets_1.LambdaFunction(handler);
        new aws_events_1.Rule(this, 'EventBusEcrImageScan', {
            ruleName: 'EventBusEcrImageScanRule',
            description: 'Send ECR Image Scan findings to Microsoft Teams channel',
            targets: [ecrScanTarget],
            eventPattern: {
                source: ['aws.ecr', 'aws.inspector2'],
                detailType: ['ECR Image Scan', 'Inspector2 Scan'],
            },
        });
    }
    createFunction() {
        const function_dir = path.join(__dirname, '../lambda/');
        const fn = new aws_lambda_1.Function(this, 'ecr-scan-notifier', {
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            handler: 'index.handler',
            code: aws_lambda_1.Code.fromAsset(function_dir, {
                bundling: {
                    image: aws_lambda_1.Runtime.PYTHON_3_9.bundlingImage,
                    local: {
                        tryBundle(outputDir) {
                            try {
                                child_process_1.execSync('pip3 --version');
                            }
                            catch {
                                return false;
                            }
                            child_process_1.execSync(`pip install -r ${path.join(function_dir, 'requirements.txt')} -t ${path.join(outputDir)}`);
                            child_process_1.execSync(`cp -au ${function_dir}/* ${path.join(outputDir)}`);
                            return true;
                        },
                    },
                },
            }),
            environment: {
                TOPIC_ARN: this.props.topicArn,
            },
            timeout: aws_cdk_lib_1.Duration.minutes(1),
            memorySize: 128,
            logRetention: this.props.logRetentionDays
                ? this.props.logRetentionDays
                : aws_logs_1.RetentionDays.ONE_MONTH,
            description: 'Send ECR Image Scan findings to Microsoft Teams channel',
        });
        let statements = [];
        statements.push(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['sns:Publish'],
            resources: [this.props.topicArn],
        }));
        if (this.props.keyArn) {
            statements.push(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                actions: ['kms:Decrypt', 'kms:GenerateDataKey'],
                resources: [this.props.keyArn],
            }));
        }
        fn.role?.attachInlinePolicy(new aws_iam_1.Policy(this, 'sns-publish', {
            statements,
        }));
        return fn;
    }
}
exports.EcrScanNotifier = EcrScanNotifier;
_a = JSII_RTTI_SYMBOL_1;
EcrScanNotifier[_a] = { fqn: "ecr-scan-notifier.EcrScanNotifier", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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