from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="persian-date-manager",
    version="1.1.1",
    author="Mobin Irandoust",
    author_email="mobin.workspace@gmail.com",
    description="Complete Persian date and time management with Keybit.ir API",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=find_packages(),
    include_package_data=True,
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Utilities",
    ],
    python_requires=">=3.7",
    install_requires=[
        "requests>=2.25.0",
    ],
    keywords="persian, farsi, date, time, calendar, shamsi, jalali",
    url="https://github.com/yourusername/persian-date-manager",
    entry_points={
        'console_scripts': [
            'persian-date=persian_date.cli:main',
        ],
    },
)