/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as api from '@aws-cdk/aws-apigateway';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
import * as logs from '@aws-cdk/aws-logs';
/**
 * @summary The properties for the ApiGatewayToSageMakerEndpointProps class.
 */
export interface ApiGatewayToSageMakerEndpointProps {
    /**
     * Optional user-provided props to override the default props for the API Gateway.
     *
     * @default - Default properties are used.
     */
    readonly apiGatewayProps?: api.RestApiProps;
    /**
     * Optional IAM role that is used by API Gateway to invoke the SageMaker endpoint.
     *
     * @default - An IAM role with sagemaker:InvokeEndpoint access to `endpointName` is created.
     */
    readonly apiGatewayExecutionRole?: iam.Role;
    /**
     * Name of the deployed SageMaker inference endpoint.
     *
     * @default - None.
     */
    readonly endpointName: string;
    /**
     * Optional resource name where the GET method will be available.
     *
     * @default - None.
     */
    readonly resourceName?: string;
    /**
     * Resource path for the GET method.
     *
     * The variable defined here can be referenced in `requestMappingTemplate`.
     *
     * @default - None.
     */
    readonly resourcePath: string;
    /**
     * Mapping template to convert GET requests received on the REST API to POST requests expected by the SageMaker endpoint.
     *
     * @default - None.
     */
    readonly requestMappingTemplate: string;
    /**
     * Optional mapping template to convert responses received from the SageMaker endpoint.
     *
     * @default - None.
     */
    readonly responseMappingTemplate?: string;
    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
}
/**
 * @summary The ApiGatewayToSageMakerEndpoint class.
 */
export declare class ApiGatewayToSageMakerEndpoint extends Construct {
    readonly apiGateway: api.RestApi;
    readonly apiGatewayRole: iam.Role;
    readonly apiGatewayCloudWatchRole?: iam.Role;
    readonly apiGatewayLogGroup: logs.LogGroup;
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the ApiGatewayToSageMakerEndpoint class.
     * @since 1.68.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: ApiGatewayToSageMakerEndpointProps);
}
