import * as ecr from '@aws-cdk/aws-ecr';
import { FileFingerprintOptions, CfnResource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { FingerprintOptions, IAsset } from '@aws-cdk/assets';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Options to control invalidation of `DockerImageAsset` asset hashes.
 *
 * @stability stable
 */
export interface DockerImageAssetInvalidationOptions {
    /**
     * Use `extraHash` while calculating the asset hash.
     *
     * @default true
     * @stability stable
     */
    readonly extraHash?: boolean;
    /**
     * Use `buildArgs` while calculating the asset hash.
     *
     * @default true
     * @stability stable
     */
    readonly buildArgs?: boolean;
    /**
     * Use `target` while calculating the asset hash.
     *
     * @default true
     * @stability stable
     */
    readonly target?: boolean;
    /**
     * Use `file` while calculating the asset hash.
     *
     * @default true
     * @stability stable
     */
    readonly file?: boolean;
    /**
     * Use `repositoryName` while calculating the asset hash.
     *
     * @default true
     * @stability stable
     */
    readonly repositoryName?: boolean;
}
/**
 * Options for DockerImageAsset.
 *
 * @stability stable
 */
export interface DockerImageAssetOptions extends FingerprintOptions, FileFingerprintOptions {
    /**
     * (deprecated) ECR repository name.
     *
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     *
     * @default - the default ECR repository for CDK assets
     * @deprecated to control the location of docker image assets, please override
     * `Stack.addDockerImageAsset`. this feature will be removed in future
     * releases.
     */
    readonly repositoryName?: string;
    /**
     * Build args to pass to the `docker build` command.
     *
     * Since Docker build arguments are resolved before deployment, keys and
     * values cannot refer to unresolved tokens (such as `lambda.functionArn` or
     * `queue.queueUrl`).
     *
     * @default - no build args are passed
     * @stability stable
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * Docker target to build to.
     *
     * @default - no target
     * @stability stable
     */
    readonly target?: string;
    /**
     * Path to the Dockerfile (relative to the directory).
     *
     * @default 'Dockerfile'
     * @stability stable
     */
    readonly file?: string;
    /**
     * Options to control which parameters are used to invalidate the asset hash.
     *
     * @default - hash all parameters
     * @stability stable
     */
    readonly invalidation?: DockerImageAssetInvalidationOptions;
}
/**
 * Props for DockerImageAssets.
 *
 * @stability stable
 */
export interface DockerImageAssetProps extends DockerImageAssetOptions {
    /**
     * The directory where the Dockerfile is stored.
     *
     * Any directory inside with a name that matches the CDK output folder (cdk.out by default) will be excluded from the asset
     *
     * @stability stable
     */
    readonly directory: string;
}
/**
 * An asset that represents a Docker image.
 *
 * The image will be created in build time and uploaded to an ECR repository.
 *
 * @stability stable
 */
export declare class DockerImageAsset extends CoreConstruct implements IAsset {
    /**
     * The full URI of the image (including a tag).
     *
     * Use this reference to pull
     * the asset.
     *
     * @stability stable
     */
    imageUri: string;
    /**
     * Repository where the image is stored.
     *
     * @stability stable
     */
    repository: ecr.IRepository;
    /**
     * (deprecated) A hash of the source of this asset, which is available at construction time.
     *
     * As this is a plain
     * string, it can be used in construct IDs in order to enforce creation of a new resource when
     * the content hash has changed.
     *
     * @deprecated use assetHash
     */
    readonly sourceHash: string;
    /**
     * A hash of this asset, which is available at construction time.
     *
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     *
     * @stability stable
     */
    readonly assetHash: string;
    /**
     * The path to the asset, relative to the current Cloud Assembly
     *
     * If asset staging is disabled, this will just be the original path.
     *
     * If asset staging is enabled it will be the staged path.
     */
    private readonly assetPath;
    /**
     * The path to the Dockerfile, relative to the assetPath
     */
    private readonly dockerfilePath?;
    /**
     * Build args to pass to the `docker build` command.
     */
    private readonly dockerBuildArgs?;
    /**
     * Docker target to build to
     */
    private readonly dockerBuildTarget?;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DockerImageAssetProps);
    /**
     * Adds CloudFormation template metadata to the specified resource with information that indicates which resource property is mapped to this local asset.
     *
     * This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     *
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     *
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface].
     * @param resourceProperty The property name where this asset is referenced.
     * @see https://github.com/aws/aws-cdk/issues/1432
     * @stability stable
     */
    addResourceMetadata(resource: CfnResource, resourceProperty: string): void;
}
