# Generated by Django 5.2.7 on 2025-10-31 03:56

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "django_forms_workflows",
            "0002_prefillsource_alter_formfield_prefill_source_and_more",
        ),
    ]

    operations = [
        migrations.CreateModel(
            name="PostSubmissionAction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Descriptive name for this action", max_length=200
                    ),
                ),
                (
                    "action_type",
                    models.CharField(
                        choices=[
                            ("database", "Database Update"),
                            ("ldap", "LDAP Update"),
                            ("api", "API Call"),
                            ("custom", "Custom Handler"),
                        ],
                        max_length=20,
                    ),
                ),
                (
                    "trigger",
                    models.CharField(
                        choices=[
                            ("on_submit", "On Submission"),
                            ("on_approve", "On Approval"),
                            ("on_reject", "On Rejection"),
                            ("on_complete", "On Workflow Complete"),
                        ],
                        default="on_approve",
                        help_text="When to execute this action",
                        max_length=20,
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True, help_text="Whether this action is enabled"
                    ),
                ),
                (
                    "order",
                    models.IntegerField(
                        default=0, help_text="Execution order (lower numbers run first)"
                    ),
                ),
                (
                    "db_alias",
                    models.CharField(
                        blank=True,
                        help_text="Django database alias (e.g., 'campus_cafe')",
                        max_length=100,
                    ),
                ),
                (
                    "db_schema",
                    models.CharField(
                        blank=True, help_text="Database schema name", max_length=100
                    ),
                ),
                (
                    "db_table",
                    models.CharField(
                        blank=True, help_text="Table to update", max_length=100
                    ),
                ),
                (
                    "db_lookup_field",
                    models.CharField(
                        blank=True,
                        default="ID_NUMBER",
                        help_text="Database column to match against (WHERE clause)",
                        max_length=100,
                    ),
                ),
                (
                    "db_user_field",
                    models.CharField(
                        blank=True,
                        default="employee_id",
                        help_text="UserProfile field to use for lookup",
                        max_length=100,
                    ),
                ),
                (
                    "db_field_mappings",
                    models.JSONField(
                        blank=True,
                        help_text='JSON: [{"form_field": "email", "db_column": "EMAIL_ADDRESS"}, ...]',
                        null=True,
                    ),
                ),
                (
                    "ldap_dn_template",
                    models.CharField(
                        blank=True,
                        help_text="LDAP DN template (e.g., 'CN={username},OU=Users,DC=example,DC=com')",
                        max_length=500,
                    ),
                ),
                (
                    "ldap_field_mappings",
                    models.JSONField(
                        blank=True,
                        help_text='JSON: [{"form_field": "phone", "ldap_attribute": "telephoneNumber"}, ...]',
                        null=True,
                    ),
                ),
                (
                    "api_endpoint",
                    models.URLField(
                        blank=True, help_text="API endpoint URL", max_length=500
                    ),
                ),
                (
                    "api_method",
                    models.CharField(
                        blank=True,
                        default="POST",
                        help_text="HTTP method (GET, POST, PUT, PATCH)",
                        max_length=10,
                    ),
                ),
                (
                    "api_headers",
                    models.JSONField(
                        blank=True,
                        help_text='JSON: {"Authorization": "Bearer {token}", "Content-Type": "application/json"}',
                        null=True,
                    ),
                ),
                (
                    "api_body_template",
                    models.TextField(
                        blank=True,
                        help_text="JSON template for request body. Use {field_name} for form fields.",
                    ),
                ),
                (
                    "custom_handler_path",
                    models.CharField(
                        blank=True,
                        help_text="Python path to custom handler function (e.g., 'myapp.handlers.custom_update')",
                        max_length=500,
                    ),
                ),
                (
                    "custom_handler_config",
                    models.JSONField(
                        blank=True,
                        help_text="Configuration passed to custom handler",
                        null=True,
                    ),
                ),
                (
                    "condition_field",
                    models.CharField(
                        blank=True,
                        help_text="Form field to check for conditional execution",
                        max_length=100,
                    ),
                ),
                (
                    "condition_operator",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("equals", "Equals"),
                            ("not_equals", "Not Equals"),
                            ("contains", "Contains"),
                            ("greater_than", "Greater Than"),
                            ("less_than", "Less Than"),
                            ("is_true", "Is True"),
                            ("is_false", "Is False"),
                        ],
                        help_text="Comparison operator for condition",
                        max_length=20,
                    ),
                ),
                (
                    "condition_value",
                    models.CharField(
                        blank=True, help_text="Value to compare against", max_length=500
                    ),
                ),
                (
                    "fail_silently",
                    models.BooleanField(
                        default=False,
                        help_text="If True, errors won't block submission/approval",
                    ),
                ),
                (
                    "retry_on_failure",
                    models.BooleanField(
                        default=False, help_text="Retry failed actions"
                    ),
                ),
                (
                    "max_retries",
                    models.IntegerField(default=3, help_text="Maximum retry attempts"),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Description of what this action does"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "form_definition",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="post_actions",
                        to="django_forms_workflows.formdefinition",
                    ),
                ),
            ],
            options={
                "verbose_name": "Post-Submission Action",
                "verbose_name_plural": "Post-Submission Actions",
                "ordering": ["form_definition", "order", "name"],
            },
        ),
    ]
