# Generated by Django 5.2.7 on 2025-10-31 03:48

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("django_forms_workflows", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="PrefillSource",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Display name (e.g., 'Current User - Email')",
                        max_length=200,
                        unique=True,
                    ),
                ),
                (
                    "source_type",
                    models.CharField(
                        choices=[
                            ("user", "User Model Field"),
                            ("ldap", "LDAP Attribute"),
                            ("database", "Database Query"),
                            ("api", "API Call"),
                            ("system", "System Value"),
                            ("custom", "Custom Source"),
                        ],
                        help_text="Type of data source",
                        max_length=20,
                    ),
                ),
                (
                    "source_key",
                    models.CharField(
                        help_text="Source identifier (e.g., 'user.email', 'ldap.department', 'dbo.STBIOS.FIRST_NAME')",
                        max_length=200,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Description shown to form builders"
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Inactive sources are hidden from form builders",
                    ),
                ),
                (
                    "db_alias",
                    models.CharField(
                        blank=True,
                        help_text="Django database alias (for database sources)",
                        max_length=100,
                    ),
                ),
                (
                    "db_schema",
                    models.CharField(
                        blank=True,
                        help_text="Database schema name (e.g., 'dbo')",
                        max_length=100,
                    ),
                ),
                (
                    "db_table",
                    models.CharField(
                        blank=True,
                        help_text="Database table name (e.g., 'STBIOS')",
                        max_length=100,
                    ),
                ),
                (
                    "db_column",
                    models.CharField(
                        blank=True,
                        help_text="Database column name (e.g., 'FIRST_NAME')",
                        max_length=100,
                    ),
                ),
                (
                    "db_lookup_field",
                    models.CharField(
                        blank=True,
                        default="ID_NUMBER",
                        help_text="Field to match against user (e.g., 'ID_NUMBER', 'EMAIL')",
                        max_length=100,
                    ),
                ),
                (
                    "db_user_field",
                    models.CharField(
                        blank=True,
                        default="employee_id",
                        help_text="UserProfile field to use for lookup (e.g., 'employee_id', 'email')",
                        max_length=100,
                    ),
                ),
                (
                    "ldap_attribute",
                    models.CharField(
                        blank=True,
                        help_text="LDAP attribute name (e.g., 'department', 'title')",
                        max_length=100,
                    ),
                ),
                (
                    "api_endpoint",
                    models.CharField(
                        blank=True, help_text="API endpoint URL", max_length=500
                    ),
                ),
                (
                    "api_field",
                    models.CharField(
                        blank=True,
                        help_text="Field to extract from API response",
                        max_length=100,
                    ),
                ),
                (
                    "custom_config",
                    models.JSONField(
                        blank=True,
                        help_text="Additional configuration as JSON",
                        null=True,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "order",
                    models.IntegerField(
                        default=0, help_text="Display order in dropdown"
                    ),
                ),
            ],
            options={
                "verbose_name": "Prefill Source",
                "verbose_name_plural": "Prefill Sources",
                "ordering": ["order", "name"],
            },
        ),
        migrations.AlterField(
            model_name="formfield",
            name="prefill_source",
            field=models.CharField(
                blank=True,
                help_text="DEPRECATED: Use prefill_source_config instead. Legacy format: user.email, ldap.department, {{ db.schema.table.column }}, etc.",
                max_length=200,
            ),
        ),
        migrations.AddField(
            model_name="formfield",
            name="prefill_source_config",
            field=models.ForeignKey(
                blank=True,
                help_text="Select a pre-configured prefill source",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="form_fields",
                to="django_forms_workflows.prefillsource",
            ),
        ),
    ]
