# Generated by Django 5.2.7 on 2025-10-31 03:27

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="FormDefinition",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Display name for the form", max_length=200
                    ),
                ),
                (
                    "slug",
                    models.SlugField(
                        help_text="URL identifier (e.g., 'travel-request')", unique=True
                    ),
                ),
                (
                    "description",
                    models.TextField(help_text="Shown to users on form selection page"),
                ),
                (
                    "instructions",
                    models.TextField(
                        blank=True,
                        help_text="Detailed instructions shown at top of form",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True, help_text="Inactive forms are hidden from users"
                    ),
                ),
                (
                    "version",
                    models.IntegerField(
                        default=1, help_text="Incremented when form structure changes"
                    ),
                ),
                (
                    "allow_save_draft",
                    models.BooleanField(
                        default=True, help_text="Users can save incomplete forms"
                    ),
                ),
                (
                    "allow_withdrawal",
                    models.BooleanField(
                        default=True,
                        help_text="Users can withdraw submitted forms before approval",
                    ),
                ),
                (
                    "requires_login",
                    models.BooleanField(
                        default=True, help_text="Form requires authentication"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "admin_groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Groups that can view all submissions",
                        related_name="can_admin_forms",
                        to="auth.group",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "submit_groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Groups that can submit this form",
                        related_name="can_submit_forms",
                        to="auth.group",
                    ),
                ),
                (
                    "view_groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Groups that can view this form",
                        related_name="can_view_forms",
                        to="auth.group",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form Definition",
                "verbose_name_plural": "Form Definitions",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="FormSubmission",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("form_data", models.JSONField(help_text="The actual form responses")),
                (
                    "attachments",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="List of uploaded file paths",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("submitted", "Submitted"),
                            ("pending_approval", "Pending Approval"),
                            ("approved", "Approved"),
                            ("rejected", "Rejected"),
                            ("withdrawn", "Withdrawn"),
                        ],
                        default="draft",
                        max_length=20,
                    ),
                ),
                (
                    "current_step",
                    models.CharField(
                        blank=True,
                        help_text="Current position in workflow",
                        max_length=100,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("submitted_at", models.DateTimeField(blank=True, null=True)),
                ("completed_at", models.DateTimeField(blank=True, null=True)),
                ("submission_ip", models.GenericIPAddressField(blank=True, null=True)),
                ("user_agent", models.TextField(blank=True)),
                (
                    "form_definition",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="submissions",
                        to="django_forms_workflows.formdefinition",
                    ),
                ),
                (
                    "submitter",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="form_submissions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Form Submission",
                "verbose_name_plural": "Form Submissions",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="ApprovalTask",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("approved", "Approved"),
                            ("rejected", "Rejected"),
                            ("expired", "Expired"),
                            ("skipped", "Skipped"),
                        ],
                        default="pending",
                        max_length=20,
                    ),
                ),
                ("step_name", models.CharField(max_length=100)),
                ("decision", models.CharField(blank=True, max_length=20)),
                ("comments", models.TextField(blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("due_date", models.DateTimeField(blank=True, null=True)),
                ("completed_at", models.DateTimeField(blank=True, null=True)),
                ("reminder_sent_at", models.DateTimeField(blank=True, null=True)),
                (
                    "assigned_group",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="group_approvals",
                        to="auth.group",
                    ),
                ),
                (
                    "assigned_to",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="assigned_approvals",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "completed_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="completed_approvals",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "submission",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="approval_tasks",
                        to="django_forms_workflows.formsubmission",
                    ),
                ),
            ],
            options={
                "verbose_name": "Approval Task",
                "verbose_name_plural": "Approval Tasks",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="UserProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "employee_id",
                    models.CharField(
                        blank=True,
                        help_text="Employee ID from LDAP or HR system",
                        max_length=50,
                    ),
                ),
                (
                    "external_id",
                    models.CharField(
                        blank=True,
                        help_text="ID from external system (for database lookups)",
                        max_length=100,
                    ),
                ),
                ("department", models.CharField(blank=True, max_length=200)),
                ("title", models.CharField(blank=True, max_length=200)),
                ("phone", models.CharField(blank=True, max_length=50)),
                ("office_location", models.CharField(blank=True, max_length=200)),
                (
                    "manager_dn",
                    models.CharField(
                        blank=True,
                        help_text="Manager's Distinguished Name from LDAP",
                        max_length=500,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "manager",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="direct_reports",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="forms_profile",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User Profile",
                "verbose_name_plural": "User Profiles",
            },
        ),
        migrations.CreateModel(
            name="WorkflowDefinition",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("requires_approval", models.BooleanField(default=True)),
                (
                    "approval_logic",
                    models.CharField(
                        choices=[
                            ("all", "All must approve (AND)"),
                            ("any", "Any can approve (OR)"),
                            ("sequence", "Sequential approval chain"),
                        ],
                        default="any",
                        max_length=20,
                    ),
                ),
                (
                    "requires_manager_approval",
                    models.BooleanField(
                        default=False,
                        help_text="Route to submitter's manager from LDAP",
                    ),
                ),
                (
                    "manager_can_override_group",
                    models.BooleanField(
                        default=True,
                        help_text="Manager can approve even if not in approval group",
                    ),
                ),
                (
                    "escalation_field",
                    models.SlugField(
                        blank=True,
                        help_text="Field name to check for escalation (e.g., 'amount')",
                    ),
                ),
                (
                    "escalation_threshold",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="If field value exceeds this, escalate",
                        max_digits=15,
                        null=True,
                    ),
                ),
                (
                    "approval_deadline_days",
                    models.IntegerField(
                        blank=True,
                        help_text="Days before approval request expires",
                        null=True,
                    ),
                ),
                (
                    "send_reminder_after_days",
                    models.IntegerField(
                        blank=True,
                        help_text="Send reminder email after this many days",
                        null=True,
                    ),
                ),
                (
                    "auto_approve_after_days",
                    models.IntegerField(
                        blank=True,
                        help_text="Auto-approve if no response (use carefully)",
                        null=True,
                    ),
                ),
                ("notify_on_submission", models.BooleanField(default=True)),
                ("notify_on_approval", models.BooleanField(default=True)),
                ("notify_on_rejection", models.BooleanField(default=True)),
                ("notify_on_withdrawal", models.BooleanField(default=True)),
                (
                    "additional_notify_emails",
                    models.TextField(
                        blank=True,
                        help_text="Comma-separated emails for all notifications",
                    ),
                ),
                (
                    "enable_db_updates",
                    models.BooleanField(
                        default=False,
                        help_text="Enable database updates after approval",
                    ),
                ),
                (
                    "db_update_mappings",
                    models.JSONField(
                        blank=True,
                        help_text='JSON: [{"form_field": "field_name", "db_target": "{{ db.schema.table.column }}", "update_condition": "always"}]',
                        null=True,
                    ),
                ),
                (
                    "approval_groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Groups that can approve",
                        related_name="can_approve_workflows",
                        to="auth.group",
                    ),
                ),
                (
                    "escalation_groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Additional approval needed if escalated",
                        related_name="escalation_workflows",
                        to="auth.group",
                    ),
                ),
                (
                    "form_definition",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="workflow",
                        to="django_forms_workflows.formdefinition",
                    ),
                ),
            ],
            options={
                "verbose_name": "Workflow Definition",
                "verbose_name_plural": "Workflow Definitions",
            },
        ),
        migrations.CreateModel(
            name="AuditLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "action",
                    models.CharField(
                        choices=[
                            ("create", "Created"),
                            ("update", "Updated"),
                            ("delete", "Deleted"),
                            ("submit", "Submitted"),
                            ("approve", "Approved"),
                            ("reject", "Rejected"),
                            ("withdraw", "Withdrawn"),
                            ("assign", "Assigned"),
                            ("comment", "Commented"),
                        ],
                        max_length=20,
                    ),
                ),
                ("object_type", models.CharField(max_length=50)),
                ("object_id", models.IntegerField()),
                ("user_ip", models.GenericIPAddressField(blank=True, null=True)),
                (
                    "changes",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="What changed in this action",
                    ),
                ),
                ("comments", models.TextField(blank=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Audit Log",
                "verbose_name_plural": "Audit Logs",
                "ordering": ["-created_at"],
                "indexes": [
                    models.Index(
                        fields=["object_type", "object_id"],
                        name="django_form_object__0fd458_idx",
                    ),
                    models.Index(
                        fields=["user", "created_at"],
                        name="django_form_user_id_9f6a40_idx",
                    ),
                ],
            },
        ),
        migrations.CreateModel(
            name="FormField",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "field_name",
                    models.SlugField(
                        help_text="Internal name (letters, numbers, underscores)"
                    ),
                ),
                (
                    "field_label",
                    models.CharField(help_text="Label shown to users", max_length=200),
                ),
                (
                    "field_type",
                    models.CharField(
                        choices=[
                            ("text", "Single Line Text"),
                            ("textarea", "Multi-line Text"),
                            ("number", "Whole Number"),
                            ("decimal", "Decimal/Currency"),
                            ("date", "Date"),
                            ("datetime", "Date and Time"),
                            ("time", "Time"),
                            ("email", "Email Address"),
                            ("url", "Website URL"),
                            ("select", "Dropdown Select"),
                            ("multiselect", "Multiple Select"),
                            ("radio", "Radio Buttons"),
                            ("checkbox", "Single Checkbox"),
                            ("checkboxes", "Multiple Checkboxes"),
                            ("file", "File Upload"),
                            ("hidden", "Hidden Field"),
                            ("section", "Section Header (not a field)"),
                        ],
                        max_length=20,
                    ),
                ),
                (
                    "order",
                    models.IntegerField(
                        default=0, help_text="Fields are sorted by this number"
                    ),
                ),
                (
                    "help_text",
                    models.TextField(
                        blank=True, help_text="Instructions shown below field"
                    ),
                ),
                ("placeholder", models.CharField(blank=True, max_length=200)),
                (
                    "css_class",
                    models.CharField(
                        blank=True, help_text="CSS classes for styling", max_length=100
                    ),
                ),
                (
                    "width",
                    models.CharField(
                        choices=[
                            ("full", "Full Width"),
                            ("half", "Half Width"),
                            ("third", "One Third"),
                        ],
                        default="full",
                        max_length=10,
                    ),
                ),
                ("required", models.BooleanField(default=False)),
                (
                    "min_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="For number/decimal fields",
                        max_digits=15,
                        null=True,
                    ),
                ),
                (
                    "max_value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="For number/decimal fields",
                        max_digits=15,
                        null=True,
                    ),
                ),
                (
                    "min_length",
                    models.IntegerField(
                        blank=True,
                        help_text="Minimum characters for text fields",
                        null=True,
                    ),
                ),
                (
                    "max_length",
                    models.IntegerField(
                        blank=True,
                        help_text="Maximum characters for text fields",
                        null=True,
                    ),
                ),
                (
                    "regex_validation",
                    models.CharField(
                        blank=True,
                        help_text="Regular expression for validation",
                        max_length=500,
                    ),
                ),
                (
                    "regex_error_message",
                    models.CharField(
                        blank=True,
                        help_text="Error shown if regex validation fails",
                        max_length=200,
                    ),
                ),
                (
                    "choices",
                    models.JSONField(
                        blank=True,
                        help_text='JSON: [{"value": "opt1", "label": "Option 1"}, ...] or comma-separated string',
                        null=True,
                    ),
                ),
                (
                    "prefill_source",
                    models.CharField(
                        blank=True,
                        help_text="Prefill source: user.email, ldap.department, {{ db.schema.table.column }}, etc.",
                        max_length=200,
                    ),
                ),
                ("default_value", models.TextField(blank=True)),
                (
                    "show_if_field",
                    models.SlugField(
                        blank=True,
                        help_text="Only show if another field has specific value",
                    ),
                ),
                (
                    "show_if_value",
                    models.CharField(
                        blank=True,
                        help_text="Value that triggers showing this field",
                        max_length=200,
                    ),
                ),
                (
                    "allowed_extensions",
                    models.CharField(
                        blank=True,
                        help_text="Comma-separated: pdf,doc,docx,xls,xlsx",
                        max_length=200,
                    ),
                ),
                (
                    "max_file_size_mb",
                    models.IntegerField(
                        blank=True, help_text="Maximum file size in MB", null=True
                    ),
                ),
                (
                    "form_definition",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="fields",
                        to="django_forms_workflows.formdefinition",
                    ),
                ),
            ],
            options={
                "verbose_name": "Form Field",
                "verbose_name_plural": "Form Fields",
                "ordering": ["order", "field_name"],
                "unique_together": {("form_definition", "field_name")},
            },
        ),
        migrations.AddIndex(
            model_name="formsubmission",
            index=models.Index(
                fields=["status", "submitter"], name="django_form_status_407c01_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="formsubmission",
            index=models.Index(
                fields=["form_definition", "status"],
                name="django_form_form_de_752aa4_idx",
            ),
        ),
    ]
