# Register generator `reggen` and `regtool`

The utility script `regtool.py` and collateral under `reggen` are Python
tools to read register descriptions in Hjson and generate various output
formats. The tool can output HTML documentation, standard JSON, compact
standard JSON (whitespace removed) and Hjson.  The example commands assume
`$REPO_TOP` is set to the toplevel directory of the repository.

### Setup

If packages have not previously been installed you will need to set a
few things up. First use `pip3` to install some required packages:

```console
$ pip3 install --user hjson
$ pip3 install --user mistletoe
$ pip3 install --user mako
```

### Register JSON Format

For details on the register JSON format, see the
[register tool documentation]({{< relref "doc/rm/register_tool/index.md" >}}).
To ensure things stay up to date, the register JSON format information
is documented by the tool itself.
The documentation can be generated by running the following commands:

```console
$ cd $REPO_TOP/util
$ ./build_docs.py
```
Under the hood, the `build_docs.py` tool will automatically use the `reggen`
tool to produce Markdown and processing that into HTML.

### Examples using standalone regtool

Normally for documentation the `build_docs.py` tool will automatically
use `reggen`. The script `regtool.py` provides a standalone way to run
`reggen`. See the
[register tool documentation]({{< relref "doc/rm/register_tool/index.md" >}})
for details about how to invoke the tool.

The following shows an example of how to generate RTL from a register
description:

```console
$ cd $REPO_TOP/util
$ mkdir /tmp/rtl
$ ./regtool.py -r -t /tmp/rtl ../hw/ip/uart/data/uart.hjson
$ ls /tmp/rtl
    uart_reg_pkg.sv   uart_reg_top.sv
```

The following shows an example of how to generate a DV UVM class from
a register description:

```console
$ cd $REPO_TOP/util
$ mkdir /tmp/dv
$ ./regtool.py -s -t /tmp/dv ../hw/ip/uart/data/uart.hjson
$ ls /tmp/dv
    uart_ral_pkg.sv
```

By default, the generated block, register and field models are derived from
`dv_base_reg` classes provided at `hw/dv/sv/dv_base_reg`. If required, the user
can supply the `--dv-base-prefix my_base` switch to have the models derive from
a custom, user-defined RAL classes instead:

```console
$ cd $REPO_TOP/util
$ mkdir /tmp/dv
$ ./regtool.py -s -t /tmp/dv ../hw/ip/uart/data/uart.hjson \
  --dv-base-prefix my_base
$ ls /tmp/dv
    uart_ral_pkg.sv
```

This makes the following assumptions:
- A FuseSoC core file aggregating the `my_base` RAL classes with the VLNV
  name `lowrisc:dv:my_base_reg` is provided in the cores search path.
- These custom classes are derived from the corresponding `dv_base_reg` classes
  and have the following names:
  - `my_base_reg_pkg.sv`: The RAL package that includes the below sources
  - `my_base_reg_block.sv`: The register block abstraction
  - `my_base_reg.sv`: The register abstraction
  - `my_base_reg_field.sv`: The register field abstraction
  - `my_base_mem.sv`: The memory abstraction
- If any of the above class specializations is not needed, it can be
  `typedef`'ed in `my_base_reg_pkg`:
  ```systemverilog
  package my_base_reg_pkg;
    import dv_base_reg_pkg::*;
    typedef dv_base_reg_field my_base_reg_field;
    typedef dv_base_mem my_base_mem;
    `include "my_base_reg.sv"
    `include "my_base_reg_block.sv"
  endpackage
  ```

The following shows an example of how to generate a FPV csr read write assertion
module from a register description:

```console
$ cd $REPO_TOP/util
$ mkdir /tmp/fpv/vip
$ ./regtool.py -f -t /tmp/fpv/vip ../hw/ip/uart/data/uart.hjson
$ ls /tmp/fpv
    uart_csr_assert_fpv.sv
```

If the target directory is not specified, the tool creates the DV file
under the `hw/ip/{module}/dv/` directory.
