# generated by datamodel-codegen:
#   filename:  metrics.yaml
#   timestamp: 2023-06-22T15:18:31+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field


class MetricType(Enum):
    UNKNOWN = 'UNKNOWN'
    GAUGE = 'GAUGE'
    COUNTER = 'COUNTER'
    STATE_SET = 'STATE_SET'
    INFO = 'INFO'
    HISTOGRAM = 'HISTOGRAM'
    GAUGE_HISTOGRAM = 'GAUGE_HISTOGRAM'
    SUMMARY = 'SUMMARY'


class Label(BaseModel):
    name: str
    value: str


class UnknownValue(BaseModel):
    value: float


class GaugeValue(BaseModel):
    value: float


class InfoValue(BaseModel):
    info: Optional[List[Label]] = None


class Exemplar(BaseModel):
    value: float
    timestamp: Optional[int] = None
    label: Optional[List[Label]] = None


class Bucket(BaseModel):
    upper_bound: Optional[float] = None
    count: int
    exemplar: Optional[Exemplar] = None


class State(BaseModel):
    enabled: bool
    name: str


class Quantile(BaseModel):
    quantile: float
    value: float


class CounterValue(BaseModel):
    total: float
    created: Optional[int] = None
    exemplar: Optional[Exemplar] = None


class HistogramValue(BaseModel):
    sum: Optional[float] = None
    count: Optional[int] = None
    created: Optional[int] = None
    buckets: Optional[List[Bucket]] = None


class StateSetValue(BaseModel):
    states: Optional[List[State]] = None


class SummaryValue(BaseModel):
    sum: Optional[float] = None
    count: Optional[int] = None
    created: Optional[int] = None
    quantile: Optional[List[Quantile]] = None


class MetricPoint(BaseModel):
    timestamp: Optional[int] = None
    unknown_value: Optional[UnknownValue] = None
    gauge_value: Optional[GaugeValue] = None
    counter_value: Optional[CounterValue] = None
    histogram_value: Optional[HistogramValue] = None
    state_set_value: Optional[StateSetValue] = None
    info_value: Optional[InfoValue] = None
    summary_value: Optional[SummaryValue] = None


class Metric(BaseModel):
    labels: Optional[List[Label]] = None
    metric_points: List[MetricPoint]


class MetricFamily(BaseModel):
    name: str
    type: MetricType
    unit: str
    help: Optional[str] = None
    metrics: List[Metric]


class MetricSet(BaseModel):
    oddrn: str = Field(..., description='The ODDRN of data entity or dataset field')
    metric_families: List[MetricFamily]


class MetricSetList(BaseModel):
    items: List[MetricSet]
