# coding: utf-8

"""
    printnanny-api-client

    Official API client library for printnanny.ai  # noqa: E501

    The version of the OpenAPI document: 0.94.2
    Contact: leigh@printnanny.ai
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from printnanny_api_client.configuration import Configuration


class Device(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'last_boot': 'str',
        'alert_settings': 'AlertSettings',
        'settings': 'DeviceSettings',
        'cloudiot_device': 'CloudiotDevice',
        'user': 'User',
        'system_info': 'SystemInfo',
        'public_key': 'PublicKey',
        'janus_edge': 'JanusStream',
        'janus_cloud': 'JanusStream',
        'octoprint_server': 'OctoPrintServer',
        'urls': 'DeviceUrls',
        'created_dt': 'datetime',
        'hostname': 'str',
        'fqdn': 'str'
    }

    attribute_map = {
        'id': 'id',
        'last_boot': 'last_boot',
        'alert_settings': 'alert_settings',
        'settings': 'settings',
        'cloudiot_device': 'cloudiot_device',
        'user': 'user',
        'system_info': 'system_info',
        'public_key': 'public_key',
        'janus_edge': 'janus_edge',
        'janus_cloud': 'janus_cloud',
        'octoprint_server': 'octoprint_server',
        'urls': 'urls',
        'created_dt': 'created_dt',
        'hostname': 'hostname',
        'fqdn': 'fqdn'
    }

    def __init__(self, id=None, last_boot=None, alert_settings=None, settings=None, cloudiot_device=None, user=None, system_info=None, public_key=None, janus_edge=None, janus_cloud=None, octoprint_server=None, urls=None, created_dt=None, hostname=None, fqdn=None, local_vars_configuration=None):  # noqa: E501
        """Device - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._last_boot = None
        self._alert_settings = None
        self._settings = None
        self._cloudiot_device = None
        self._user = None
        self._system_info = None
        self._public_key = None
        self._janus_edge = None
        self._janus_cloud = None
        self._octoprint_server = None
        self._urls = None
        self._created_dt = None
        self._hostname = None
        self._fqdn = None
        self.discriminator = None

        self.id = id
        self.last_boot = last_boot
        self.alert_settings = alert_settings
        self.settings = settings
        self.cloudiot_device = cloudiot_device
        self.user = user
        self.system_info = system_info
        self.public_key = public_key
        self.janus_edge = janus_edge
        self.janus_cloud = janus_cloud
        self.octoprint_server = octoprint_server
        self.urls = urls
        self.created_dt = created_dt
        if hostname is not None:
            self.hostname = hostname
        if fqdn is not None:
            self.fqdn = fqdn

    @property
    def id(self):
        """Gets the id of this Device.  # noqa: E501


        :return: The id of this Device.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Device.


        :param id: The id of this Device.  # noqa: E501
        :type id: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def last_boot(self):
        """Gets the last_boot of this Device.  # noqa: E501


        :return: The last_boot of this Device.  # noqa: E501
        :rtype: str
        """
        return self._last_boot

    @last_boot.setter
    def last_boot(self, last_boot):
        """Sets the last_boot of this Device.


        :param last_boot: The last_boot of this Device.  # noqa: E501
        :type last_boot: str
        """
        if self.local_vars_configuration.client_side_validation and last_boot is None:  # noqa: E501
            raise ValueError("Invalid value for `last_boot`, must not be `None`")  # noqa: E501

        self._last_boot = last_boot

    @property
    def alert_settings(self):
        """Gets the alert_settings of this Device.  # noqa: E501


        :return: The alert_settings of this Device.  # noqa: E501
        :rtype: AlertSettings
        """
        return self._alert_settings

    @alert_settings.setter
    def alert_settings(self, alert_settings):
        """Sets the alert_settings of this Device.


        :param alert_settings: The alert_settings of this Device.  # noqa: E501
        :type alert_settings: AlertSettings
        """

        self._alert_settings = alert_settings

    @property
    def settings(self):
        """Gets the settings of this Device.  # noqa: E501


        :return: The settings of this Device.  # noqa: E501
        :rtype: DeviceSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this Device.


        :param settings: The settings of this Device.  # noqa: E501
        :type settings: DeviceSettings
        """

        self._settings = settings

    @property
    def cloudiot_device(self):
        """Gets the cloudiot_device of this Device.  # noqa: E501


        :return: The cloudiot_device of this Device.  # noqa: E501
        :rtype: CloudiotDevice
        """
        return self._cloudiot_device

    @cloudiot_device.setter
    def cloudiot_device(self, cloudiot_device):
        """Sets the cloudiot_device of this Device.


        :param cloudiot_device: The cloudiot_device of this Device.  # noqa: E501
        :type cloudiot_device: CloudiotDevice
        """

        self._cloudiot_device = cloudiot_device

    @property
    def user(self):
        """Gets the user of this Device.  # noqa: E501


        :return: The user of this Device.  # noqa: E501
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this Device.


        :param user: The user of this Device.  # noqa: E501
        :type user: User
        """

        self._user = user

    @property
    def system_info(self):
        """Gets the system_info of this Device.  # noqa: E501


        :return: The system_info of this Device.  # noqa: E501
        :rtype: SystemInfo
        """
        return self._system_info

    @system_info.setter
    def system_info(self, system_info):
        """Sets the system_info of this Device.


        :param system_info: The system_info of this Device.  # noqa: E501
        :type system_info: SystemInfo
        """

        self._system_info = system_info

    @property
    def public_key(self):
        """Gets the public_key of this Device.  # noqa: E501


        :return: The public_key of this Device.  # noqa: E501
        :rtype: PublicKey
        """
        return self._public_key

    @public_key.setter
    def public_key(self, public_key):
        """Sets the public_key of this Device.


        :param public_key: The public_key of this Device.  # noqa: E501
        :type public_key: PublicKey
        """

        self._public_key = public_key

    @property
    def janus_edge(self):
        """Gets the janus_edge of this Device.  # noqa: E501


        :return: The janus_edge of this Device.  # noqa: E501
        :rtype: JanusStream
        """
        return self._janus_edge

    @janus_edge.setter
    def janus_edge(self, janus_edge):
        """Sets the janus_edge of this Device.


        :param janus_edge: The janus_edge of this Device.  # noqa: E501
        :type janus_edge: JanusStream
        """

        self._janus_edge = janus_edge

    @property
    def janus_cloud(self):
        """Gets the janus_cloud of this Device.  # noqa: E501


        :return: The janus_cloud of this Device.  # noqa: E501
        :rtype: JanusStream
        """
        return self._janus_cloud

    @janus_cloud.setter
    def janus_cloud(self, janus_cloud):
        """Sets the janus_cloud of this Device.


        :param janus_cloud: The janus_cloud of this Device.  # noqa: E501
        :type janus_cloud: JanusStream
        """

        self._janus_cloud = janus_cloud

    @property
    def octoprint_server(self):
        """Gets the octoprint_server of this Device.  # noqa: E501


        :return: The octoprint_server of this Device.  # noqa: E501
        :rtype: OctoPrintServer
        """
        return self._octoprint_server

    @octoprint_server.setter
    def octoprint_server(self, octoprint_server):
        """Sets the octoprint_server of this Device.


        :param octoprint_server: The octoprint_server of this Device.  # noqa: E501
        :type octoprint_server: OctoPrintServer
        """

        self._octoprint_server = octoprint_server

    @property
    def urls(self):
        """Gets the urls of this Device.  # noqa: E501


        :return: The urls of this Device.  # noqa: E501
        :rtype: DeviceUrls
        """
        return self._urls

    @urls.setter
    def urls(self, urls):
        """Sets the urls of this Device.


        :param urls: The urls of this Device.  # noqa: E501
        :type urls: DeviceUrls
        """
        if self.local_vars_configuration.client_side_validation and urls is None:  # noqa: E501
            raise ValueError("Invalid value for `urls`, must not be `None`")  # noqa: E501

        self._urls = urls

    @property
    def created_dt(self):
        """Gets the created_dt of this Device.  # noqa: E501


        :return: The created_dt of this Device.  # noqa: E501
        :rtype: datetime
        """
        return self._created_dt

    @created_dt.setter
    def created_dt(self, created_dt):
        """Sets the created_dt of this Device.


        :param created_dt: The created_dt of this Device.  # noqa: E501
        :type created_dt: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_dt is None:  # noqa: E501
            raise ValueError("Invalid value for `created_dt`, must not be `None`")  # noqa: E501

        self._created_dt = created_dt

    @property
    def hostname(self):
        """Gets the hostname of this Device.  # noqa: E501

        Please enter the hostname you set in the Raspberry Pi Imager's Advanced Options menu (without .local extension)  # noqa: E501

        :return: The hostname of this Device.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this Device.

        Please enter the hostname you set in the Raspberry Pi Imager's Advanced Options menu (without .local extension)  # noqa: E501

        :param hostname: The hostname of this Device.  # noqa: E501
        :type hostname: str
        """
        if (self.local_vars_configuration.client_side_validation and
                hostname is not None and len(hostname) > 255):
            raise ValueError("Invalid value for `hostname`, length must be less than or equal to `255`")  # noqa: E501

        self._hostname = hostname

    @property
    def fqdn(self):
        """Gets the fqdn of this Device.  # noqa: E501


        :return: The fqdn of this Device.  # noqa: E501
        :rtype: str
        """
        return self._fqdn

    @fqdn.setter
    def fqdn(self, fqdn):
        """Sets the fqdn of this Device.


        :param fqdn: The fqdn of this Device.  # noqa: E501
        :type fqdn: str
        """
        if (self.local_vars_configuration.client_side_validation and
                fqdn is not None and len(fqdn) > 255):
            raise ValueError("Invalid value for `fqdn`, length must be less than or equal to `255`")  # noqa: E501

        self._fqdn = fqdn

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Device):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Device):
            return True

        return self.to_dict() != other.to_dict()
