#!/usr/bin/env python3
import sys
sys.path.insert(0, '.')

from src.core.config import get_config

try:
    config = get_config()
    print('[OK] Config loaded successfully')
    print('[OK] API Key exists:', bool(config.embedding_api_key))
    if config.embedding_api_key:
        print('[OK] API Key (first 10 chars):', config.embedding_api_key[:10] + '...')
    print('[OK] SQLite DB path:', config.sqlite_db_path)
    print('[OK] ChromaDB dir:', config.chromadb_persist_dir)
except Exception as e:
    print('[ERROR] Config loading failed:', e)
    import traceback
    traceback.print_exc()
