# MCP服务器配置修复指南

## 问题诊断

MCP服务器连接失败，错误信息：
```
Failed to reconnect to questions-mcp-server.
[ERROR] 系统初始化失败: 配置验证失败:
缺少必需配置: Embedding API 密钥 (embedding.api_key)
```

## 问题原因

1. **工作目录问题**: 通过MCP客户端启动时，工作目录可能不是项目根目录，导致`.env`文件无法找到
2. **环境变量缺失**: MCP配置文件中没有包含必要的环境变量

## 修复方案

### 方案1: 使用更新后的配置文件（推荐）

已更新的配置文件：
- `mcp_server_config.json` - 开发环境配置
- `mcp_server_config_installed.json` - uvx安装配置
- `mcp_server_config_pip.json` - pip安装配置

这些文件现在包含了所有必需的环境变量。

### 方案2: 从系统环境变量读取

如果您不想在配置文件中暴露API密钥，可以：

1. 设置系统环境变量：
```bash
# Windows
set EMBEDDING_API_KEY=sk-s66up3d6Pei7CzIZH27zlPF6YJYhaMhU2p5NICmHUKR00aE0
set EMBEDDING_API_ENDPOINT=https://zhouliuai.online/v1/embeddings
set EMBEDDING_MODEL=text-embedding-3-large
set SQLITE_DB_PATH=./data/questions.db
set CHROMA_PERSIST_DIR=./data/chroma
set LOG_LEVEL=INFO

# Linux/Mac
export EMBEDDING_API_KEY=sk-s66up3d6Pei7CzIZH27zlPF6YJYhaMhU2p5NICmHUKR00aE0
export EMBEDDING_API_ENDPOINT=https://zhouliuai.online/v1/embeddings
export EMBEDDING_MODEL=text-embedding-3-large
export SQLITE_DB_PATH=./data/questions.db
export CHROMA_PERSIST_DIR=./data/chroma
export LOG_LEVEL=INFO
```

2. 或者修改MCP配置文件，移除API密钥明文：
```json
{
  "mcpServers": {
    "questions-mcp-server": {
      "command": "uvx",
      "args": ["questions-mcp-server"],
      "env": {
        "PYTHONIOENCODING": "utf-8",
        "PYTHONUNBUFFERED": "1"
      }
    }
  }
}
```

## 如何更新Claude的MCP配置

### 方法1: 使用Claude Web界面
1. 打开Claude Web界面 (claude.ai)
2. 进入 Settings → Developer
3. 删除旧的"questions-mcp-server"配置
4. 复制 `mcp_server_config_installed.json` 的内容
5. 粘贴并保存

### 方法2: 手动创建配置文件
1. 在您的计算机上创建或编辑MCP配置文件
2. 位置：
   - macOS/Linux: `~/.claude/mcp_servers.json` 或 `~/.config/claude/mcp_servers.json`
   - Windows: `%APPDATA%\Claude\mcp_servers.json`
3. 使用 `mcp_server_config.json` 的内容作为模板

## 验证修复

运行测试脚本验证配置：
```bash
uv run python test_mcp_connection.py
```

## 启动MCP服务器

```bash
# 开发模式
uv run python src/main.py

# 或使用MCP模式
uv run python -m src.main
```

## 安全建议

1. **不要提交API密钥**: 确保`.env`文件和MCP配置中的API密钥不会提交到版本控制
2. **使用环境变量**: 在生产环境中，建议使用系统环境变量或密钥管理服务
3. **定期轮换**: 定期更换API密钥以提高安全性
