# MIT License
#
# Copyright (c) 2025 ericsmacedo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""Test Command Line Interface."""

from click.testing import CliRunner

from sv_simpleparser.cli import cli


def test_gen_sv_instance_smoke():
    """Simply test that the command runs without errors."""
    runner = CliRunner()
    with runner.isolated_filesystem():
        # Create a dummy SV file
        with open("test.sv", "w") as f:
            f.write("module dummy(); endmodule")

        # Run the command
        result = runner.invoke(cli, ["gen-sv-instance", "test.sv"])

        # Just check it didn't crash
        assert result.exit_code == 0


def test_info_smoke():
    """Simply test that the command runs without errors."""
    runner = CliRunner()
    with runner.isolated_filesystem():
        # Create a dummy SV file
        with open("test.sv", "w") as f:
            f.write("module dummy(); endmodule")

        # Run the command
        result = runner.invoke(cli, ["info", "test.sv"])

        # Just check it didn't crash
        assert result.exit_code == 0


def test_cli_help_smoke():
    """Test that help command works."""
    runner = CliRunner()
    result = runner.invoke(cli, ["--help"])
    assert result.exit_code == 0
    assert "Usage:" in result.output
