import pickle
import os
import cv2
from gimpml.tools.tools_utils import get_weight_path
import numpy as np


def get_edge(image, min_val=100, max_val=200):
    if image.shape[2] == 4:  # get rid of alpha channel
        image = image[:, :, 0:3]
    edges = cv2.Canny(image, min_val, max_val)
    edges = np.dstack([edges, edges, edges])
    return edges


if __name__ == "__main__":
    weight_path = get_weight_path()
    with open(os.path.join(weight_path, "..", "gimp_ml_run.pkl"), "rb") as file:
        data_output = pickle.load(file)
    min_val = data_output["min_val"]
    max_val = data_output["max_val"]
    image = cv2.imread(os.path.join(weight_path, "..", "cache.png"))[:, :, ::-1]
    try:
        output = get_edge(image, min_val=min_val, max_val=max_val)
        cv2.imwrite(os.path.join(weight_path, "..", "cache.png"), output[:, :, ::-1])
        with open(os.path.join(weight_path, "..", "gimp_ml_run.pkl"), "wb") as file:
            pickle.dump({"inference_status": "success"}, file)

        # Remove old temporary error files that were saved
        my_dir = os.path.join(weight_path, "..")
        for f_name in os.listdir(my_dir):
            if f_name.startswith("error_log"):
                os.remove(os.path.join(my_dir, f_name))

    except Exception as error:
        with open(os.path.join(weight_path, "..", "gimp_ml_run.pkl"), "wb") as file:
            pickle.dump({"inference_status": "failed"}, file)
        with open(os.path.join(weight_path, "..", "error_log.txt"), "w") as file:
            file.write(str(error))
