"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerConfigSecret = exports.TlsSecret = exports.ServiceAccountTokenSecret = exports.SshAuthSecret = exports.BasicAuthSecret = exports.Secret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base = require("./base");
const k8s = require("./imports/k8s");
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base.Resource {
    constructor(scope, id, props = {}) {
        var _g, _h;
        super(scope, id);
        this.resourceType = 'secrets';
        this.stringData = (_g = props.stringData) !== null && _g !== void 0 ? _g : {};
        this.immutable = (_h = props.immutable) !== null && _h !== void 0 ? _h : false;
        this.apiObject = new k8s.KubeSecret(this, 'Resource', {
            metadata: props.metadata,
            type: props.type,
            stringData: this.stringData,
            immutable: this.immutable,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     * @param name The name of the secret to reference.
     */
    static fromSecretName(name) {
        return {
            apiGroup: '',
            name,
            ...k8s.KubeSecret.GVK,
        };
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
_a = JSII_RTTI_SYMBOL_1;
Secret[_a] = { fqn: "cdk8s-plus-22.Secret", version: "2.0.0-beta.0" };
/**
 * Create a secret for basic authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
 */
class BasicAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/basic-auth',
            stringData: {
                username: props.username,
                password: props.password,
            },
            immutable: props.immutable,
        });
    }
}
exports.BasicAuthSecret = BasicAuthSecret;
_b = JSII_RTTI_SYMBOL_1;
BasicAuthSecret[_b] = { fqn: "cdk8s-plus-22.BasicAuthSecret", version: "2.0.0-beta.0" };
/**
 * Create a secret for ssh authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
 */
class SshAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/ssh-auth',
            stringData: {
                'ssh-privatekey': props.sshPrivateKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.SshAuthSecret = SshAuthSecret;
_c = JSII_RTTI_SYMBOL_1;
SshAuthSecret[_c] = { fqn: "cdk8s-plus-22.SshAuthSecret", version: "2.0.0-beta.0" };
/**
 * Create a secret for a service account token.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
 */
class ServiceAccountTokenSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/service-account-token',
            metadata: {
                annotations: {
                    'kubernetes.io/service-account.name': props.serviceAccount.name,
                },
            },
            immutable: props.immutable,
        });
    }
}
exports.ServiceAccountTokenSecret = ServiceAccountTokenSecret;
_d = JSII_RTTI_SYMBOL_1;
ServiceAccountTokenSecret[_d] = { fqn: "cdk8s-plus-22.ServiceAccountTokenSecret", version: "2.0.0-beta.0" };
/**
 * Create a secret for storing a TLS certificate and its associated key.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
 */
class TlsSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/tls',
            stringData: {
                'tls.crt': props.tlsCert,
                'tls.key': props.tlsKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.TlsSecret = TlsSecret;
_e = JSII_RTTI_SYMBOL_1;
TlsSecret[_e] = { fqn: "cdk8s-plus-22.TlsSecret", version: "2.0.0-beta.0" };
/**
 * Create a secret for storing credentials for accessing a container image
 * registry.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
 */
class DockerConfigSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/dockerconfigjson',
            stringData: {
                '.dockerconfigjson': JSON.stringify(props.data),
            },
            immutable: props.immutable,
        });
    }
}
exports.DockerConfigSecret = DockerConfigSecret;
_f = JSII_RTTI_SYMBOL_1;
DockerConfigSecret[_f] = { fqn: "cdk8s-plus-22.DockerConfigSecret", version: "2.0.0-beta.0" };
//# sourceMappingURL=data:application/json;base64,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