import { ApiObjectMetadata, ApiObject, ApiObjectMetadataDefinition } from 'cdk8s';
import { Construct } from 'constructs';
import { IApiResource, IApiEndpoint } from './api-resource.generated';
/**
 * Initialization properties for resources.
 */
export interface ResourceProps {
    /**
     * Metadata that all persisted resources must have, which includes all objects
     * users must create.
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Represents a resource.
 */
export interface IResource {
    /**
     * The Kubernetes name of this resource.
     */
    readonly name: string;
    /**
     * The object's API version (e.g. "authorization.k8s.io/v1")
     */
    readonly apiVersion: string;
    /**
     * The group portion of the API version (e.g. "authorization.k8s.io")
     */
    readonly apiGroup: string;
    /**
     * The object kind (e.g. "Deployment").
     */
    readonly kind: string;
}
/**
 * Base class for all Kubernetes objects in stdk8s. Represents a single
 * resource.
 */
export declare abstract class Resource extends Construct implements IResource, IApiResource, IApiEndpoint {
    /**
     * The underlying cdk8s API object.
     */
    protected abstract readonly apiObject: ApiObject;
    get metadata(): ApiObjectMetadataDefinition;
    /**
     * The name of this API object.
     */
    get name(): string;
    /**
     * The object's API version (e.g. "authorization.k8s.io/v1")
     */
    get apiVersion(): string;
    /**
     * The group portion of the API version (e.g. "authorization.k8s.io").
     */
    get apiGroup(): string;
    /**
     * The object kind (e.g. "Deployment").
     */
    get kind(): string;
    get resourceName(): string | undefined;
    abstract readonly resourceType: string;
    asApiResource(): IApiResource | undefined;
    asNonApiResource(): string | undefined;
}
