"""
Type-in entry special character conversion and keyword token maps.
"""

# Core Commodore BASIC tokens
CORE_TOKENS = (
    ("end", 128),
    ("for", 129),
    ("next", 130),
    ("data", 131),
    ("input#", 132),
    ("input", 133),
    ("dim", 134),
    ("read", 135),
    ("let", 136),
    ("goto", 137),
    ("run", 138),
    ("if", 139),
    ("restore", 140),
    ("gosub", 141),
    ("return", 142),
    ("rem", 143),
    ("stop", 144),
    ("on", 145),
    ("wait", 146),
    ("load", 147),
    ("save", 148),
    ("verify", 149),
    ("def", 150),
    ("poke", 151),
    ("print#", 152),
    ("print", 153),
    ("cont", 154),
    ("list", 155),
    ("clr", 156),
    ("cmd", 157),
    ("sys", 158),
    ("open", 159),
    ("close", 160),
    ("get", 161),
    ("new", 162),
    ("tab(", 163),
    ("to", 164),
    ("fn", 165),
    ("spc(", 166),
    ("then", 167),
    ("not", 168),
    ("step", 169),
    ("+", 170),
    ("-", 171),
    ("*", 172),
    ("/", 173),
    ("^", 174),
    ("and", 175),
    ("or", 176),
    (">", 177),
    ("=", 178),
    ("<", 179),
    ("sgn", 180),
    ("int", 181),
    ("abs", 182),
    ("usr", 183),
    ("fre", 184),
    ("pos", 185),
    ("sqr", 186),
    ("rnd", 187),
    ("log", 188),
    ("exp", 189),
    ("cos", 190),
    ("sin", 191),
    ("tan", 192),
    ("atn", 193),
    ("peek", 194),
    ("len", 195),
    ("str$", 196),
    ("val", 197),
    ("asc", 198),
    ("chr$", 199),
    ("left$", 200),
    ("right$", 201),
    ("mid$", 202),
    ("go", 203),
)

TOKENS_V2 = CORE_TOKENS  # Case for Commodore BASIC v2.0 TODO: Add versions

# Tokens for special character designations used by Ahoy
SHFT_CMDRE_TKNS = (
    ("ep", 92),
    ("up_arrow", 94),
    ("left_arrow", 95),
    ("pi", 126),
    ("c 9", 41),
    ("c 0", 48),
    ("c 1", 129),
    ("s return", 141),
    ("c 2", 149),
    ("c 3", 150),
    ("c 4", 151),
    ("c 5", 152),
    ("c 6", 153),
    ("c 7", 154),
    ("c 8", 155),
    ("s space", 160),
    ("c k", 161),
    ("c i", 162),
    ("c t", 163),
    ("c @", 164),
    ("c g", 165),
    ("c +", 166),
    ("c m", 167),
    ("c ep", 168),
    ("s ep", 169),
    ("c n", 170),
    ("c q", 171),
    ("c d", 172),
    ("c z", 173),
    ("c s", 174),
    ("c p", 175),
    ("c a", 176),
    ("c e", 177),
    ("c r", 178),
    ("c w", 179),
    ("c h", 180),
    ("c j", 181),
    ("c l", 182),
    ("c y", 183),
    ("c u", 184),
    ("c o", 185),
    ("s @", 186),
    ("c f", 187),
    ("c c", 188),
    ("c x", 189),
    ("c v", 190),
    ("c b", 191),
    ("s *", 192),
    ("s a", 193),
    ("s b", 194),
    ("s c", 195),
    ("s d", 196),
    ("s e", 197),
    ("s f", 198),
    ("s g", 199),
    ("s h", 200),
    ("s i", 201),
    ("s j", 202),
    ("s k", 203),
    ("s l", 204),
    ("s m", 205),
    ("s n", 206),
    ("s o", 207),
    ("s p", 208),
    ("s q", 209),
    ("s r", 210),
    ("s s", 211),
    ("s t", 212),
    ("s u", 213),
    ("s v", 214),
    ("s w", 215),
    ("s x", 216),
    ("s y", 217),
    ("s z", 218),
    ("s +", 219),
    ("c -", 220),
    ("s -", 221),
    ("s up_arrow", 222),
    ("c *", 223),
)

AHOY_TO_PETCAT = {
    # Ahoy special character entry codes through Oct 1984 issue
    "{SC}": "{clr}",
    "{HM}": "{home}",
    "{CU}": "{up}",
    "{CD}": "{down}",
    "{CL}": "{left}",
    "{CR}": "{rght}",
    "{SS}": "{sspc}",
    "{IN}": "{inst}",
    "{RV}": "{rvon}",
    "{RO}": "{rvof}",
    "{BK}": "{blk}",
    "{WH}": "{wht}",
    "{RD}": "{red}",
    "{CY}": "{cyn}",
    "{PU}": "{pur}",
    "{GN}": "{grn}",
    "{BL}": "{blu}",
    "{YL}": "{yel}",
    "{OR}": "{orng}",
    "{BR}": "{brn}",
    "{LR}": "{lred}",
    "{G1}": "{gry1}",
    "{G2}": "{gry2}",
    "{LG}": "{lgrn}",
    "{LB}": "{lblu}",
    "{G3}": "{gry3}",
    "{F1}": "{f1}",
    "{F2}": "{f2}",
    "{F3}": "{f3}",
    "{F4}": "{f4}",
    "{F5}": "{f5}",
    "{F6}": "{f6}",
    "{F7}": "{f7}",
    "{F8}": "{f8}",
    # Ahoy special character entry codes from November 1984 issue to end
    "{CLEAR}": "{clr}",
    "{HOME}": "{home}",
    "{UP}": "{up}",
    "{DOWN}": "{down}",
    "{LEFT}": "{left}",
    "{RIGHT}": "{rght}",
    "{INSERT}": "{inst}",
    "{RVSON}": "{rvon}",
    "{RVSOFF}": "{rvof}",
    "{BLACK}": "{blk}",
    "{WHITE}": "{wht}",
    "{RED}": "{red}",
    "{CYAN}": "{cyn}",
    "{PURPLE}": "{pur}",
    "{GREEN}": "{grn}",
    "{BLUE}": "{blu}",
    "{YELLOW}": "{yel}",
    "{ORANGE}": "{orng}",
    "{BROWN}": "{brn}",
    "{LTRED}": "{lred}",
    "{GRAY1}": "{gry1}",
    "{GRAY2}": "{gry2}",
    "{LTGREEN}": "{lgrn}",
    "{LTBLUE}": "{lblu}",
    "{GRAY3}": "{gry3}",
}

# Tokens for special character designations used by petcat
PETCAT_TOKENS = (
    ("{clr}", 147),
    ("{home}", 19),
    ("{up}", 145),
    ("{down}", 17),
    ("{left}", 157),
    ("{rght}", 29),
    ("{sspc}", 160),
    ("{inst}", 148),
    ("{rvon}", 18),
    ("{rvof}", 146),
    ("{blk}", 144),
    ("{wht}", 5),
    ("{red}", 28),
    ("{cyn}", 159),
    ("{pur}", 156),
    ("{grn}", 30),
    ("{blu}", 31),
    ("{yel}", 158),
    ("{orng}", 129),
    ("{brn}", 149),
    ("{lred}", 150),
    ("{gry1}", 151),
    ("{gry2}", 152),
    ("{lgrn}", 153),
    ("{lblu}", 154),
    ("{gry3}", 155),
    ("{f1}", 133),
    ("{f2}", 137),
    ("{f3}", 134),
    ("{f4}", 138),
    ("{f5}", 135),
    ("{f6}", 139),
    ("{f7}", 136),
    ("{f8}", 140),
)

# Tokens for special character designations used by Ahoy
SHIFT_CMDRE_TOKENS = (
    ("{ep}", 92),
    ("{up_arrow}", 94),
    ("{left_arrow}", 95),
    ("{pi}", 126),
    ("{c 9}", 41),
    ("{c 0}", 48),
    ("{c 1}", 129),
    ("{s return}", 141),
    ("{c 2}", 149),
    ("{c 3}", 150),
    ("{c 4}", 151),
    ("{c 5}", 152),
    ("{c 6}", 153),
    ("{c 7}", 154),
    ("{c 8}", 155),
    ("{s space}", 160),
    ("{c k}", 161),
    ("{c i}", 162),
    ("{c t}", 163),
    ("{c @}", 164),
    ("{c g}", 165),
    ("{c +}", 166),
    ("{c m}", 167),
    ("{c ep}", 168),
    ("{s ep}", 169),
    ("{c n}", 170),
    ("{c q}", 171),
    ("{c d}", 172),
    ("{c z}", 173),
    ("{c s}", 174),
    ("{c p}", 175),
    ("{c a}", 176),
    ("{c e}", 177),
    ("{c r}", 178),
    ("{c w}", 179),
    ("{c h}", 180),
    ("{c j}", 181),
    ("{c l}", 182),
    ("{c y}", 183),
    ("{c u}", 184),
    ("{c o}", 185),
    ("{s @}", 186),
    ("{c f}", 187),
    ("{c c}", 188),
    ("{c x}", 189),
    ("{c v}", 190),
    ("{c b}", 191),
    ("{s *}", 192),
    ("{s a}", 193),
    ("{s b}", 194),
    ("{s c}", 195),
    ("{s d}", 196),
    ("{s e}", 197),
    ("{s f}", 198),
    ("{s g}", 199),
    ("{s h}", 200),
    ("{s i}", 201),
    ("{s j}", 202),
    ("{s k}", 203),
    ("{s l}", 204),
    ("{s m}", 205),
    ("{s n}", 206),
    ("{s o}", 207),
    ("{s p}", 208),
    ("{s q}", 209),
    ("{s r}", 210),
    ("{s s}", 211),
    ("{s t}", 212),
    ("{s u}", 213),
    ("{s v}", 214),
    ("{s w}", 215),
    ("{s x}", 216),
    ("{s y}", 217),
    ("{s z}", 218),
    ("{s +}", 219),
    ("{c -}", 220),
    ("{s -}", 221),
    ("{s up_arrow}", 222),
    ("{c *}", 223),
)
