"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceGroupModifyConfigPropertyToJson = exports.BootstrapActionConfigToJson = exports.PlacementTypePropertyToJson = exports.InstanceGroupConfigPropertyToJson = exports.AutoScalingPolicyPropertyToJson = exports.ScalingRulePropertyToJson = exports.ScalingActionPropertyToJson = exports.ScalingTriggerPropertyToJson = exports.MetricDimensionPropertyToJson = exports.InstanceFleetConfigPropertyToJson = exports.InstanceFleetProvisioningSpecificationsPropertyToJson = exports.InstanceTypeConfigPropertyToJson = exports.EbsConfigurationPropertyToJson = exports.EbsBlockDeviceConfigPropertyToJson = exports.ConfigurationPropertyToJson = exports.ApplicationConfigPropertyToJson = exports.InstancesConfigPropertyToJson = exports.KerberosAttributesPropertyToJson = void 0;
const cdk = require("@aws-cdk/core");
/**
 * Render the KerberosAttributesProperty as JSON
 *
 * @param property
 */
function KerberosAttributesPropertyToJson(property) {
    return {
        ADDomainJoinPassword: cdk.stringToCloudFormation(property.adDomainJoinPassword),
        ADDomainJoinUser: cdk.stringToCloudFormation(property.adDomainJoinUser),
        CrossRealmTrustPrincipalPassword: cdk.stringToCloudFormation(property.crossRealmTrustPrincipalPassword),
        KdcAdminPassword: cdk.stringToCloudFormation(property.kdcAdminPassword),
        Realm: cdk.stringToCloudFormation(property.realm),
    };
}
exports.KerberosAttributesPropertyToJson = KerberosAttributesPropertyToJson;
/**
 * Render the InstancesConfigProperty to JSON
 *
 * @param property
 */
function InstancesConfigPropertyToJson(property) {
    return {
        AdditionalMasterSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalMasterSecurityGroups),
        AdditionalSlaveSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalSlaveSecurityGroups),
        Ec2KeyName: cdk.stringToCloudFormation(property.ec2KeyName),
        Ec2SubnetId: cdk.stringToCloudFormation(property.ec2SubnetId),
        Ec2SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(property.ec2SubnetIds),
        EmrManagedMasterSecurityGroup: cdk.stringToCloudFormation(property.emrManagedMasterSecurityGroup),
        EmrManagedSlaveSecurityGroup: cdk.stringToCloudFormation(property.emrManagedSlaveSecurityGroup),
        HadoopVersion: cdk.stringToCloudFormation(property.hadoopVersion),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceFleets: cdk.listMapper(InstanceFleetConfigPropertyToJson)(property.instanceFleets),
        InstanceGroups: cdk.listMapper(InstanceGroupConfigPropertyToJson)(property.instanceGroups),
        KeepJobFlowAliveWhenNoSteps: true,
        MasterInstanceType: cdk.stringToCloudFormation(property.masterInstanceType),
        Placement: property.placement === undefined ? property.placement : PlacementTypePropertyToJson(property.placement),
        ServiceAccessSecurityGroup: cdk.stringToCloudFormation(property.serviceAccessSecurityGroup),
        SlaveInstanceType: cdk.stringToCloudFormation(property.slaveInstanceType),
        TerminationProtected: cdk.booleanToCloudFormation(property.terminationProtected),
    };
}
exports.InstancesConfigPropertyToJson = InstancesConfigPropertyToJson;
/**
 * Render the ApplicationConfigProperty as JSON
 *
 * @param property
 */
function ApplicationConfigPropertyToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        Args: cdk.listMapper(cdk.stringToCloudFormation)(property.args),
        Version: cdk.stringToCloudFormation(property.version),
        AdditionalInfo: cdk.objectToCloudFormation(property.additionalInfo),
    };
}
exports.ApplicationConfigPropertyToJson = ApplicationConfigPropertyToJson;
/**
 * Render the ConfigurationProperty as JSON
 *
 * @param property
 */
function ConfigurationPropertyToJson(property) {
    return {
        Classification: cdk.stringToCloudFormation(property.classification),
        Properties: cdk.objectToCloudFormation(property.properties),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
    };
}
exports.ConfigurationPropertyToJson = ConfigurationPropertyToJson;
/**
 * Render the EbsBlockDeviceConfigProperty as JSON
 *
 * @param property
 */
function EbsBlockDeviceConfigPropertyToJson(property) {
    var _a, _b;
    return {
        VolumeSpecification: {
            Iops: cdk.numberToCloudFormation(property.volumeSpecification.iops),
            SizeInGB: (_a = property.volumeSpecification.volumeSize) === null || _a === void 0 ? void 0 : _a.toGibibytes(),
            VolumeType: cdk.stringToCloudFormation((_b = property.volumeSpecification.volumeType) === null || _b === void 0 ? void 0 : _b.valueOf()),
        },
        VolumesPerInstance: cdk.numberToCloudFormation(property.volumesPerInstance),
    };
}
exports.EbsBlockDeviceConfigPropertyToJson = EbsBlockDeviceConfigPropertyToJson;
/**
 * Render the EbsConfigurationProperty to JSON
 *
 * @param property
 */
function EbsConfigurationPropertyToJson(property) {
    return {
        EbsBlockDeviceConfigs: cdk.listMapper(EbsBlockDeviceConfigPropertyToJson)(property.ebsBlockDeviceConfigs),
        EbsOptimized: cdk.booleanToCloudFormation(property.ebsOptimized),
    };
}
exports.EbsConfigurationPropertyToJson = EbsConfigurationPropertyToJson;
/**
 * Render the InstanceTypeConfigProperty to JSON]
 *
 * @param property
 */
function InstanceTypeConfigPropertyToJson(property) {
    var _a;
    return {
        BidPrice: cdk.stringToCloudFormation(property.bidPrice),
        BidPriceAsPercentageOfOnDemandPrice: cdk.numberToCloudFormation(property.bidPriceAsPercentageOfOnDemandPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceType: cdk.stringToCloudFormation((_a = property.instanceType) === null || _a === void 0 ? void 0 : _a.valueOf()),
        WeightedCapacity: cdk.numberToCloudFormation(property.weightedCapacity),
    };
}
exports.InstanceTypeConfigPropertyToJson = InstanceTypeConfigPropertyToJson;
/**
 * Render the InstanceFleetProvisioningSpecificationsProperty to JSON
 *
 * @param property
 */
function InstanceFleetProvisioningSpecificationsPropertyToJson(property) {
    var _a;
    return {
        SpotSpecification: {
            BlockDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.blockDurationMinutes),
            TimeoutAction: cdk.stringToCloudFormation((_a = property.spotSpecification.timeoutAction) === null || _a === void 0 ? void 0 : _a.valueOf()),
            TimeoutDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.timeoutDurationMinutes),
        },
    };
}
exports.InstanceFleetProvisioningSpecificationsPropertyToJson = InstanceFleetProvisioningSpecificationsPropertyToJson;
/**
 * Render the InstanceFleetConfigProperty as JSON
 *
 * @param property
 */
function InstanceFleetConfigPropertyToJson(property) {
    var _a;
    return {
        InstanceFleetType: cdk.stringToCloudFormation((_a = property.instanceFleetType) === null || _a === void 0 ? void 0 : _a.valueOf()),
        InstanceTypeConfigs: cdk.listMapper(InstanceTypeConfigPropertyToJson)(property.instanceTypeConfigs),
        LaunchSpecifications: property.launchSpecifications === undefined
            ? property.launchSpecifications
            : InstanceFleetProvisioningSpecificationsPropertyToJson(property.launchSpecifications),
        Name: cdk.stringToCloudFormation(property.name),
        TargetOnDemandCapacity: cdk.numberToCloudFormation(property.targetOnDemandCapacity),
        TargetSpotCapacity: cdk.numberToCloudFormation(property.targetSpotCapacity),
    };
}
exports.InstanceFleetConfigPropertyToJson = InstanceFleetConfigPropertyToJson;
/**
 * Render the MetricDimensionProperty as JSON
 *
 * @param property
 */
function MetricDimensionPropertyToJson(property) {
    return {
        Key: cdk.stringToCloudFormation(property.key),
        Value: cdk.stringToCloudFormation(property.value),
    };
}
exports.MetricDimensionPropertyToJson = MetricDimensionPropertyToJson;
/**
 * Render the ScalingTriggerProperty to JSON
 *
 * @param property
 */
function ScalingTriggerPropertyToJson(property) {
    var _a, _b, _c;
    return {
        CloudWatchAlarmDefinition: {
            ComparisonOperator: cdk.stringToCloudFormation((_a = property.cloudWatchAlarmDefinition.comparisonOperator) === null || _a === void 0 ? void 0 : _a.valueOf()),
            Dimensions: cdk.listMapper(MetricDimensionPropertyToJson)(property.cloudWatchAlarmDefinition.dimensions),
            EvaluationPeriods: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.evaluationPeriods),
            MetricName: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.metricName),
            Namespace: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.namespace),
            Period: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.period.toSeconds()),
            Statistic: cdk.stringToCloudFormation((_b = property.cloudWatchAlarmDefinition.statistic) === null || _b === void 0 ? void 0 : _b.valueOf()),
            Threshold: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.threshold),
            Unit: cdk.stringToCloudFormation((_c = property.cloudWatchAlarmDefinition.unit) === null || _c === void 0 ? void 0 : _c.valueOf()),
        },
    };
}
exports.ScalingTriggerPropertyToJson = ScalingTriggerPropertyToJson;
/**
 * Render the ScalingActionProperty to JSON
 *
 * @param property
 */
function ScalingActionPropertyToJson(property) {
    var _a;
    return {
        Market: cdk.stringToCloudFormation((_a = property.market) === null || _a === void 0 ? void 0 : _a.valueOf()),
        SimpleScalingPolicyConfiguration: {
            AdjustmentType: cdk.stringToCloudFormation(property.simpleScalingPolicyConfiguration.adjustmentType),
            CoolDown: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.coolDown),
            ScalingAdjustment: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.scalingAdjustment),
        },
    };
}
exports.ScalingActionPropertyToJson = ScalingActionPropertyToJson;
/**
 * Render the ScalingRuleProperty to JSON
 *
 * @param property
 */
function ScalingRulePropertyToJson(property) {
    return {
        Action: ScalingActionPropertyToJson(property.action),
        Description: cdk.stringToCloudFormation(property.description),
        Name: cdk.stringToCloudFormation(property.name),
        Trigger: ScalingTriggerPropertyToJson(property.trigger),
    };
}
exports.ScalingRulePropertyToJson = ScalingRulePropertyToJson;
/**
 * Render the AutoScalingPolicyProperty to JSON
 *
 * @param property
 */
function AutoScalingPolicyPropertyToJson(property) {
    return {
        Constraints: {
            MaxCapacity: cdk.numberToCloudFormation(property.constraints.maxCapacity),
            MinCapacity: cdk.numberToCloudFormation(property.constraints.minCapacity),
        },
        Rules: cdk.listMapper(ScalingRulePropertyToJson)(property.rules),
    };
}
exports.AutoScalingPolicyPropertyToJson = AutoScalingPolicyPropertyToJson;
/**
 * Render the InstanceGroupConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupConfigPropertyToJson(property) {
    var _a, _b;
    return {
        AutoScalingPolicy: property.autoScalingPolicy === undefined ? property.autoScalingPolicy : AutoScalingPolicyPropertyToJson(property.autoScalingPolicy),
        BidPrice: cdk.numberToCloudFormation(property.bidPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceRole: cdk.stringToCloudFormation((_a = property.instanceRole) === null || _a === void 0 ? void 0 : _a.valueOf()),
        InstanceType: cdk.stringToCloudFormation(property.instanceType),
        Market: cdk.stringToCloudFormation((_b = property.market) === null || _b === void 0 ? void 0 : _b.valueOf()),
        Name: cdk.stringToCloudFormation(property.name),
    };
}
exports.InstanceGroupConfigPropertyToJson = InstanceGroupConfigPropertyToJson;
/**
 * Render the PlacementTypeProperty to JSON
 *
 * @param property
 */
function PlacementTypePropertyToJson(property) {
    return {
        AvailabilityZone: cdk.stringToCloudFormation(property.availabilityZone),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(property.availabilityZones),
    };
}
exports.PlacementTypePropertyToJson = PlacementTypePropertyToJson;
/**
 * Render the BootstrapActionProperty as JSON
 *
 * @param property
 */
function BootstrapActionConfigToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        ScriptBootstrapAction: {
            Path: cdk.stringToCloudFormation(property.scriptBootstrapAction.path),
            Args: cdk.listMapper(cdk.stringToCloudFormation)(property.scriptBootstrapAction.args),
        },
    };
}
exports.BootstrapActionConfigToJson = BootstrapActionConfigToJson;
/**
 * Render the InstanceGroupModifyConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupModifyConfigPropertyToJson(property) {
    return {
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        ShrinkPolicy: property.shrinkPolicy === undefined ? property.shrinkPolicy : ShrinkPolicyPropertyToJson(property.shrinkPolicy),
    };
}
exports.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
/**
 * Render the ShrinkPolicyProperty to JSON
 *
 * @param property
 */
function ShrinkPolicyPropertyToJson(property) {
    var _a;
    return {
        DecommissionTimeout: cdk.numberToCloudFormation((_a = property.decommissionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
        InstanceResizePolicy: property.instanceResizePolicy ? InstanceResizePolicyPropertyToJson(property.instanceResizePolicy) : undefined,
    };
}
/**
 * Render the InstanceResizePolicyProperty to JSON
 *
 * @param property
 */
function InstanceResizePolicyPropertyToJson(property) {
    var _a;
    return {
        InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
        InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
        InstanceTerminationTimeout: cdk.numberToCloudFormation((_a = property.instanceTerminationTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
    };
}
//# sourceMappingURL=data:application/json;base64,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