import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for EmrTerminateCluster.
 *
 * @stability stable
 */
export interface EmrTerminateClusterProps extends sfn.TaskStateBaseProps {
    /**
     * The ClusterId to terminate.
     *
     * @stability stable
     */
    readonly clusterId: string;
}
/**
 * A Step Functions Task to terminate an EMR Cluster.
 *
 * @stability stable
 */
export declare class EmrTerminateCluster extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @stability stable
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @stability stable
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    private readonly integrationPattern;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EmrTerminateClusterProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    /**
     * This generates the PolicyStatements required by the Task to call TerminateCluster.
     */
    private createPolicyStatements;
}
