# 🌌 CosmicLode

[![Python](https://img.shields.io/badge/python-3.10+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)
[![Build](https://img.shields.io/badge/build-passing-brightgreen)]()
[![Poetry](https://img.shields.io/badge/package-poetry-blue)](https://python-poetry.org/)

**CosmicLode** is a modular data pipeline framework designed for efficient, scalable, and transparent data processing. It supports database-agnostic connections, column-level profiling, and metadata visualization — all in a Pythonic package built for modern data engineers.

---

## 🚀 Features

- 🔌 **Pluggable database connectors** returning `pandas` DataFrames
- 📊 **Column-level profiling** with historical snapshot support
- 📈 **Data quality dashboards** using lightweight visualizations
- ⚙️ **Modular design** for reuse across workflows
- 🧪 Built-in **unit testing** with `pytest`

---

## 📦 Work in Progress Modules
| Module         | Description                                             |
|----------------|---------------------------------------------------------|
| `cosmic-nexus` | Unified interface to connect and query any database     |
| `cosmic-probe`| Generate & store profiling snapshots over time          |
| `stellar-map` | Streamlit or Dash-based UI for data quality monitoring  |

## 📌 Tech Stack

- **Python 3.10+**
- **SQLAlchemy**, **Pandas**
- **Poetry** for dependency management
- **Pytest** for testing
- **Streamlit**/**Dash** for visualizations *(planned)*


## 📝 License

This project is licensed under the [MIT License](LICENSE).

---

## ✨ Author

**Vinod Yerrapureddy**  
📧 [yerrapureddyvinodreddy@gmail.com](mailto:yerrapureddyvinodreddy@gmail.com)  
🌐 [vinodreddy.netlify.app](https://vinodreddy.netlify.app)  
🔗 [LinkedIn](https://www.linkedin.com/in/vinod-yerrapureddy-264938161/)  
🍥 Anime fan | 💻 Data engineer | 🛠️ Systems hacker
