# axmp-openapi-helper

![Platform Badge](https://img.shields.io/badge/platform-zmp-red)
![Component Badge](https://img.shields.io/badge/component-openapi_helper-red)
![CI Badge](https://img.shields.io/badge/ci-github_action-green)
![License Badge](https://img.shields.io/badge/license-MIT-green)
![PyPI - Version](https://img.shields.io/pypi/v/axmp-openapi-helper)
![PyPI - Implementation](https://img.shields.io/pypi/implementation/axmp-openapi-helper)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/axmp-openapi-helper)
![PyPI - Wheel](https://img.shields.io/pypi/wheel/axmp-openapi-helper)
![PyPI - Download](https://img.shields.io/pypi/dm/axmp-openapi-helper)

## Introduction

This is a openapi helper library for the ZMP AI Platform

## Key Features

- Support the OpenAPI Specification(>=3.0.0)
- Generate the Arguments Schema for the LLM

## Installation

Install using pip:

```bash
pip install axmp-openapi-helper
```

Install using poetry:
```bash
poetry add axmp-openapi-helper
```

## Development Setup

1. Clone the repository
```bash
git clone https://github.com/yourusername/axmp-openapi-helper.git
cd axmp-openapi-helper
```

2. Create and activate virtual environment
```bash
python -m venv .venv
source .venv/bin/activate  # Windows: venv\Scripts\activate
```

3. Install development dependencies
```bash
poetry install
```

## Contributing

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Contact

- Issue Tracker: https://github.com/cloudz-mp/axmp-openapi-helper/issues
- Email: kilsoo75@gmail.com


