# coding: utf-8

"""
    Connection Rest API 2.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 2.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ideastatica_connection_api.models.point3_d import Point3D
from ideastatica_connection_api.models.reference_element import ReferenceElement
from ideastatica_connection_api.models.vector3_d import Vector3D
from typing import Optional, Set
from typing_extensions import Self

class PinGrid(BaseModel):
    """
    Data of the pin grid
    """ # noqa: E501
    is_replaceable: Optional[StrictBool] = Field(default=None, description="Replaceable pin", alias="isReplaceable")
    pin: Optional[ReferenceElement] = None
    origin: Optional[Point3D] = None
    axis_x: Optional[Vector3D] = Field(default=None, alias="axisX")
    axis_y: Optional[Vector3D] = Field(default=None, alias="axisY")
    axis_z: Optional[Vector3D] = Field(default=None, alias="axisZ")
    positions: Optional[List[Point3D]] = Field(default=None, description="Positions of holes in the local coordinate system of the grid")
    connected_parts: Optional[List[ReferenceElement]] = Field(default=None, description="List of the connected parts", alias="connectedParts")
    name: Optional[StrictStr] = Field(default=None, description="Name")
    length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Length")
    id: Optional[StrictInt] = Field(default=None, description="Element Id")
    __properties: ClassVar[List[str]] = ["isReplaceable", "pin", "origin", "axisX", "axisY", "axisZ", "positions", "connectedParts", "name", "length", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PinGrid from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of pin
        if self.pin:
            _dict['pin'] = self.pin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of origin
        if self.origin:
            _dict['origin'] = self.origin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of axis_x
        if self.axis_x:
            _dict['axisX'] = self.axis_x.to_dict()
        # override the default output from pydantic by calling `to_dict()` of axis_y
        if self.axis_y:
            _dict['axisY'] = self.axis_y.to_dict()
        # override the default output from pydantic by calling `to_dict()` of axis_z
        if self.axis_z:
            _dict['axisZ'] = self.axis_z.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in positions (list)
        _items = []
        if self.positions:
            for _item_positions in self.positions:
                if _item_positions:
                    _items.append(_item_positions.to_dict())
            _dict['positions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in connected_parts (list)
        _items = []
        if self.connected_parts:
            for _item_connected_parts in self.connected_parts:
                if _item_connected_parts:
                    _items.append(_item_connected_parts.to_dict())
            _dict['connectedParts'] = _items
        # set to None if positions (nullable) is None
        # and model_fields_set contains the field
        if self.positions is None and "positions" in self.model_fields_set:
            _dict['positions'] = None

        # set to None if connected_parts (nullable) is None
        # and model_fields_set contains the field
        if self.connected_parts is None and "connected_parts" in self.model_fields_set:
            _dict['connectedParts'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PinGrid from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isReplaceable": obj.get("isReplaceable"),
            "pin": ReferenceElement.from_dict(obj["pin"]) if obj.get("pin") is not None else None,
            "origin": Point3D.from_dict(obj["origin"]) if obj.get("origin") is not None else None,
            "axisX": Vector3D.from_dict(obj["axisX"]) if obj.get("axisX") is not None else None,
            "axisY": Vector3D.from_dict(obj["axisY"]) if obj.get("axisY") is not None else None,
            "axisZ": Vector3D.from_dict(obj["axisZ"]) if obj.get("axisZ") is not None else None,
            "positions": [Point3D.from_dict(_item) for _item in obj["positions"]] if obj.get("positions") is not None else None,
            "connectedParts": [ReferenceElement.from_dict(_item) for _item in obj["connectedParts"]] if obj.get("connectedParts") is not None else None,
            "name": obj.get("name"),
            "length": obj.get("length"),
            "id": obj.get("id")
        })
        return _obj


