# coding: utf-8

"""
    Connection Rest API 2.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 2.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class IdeaParameterValidation(BaseModel):
    """
    IdeaParameterValidation
    """ # noqa: E501
    validation_expression: Optional[StrictStr] = Field(default=None, alias="validationExpression")
    validation_expression_evaluated: Optional[StrictBool] = Field(default=None, alias="validationExpressionEvaluated")
    lower_bound: Optional[StrictStr] = Field(default=None, alias="lowerBound")
    lower_bound_evaluated: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="lowerBoundEvaluated")
    upper_bound: Optional[StrictStr] = Field(default=None, alias="upperBound")
    upper_bound_evaluated: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="upperBoundEvaluated")
    validation_status: Optional[StrictStr] = Field(default=None, alias="validationStatus")
    message: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["validationExpression", "validationExpressionEvaluated", "lowerBound", "lowerBoundEvaluated", "upperBound", "upperBoundEvaluated", "validationStatus", "message"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IdeaParameterValidation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if validation_expression (nullable) is None
        # and model_fields_set contains the field
        if self.validation_expression is None and "validation_expression" in self.model_fields_set:
            _dict['validationExpression'] = None

        # set to None if lower_bound (nullable) is None
        # and model_fields_set contains the field
        if self.lower_bound is None and "lower_bound" in self.model_fields_set:
            _dict['lowerBound'] = None

        # set to None if upper_bound (nullable) is None
        # and model_fields_set contains the field
        if self.upper_bound is None and "upper_bound" in self.model_fields_set:
            _dict['upperBound'] = None

        # set to None if validation_status (nullable) is None
        # and model_fields_set contains the field
        if self.validation_status is None and "validation_status" in self.model_fields_set:
            _dict['validationStatus'] = None

        # set to None if message (nullable) is None
        # and model_fields_set contains the field
        if self.message is None and "message" in self.model_fields_set:
            _dict['message'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IdeaParameterValidation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "validationExpression": obj.get("validationExpression"),
            "validationExpressionEvaluated": obj.get("validationExpressionEvaluated"),
            "lowerBound": obj.get("lowerBound"),
            "lowerBoundEvaluated": obj.get("lowerBoundEvaluated"),
            "upperBound": obj.get("upperBound"),
            "upperBoundEvaluated": obj.get("upperBoundEvaluated"),
            "validationStatus": obj.get("validationStatus"),
            "message": obj.get("message")
        })
        return _obj


