# coding: utf-8

"""
    Connection Rest API 2.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 2.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from ideastatica_connection_api.models.line import Line
from ideastatica_connection_api.models.selected import Selected
from ideastatica_connection_api.models.text import Text
from typing import Optional, Set
from typing_extensions import Self

class IGroup(BaseModel):
    """
    IGroup
    """ # noqa: E501
    faces: Optional[List[StrictInt]] = None
    selected: Optional[Selected] = None
    lines: Optional[List[Line]] = None
    priority: Optional[StrictInt] = None
    text: Optional[List[Text]] = None
    __properties: ClassVar[List[str]] = ["faces", "selected", "lines", "priority", "text"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of selected
        if self.selected:
            _dict['selected'] = self.selected.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in lines (list)
        _items = []
        if self.lines:
            for _item_lines in self.lines:
                if _item_lines:
                    _items.append(_item_lines.to_dict())
            _dict['lines'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in text (list)
        _items = []
        if self.text:
            for _item_text in self.text:
                if _item_text:
                    _items.append(_item_text.to_dict())
            _dict['text'] = _items
        # set to None if faces (nullable) is None
        # and model_fields_set contains the field
        if self.faces is None and "faces" in self.model_fields_set:
            _dict['faces'] = None

        # set to None if lines (nullable) is None
        # and model_fields_set contains the field
        if self.lines is None and "lines" in self.model_fields_set:
            _dict['lines'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "faces": obj.get("faces"),
            "selected": Selected.from_dict(obj["selected"]) if obj.get("selected") is not None else None,
            "lines": [Line.from_dict(_item) for _item in obj["lines"]] if obj.get("lines") is not None else None,
            "priority": obj.get("priority"),
            "text": [Text.from_dict(_item) for _item in obj["text"]] if obj.get("text") is not None else None
        })
        return _obj


