# coding: utf-8

"""
    Connection Rest API 2.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 2.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from ideastatica_connection_api.models.concrete_setup import ConcreteSetup
from ideastatica_connection_api.models.cone_breakout_check_type import ConeBreakoutCheckType
from ideastatica_connection_api.models.crt_comp_check_is import CrtCompCheckIS
from ideastatica_connection_api.models.weld_evaluation import WeldEvaluation
from typing import Optional, Set
from typing_extensions import Self

class ConnectionSetup(BaseModel):
    """
    ConnectionSetup
    """ # noqa: E501
    steel_setup: Optional[Dict[str, Any]] = Field(default=None, description="ISteelSetup", alias="steelSetup")
    concrete_setup: Optional[ConcreteSetup] = Field(default=None, alias="concreteSetup")
    stop_at_limit_strain: Optional[StrictBool] = Field(default=None, description="Stop analysis when the limit strain is reached.", alias="stopAtLimitStrain")
    weld_evaluation_data: Optional[WeldEvaluation] = Field(default=None, alias="weldEvaluationData")
    check_detailing: Optional[StrictBool] = Field(default=None, description="Perform check of bolt positions", alias="checkDetailing")
    apply_cone_breakout_check: Optional[ConeBreakoutCheckType] = Field(default=None, alias="applyConeBreakoutCheck")
    pretension_force_fpc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Pretension force fpc = k * fub * As", alias="pretensionForceFpc")
    gamma_inst: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Partial safety factor of instalation safety", alias="gammaInst")
    gamma_c: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Partial safety factor of concrete", alias="gammaC")
    gamma_m3: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Preloaded bolts safety factor", alias="gammaM3")
    anchor_length_for_stiffness: Optional[StrictInt] = Field(default=None, description="Length of anchor to define the anchor stiffness in analysis model, as a multiple of anchor diameter (E A /n * [d])", alias="anchorLengthForStiffness")
    joint_beta_factor: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Joint coefficient βj - Used for Fjd calculation", alias="jointBetaFactor")
    effective_area_stress_coeff: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Effective area is taken from intersection of stress area and area of joined items according to EN1993-1-8 art. 6.2.5", alias="effectiveAreaStressCoeff")
    effective_area_stress_coeff_aisc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Effective area stress coefficient - Concrete loaded area: Stress cut-off is set for AISC", alias="effectiveAreaStressCoeffAISC")
    friction_coefficient: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Coefficient of friction between base plate and concrete block", alias="frictionCoefficient")
    limit_plastic_strain: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Limit of plastic strain used in 2D plate element check", alias="limitPlasticStrain")
    limit_deformation: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Limit deformation on closed sections", alias="limitDeformation")
    limit_deformation_check: Optional[StrictBool] = Field(default=None, description="Limit deformation on closed sections check or not", alias="limitDeformationCheck")
    analysis_gnl: Optional[StrictBool] = Field(default=None, description="Analysis with GNL", alias="analysisGNL")
    analysis_all_gnl: Optional[StrictBool] = Field(default=None, description="Analysis with All GNL", alias="analysisAllGNL")
    warn_plastic_strain: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Warning plastic strain", alias="warnPlasticStrain")
    warn_check_level: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Warning check level", alias="warnCheckLevel")
    optimal_check_level: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Optimal check level", alias="optimalCheckLevel")
    distance_between_bolts: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Limit distance between bolts as a multiple of bolt diameter", alias="distanceBetweenBolts")
    distance_diameter_between_bp: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Anchor pitch", alias="distanceDiameterBetweenBP")
    distance_between_bolts_edge: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Limit distance between bolt and plate edge as a multiple of bolt diameter", alias="distanceBetweenBoltsEdge")
    bearing_angle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Load distribution angle of concrete block in calculation of factor Kj", alias="bearingAngle")
    decreasing_ftrd: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Decreasing Ftrd of anchors. Worse quality influence", alias="decreasingFtrd")
    braced_system: Optional[StrictBool] = Field(default=None, description="Consider the frame system as braced for stiffness calculation. Braced system reduces horizontal displacements.", alias="bracedSystem")
    bearing_check: Optional[StrictBool] = Field(default=None, description="Apply bearing check including αb", alias="bearingCheck")
    apply_betap_influence: Optional[StrictBool] = Field(default=None, description="Apply βp influence in bolt shear resistance. ΕΝ 1993-1-8 chapter 3.6.1 (12)", alias="applyBetapInfluence")
    member_length_ratio: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="A multiple of cross-section height to determine the default length of member", alias="memberLengthRatio")
    division_of_surface_of_chs: Optional[StrictInt] = Field(default=None, description="Number of straight lines to substitute circle of circular tube in analysis model", alias="divisionOfSurfaceOfCHS")
    division_of_arcs_of_rhs: Optional[StrictInt] = Field(default=None, description="Number of straight lines to substitute corner arc of rectangular tubes in analysis model", alias="divisionOfArcsOfRHS")
    num_element: Optional[StrictInt] = Field(default=None, description="Ratio of length of decisive plate edge and Elements on edge count determines the average size of mesh element", alias="numElement")
    number_iterations: Optional[StrictInt] = Field(default=None, description="More iterations helps to find better solutions in contact elements but increases calculation time", alias="numberIterations")
    mdiv: Optional[StrictInt] = Field(default=None, description="Number of iteration steps to evaluate analysis divergence")
    min_size: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Minimal size of generated finite mesh element", alias="minSize")
    max_size: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Maximal size of generated finite mesh element", alias="maxSize")
    num_element_rhs: Optional[StrictInt] = Field(default=None, description="Number of mesh elements in RHS height", alias="numElementRhs")
    num_element_plate: Optional[StrictInt] = Field(default=None, description="Number of mesh elements on plates", alias="numElementPlate")
    rigid_bp: Optional[StrictBool] = Field(default=None, description="True if rigid base plate is considered", alias="rigidBP")
    alpha_cc: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Long-term effect on fcd", alias="alphaCC")
    cracked_concrete: Optional[StrictBool] = Field(default=None, description="True if cracked concrete is considered", alias="crackedConcrete")
    developed_fillers: Optional[StrictBool] = Field(default=None, description="True if developed fillers is considered", alias="developedFillers")
    deformation_bolt_hole: Optional[StrictBool] = Field(default=None, description="True if bolt hole deformation is considered", alias="deformationBoltHole")
    extension_length_ration_open_sections: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="ExtensionLengthRationOpenSections", alias="extensionLengthRationOpenSections")
    extension_length_ration_close_sections: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="ExtensionLengthRationCloseSections", alias="extensionLengthRationCloseSections")
    factor_preload_bolt: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="FactorPreloadBolt", alias="factorPreloadBolt")
    base_metal_capacity: Optional[StrictBool] = Field(default=None, description="BaseMetalCapacity", alias="baseMetalCapacity")
    apply_bearing_check: Optional[StrictBool] = Field(default=None, description="ApplyBearingCheck", alias="applyBearingCheck")
    friction_coefficient_pbolt: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Friction factor of slip-resistant joint", alias="frictionCoefficientPbolt")
    crt_comp_check_is: Optional[CrtCompCheckIS] = Field(default=None, alias="crtCompCheckIS")
    bolt_max_grip_length_coeff: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max value of bolt grip IND", alias="boltMaxGripLengthCoeff")
    fatigue_section_offset: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Fatigue section Offset = FatigueSectionOffset x Legsize", alias="fatigueSectionOffset")
    condensed_element_length_factor: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Condensed element length factor (CEF). Condensed beam legth = maxCssSize * CEF", alias="condensedElementLengthFactor")
    gamma_mu: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Partial safety factor for Horizontal tying", alias="gammaMu")
    hss_limit_plastic_strain: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Limit plastic strain for high strength steel", alias="hssLimitPlasticStrain")
    __properties: ClassVar[List[str]] = ["steelSetup", "concreteSetup", "stopAtLimitStrain", "weldEvaluationData", "checkDetailing", "applyConeBreakoutCheck", "pretensionForceFpc", "gammaInst", "gammaC", "gammaM3", "anchorLengthForStiffness", "jointBetaFactor", "effectiveAreaStressCoeff", "effectiveAreaStressCoeffAISC", "frictionCoefficient", "limitPlasticStrain", "limitDeformation", "limitDeformationCheck", "analysisGNL", "analysisAllGNL", "warnPlasticStrain", "warnCheckLevel", "optimalCheckLevel", "distanceBetweenBolts", "distanceDiameterBetweenBP", "distanceBetweenBoltsEdge", "bearingAngle", "decreasingFtrd", "bracedSystem", "bearingCheck", "applyBetapInfluence", "memberLengthRatio", "divisionOfSurfaceOfCHS", "divisionOfArcsOfRHS", "numElement", "numberIterations", "mdiv", "minSize", "maxSize", "numElementRhs", "numElementPlate", "rigidBP", "alphaCC", "crackedConcrete", "developedFillers", "deformationBoltHole", "extensionLengthRationOpenSections", "extensionLengthRationCloseSections", "factorPreloadBolt", "baseMetalCapacity", "applyBearingCheck", "frictionCoefficientPbolt", "crtCompCheckIS", "boltMaxGripLengthCoeff", "fatigueSectionOffset", "condensedElementLengthFactor", "gammaMu", "hssLimitPlasticStrain"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectionSetup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of concrete_setup
        if self.concrete_setup:
            _dict['concreteSetup'] = self.concrete_setup.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectionSetup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "steelSetup": obj.get("steelSetup"),
            "concreteSetup": ConcreteSetup.from_dict(obj["concreteSetup"]) if obj.get("concreteSetup") is not None else None,
            "stopAtLimitStrain": obj.get("stopAtLimitStrain"),
            "weldEvaluationData": obj.get("weldEvaluationData"),
            "checkDetailing": obj.get("checkDetailing"),
            "applyConeBreakoutCheck": obj.get("applyConeBreakoutCheck"),
            "pretensionForceFpc": obj.get("pretensionForceFpc"),
            "gammaInst": obj.get("gammaInst"),
            "gammaC": obj.get("gammaC"),
            "gammaM3": obj.get("gammaM3"),
            "anchorLengthForStiffness": obj.get("anchorLengthForStiffness"),
            "jointBetaFactor": obj.get("jointBetaFactor"),
            "effectiveAreaStressCoeff": obj.get("effectiveAreaStressCoeff"),
            "effectiveAreaStressCoeffAISC": obj.get("effectiveAreaStressCoeffAISC"),
            "frictionCoefficient": obj.get("frictionCoefficient"),
            "limitPlasticStrain": obj.get("limitPlasticStrain"),
            "limitDeformation": obj.get("limitDeformation"),
            "limitDeformationCheck": obj.get("limitDeformationCheck"),
            "analysisGNL": obj.get("analysisGNL"),
            "analysisAllGNL": obj.get("analysisAllGNL"),
            "warnPlasticStrain": obj.get("warnPlasticStrain"),
            "warnCheckLevel": obj.get("warnCheckLevel"),
            "optimalCheckLevel": obj.get("optimalCheckLevel"),
            "distanceBetweenBolts": obj.get("distanceBetweenBolts"),
            "distanceDiameterBetweenBP": obj.get("distanceDiameterBetweenBP"),
            "distanceBetweenBoltsEdge": obj.get("distanceBetweenBoltsEdge"),
            "bearingAngle": obj.get("bearingAngle"),
            "decreasingFtrd": obj.get("decreasingFtrd"),
            "bracedSystem": obj.get("bracedSystem"),
            "bearingCheck": obj.get("bearingCheck"),
            "applyBetapInfluence": obj.get("applyBetapInfluence"),
            "memberLengthRatio": obj.get("memberLengthRatio"),
            "divisionOfSurfaceOfCHS": obj.get("divisionOfSurfaceOfCHS"),
            "divisionOfArcsOfRHS": obj.get("divisionOfArcsOfRHS"),
            "numElement": obj.get("numElement"),
            "numberIterations": obj.get("numberIterations"),
            "mdiv": obj.get("mdiv"),
            "minSize": obj.get("minSize"),
            "maxSize": obj.get("maxSize"),
            "numElementRhs": obj.get("numElementRhs"),
            "numElementPlate": obj.get("numElementPlate"),
            "rigidBP": obj.get("rigidBP"),
            "alphaCC": obj.get("alphaCC"),
            "crackedConcrete": obj.get("crackedConcrete"),
            "developedFillers": obj.get("developedFillers"),
            "deformationBoltHole": obj.get("deformationBoltHole"),
            "extensionLengthRationOpenSections": obj.get("extensionLengthRationOpenSections"),
            "extensionLengthRationCloseSections": obj.get("extensionLengthRationCloseSections"),
            "factorPreloadBolt": obj.get("factorPreloadBolt"),
            "baseMetalCapacity": obj.get("baseMetalCapacity"),
            "applyBearingCheck": obj.get("applyBearingCheck"),
            "frictionCoefficientPbolt": obj.get("frictionCoefficientPbolt"),
            "crtCompCheckIS": obj.get("crtCompCheckIS"),
            "boltMaxGripLengthCoeff": obj.get("boltMaxGripLengthCoeff"),
            "fatigueSectionOffset": obj.get("fatigueSectionOffset"),
            "condensedElementLengthFactor": obj.get("condensedElementLengthFactor"),
            "gammaMu": obj.get("gammaMu"),
            "hssLimitPlasticStrain": obj.get("hssLimitPlasticStrain")
        })
        return _obj


