# printnanny_api_client.SettingsApi

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**alert_settings_email_create**](SettingsApi.md#alert_settings_email_create) | **POST** /api/alert-settings/email/ | 
[**alert_settings_email_list**](SettingsApi.md#alert_settings_email_list) | **GET** /api/alert-settings/email/ | 
[**alert_settings_email_partial_update**](SettingsApi.md#alert_settings_email_partial_update) | **PATCH** /api/alert-settings/email/{id}/ | 
[**alert_settings_email_retrieve**](SettingsApi.md#alert_settings_email_retrieve) | **GET** /api/alert-settings/email/{id}/ | 
[**alert_settings_email_update**](SettingsApi.md#alert_settings_email_update) | **PUT** /api/alert-settings/email/{id}/ | 


# **alert_settings_email_create**
> EmailAlertSettings alert_settings_email_create(email_alert_settings_request=email_alert_settings_request)



### Example

* Bearer Authentication (tokenAuth):
```python
from __future__ import print_function
import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.SettingsApi(api_client)
    email_alert_settings_request = printnanny_api_client.EmailAlertSettingsRequest() # EmailAlertSettingsRequest |  (optional)

    try:
        api_response = api_instance.alert_settings_email_create(email_alert_settings_request=email_alert_settings_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling SettingsApi->alert_settings_email_create: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email_alert_settings_request** | [**EmailAlertSettingsRequest**](EmailAlertSettingsRequest.md)|  | [optional] 

### Return type

[**EmailAlertSettings**](EmailAlertSettings.md)

### Authorization

[tokenAuth](../README.md#tokenAuth)

### HTTP request headers

 - **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** |  |  -  |
**409** |  |  -  |
**400** |  |  -  |
**401** |  |  -  |
**403** |  |  -  |
**500** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **alert_settings_email_list**
> PaginatedEmailAlertSettingsList alert_settings_email_list(page=page)



### Example

* Bearer Authentication (tokenAuth):
```python
from __future__ import print_function
import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.SettingsApi(api_client)
    page = 56 # int | A page number within the paginated result set. (optional)

    try:
        api_response = api_instance.alert_settings_email_list(page=page)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling SettingsApi->alert_settings_email_list: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page** | **int**| A page number within the paginated result set. | [optional] 

### Return type

[**PaginatedEmailAlertSettingsList**](PaginatedEmailAlertSettingsList.md)

### Authorization

[tokenAuth](../README.md#tokenAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** |  |  -  |
**400** |  |  -  |
**401** |  |  -  |
**403** |  |  -  |
**500** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **alert_settings_email_partial_update**
> EmailAlertSettings alert_settings_email_partial_update(id, patched_email_alert_settings_request=patched_email_alert_settings_request)



### Example

* Bearer Authentication (tokenAuth):
```python
from __future__ import print_function
import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.SettingsApi(api_client)
    id = 56 # int | A unique integer value identifying this email alert settings.
patched_email_alert_settings_request = printnanny_api_client.PatchedEmailAlertSettingsRequest() # PatchedEmailAlertSettingsRequest |  (optional)

    try:
        api_response = api_instance.alert_settings_email_partial_update(id, patched_email_alert_settings_request=patched_email_alert_settings_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling SettingsApi->alert_settings_email_partial_update: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| A unique integer value identifying this email alert settings. | 
 **patched_email_alert_settings_request** | [**PatchedEmailAlertSettingsRequest**](PatchedEmailAlertSettingsRequest.md)|  | [optional] 

### Return type

[**EmailAlertSettings**](EmailAlertSettings.md)

### Authorization

[tokenAuth](../README.md#tokenAuth)

### HTTP request headers

 - **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** |  |  -  |
**409** |  |  -  |
**400** |  |  -  |
**401** |  |  -  |
**403** |  |  -  |
**500** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **alert_settings_email_retrieve**
> EmailAlertSettings alert_settings_email_retrieve(id)



### Example

* Bearer Authentication (tokenAuth):
```python
from __future__ import print_function
import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.SettingsApi(api_client)
    id = 56 # int | A unique integer value identifying this email alert settings.

    try:
        api_response = api_instance.alert_settings_email_retrieve(id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling SettingsApi->alert_settings_email_retrieve: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| A unique integer value identifying this email alert settings. | 

### Return type

[**EmailAlertSettings**](EmailAlertSettings.md)

### Authorization

[tokenAuth](../README.md#tokenAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **alert_settings_email_update**
> EmailAlertSettings alert_settings_email_update(id, email_alert_settings_request=email_alert_settings_request)



### Example

* Bearer Authentication (tokenAuth):
```python
from __future__ import print_function
import time
import printnanny_api_client
from printnanny_api_client.rest import ApiException
from pprint import pprint
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = printnanny_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: tokenAuth
configuration = printnanny_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with printnanny_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = printnanny_api_client.SettingsApi(api_client)
    id = 56 # int | A unique integer value identifying this email alert settings.
email_alert_settings_request = printnanny_api_client.EmailAlertSettingsRequest() # EmailAlertSettingsRequest |  (optional)

    try:
        api_response = api_instance.alert_settings_email_update(id, email_alert_settings_request=email_alert_settings_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling SettingsApi->alert_settings_email_update: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| A unique integer value identifying this email alert settings. | 
 **email_alert_settings_request** | [**EmailAlertSettingsRequest**](EmailAlertSettingsRequest.md)|  | [optional] 

### Return type

[**EmailAlertSettings**](EmailAlertSettings.md)

### Authorization

[tokenAuth](../README.md#tokenAuth)

### HTTP request headers

 - **Content-Type**: application/json, application/x-www-form-urlencoded, multipart/form-data
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**202** |  |  -  |
**409** |  |  -  |
**400** |  |  -  |
**401** |  |  -  |
**403** |  |  -  |
**500** |  |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

