import mysql.connector
from mysql.connector import Error

class MySQLConnection:

    def __init__(self,host,user,password,database):
        self.host=host
        self.user=user 
        self.password=password
        self.database=database
        self.connection=None
    
    def connect(self):
        """Establish a connection to the MySQL database."""
        try:
            self.connection = mysql.connector.connect(
                host=self.host,
                user=self.user,
                password=self.password,
                database=self.database
            )
            if self.connection.is_connected():
                print(f"Successfully connected to the database: {self.database}")
                return self.connection
        except Error as e:
            print(f"Error while connecting to MySQL: {e}")
            return None
        
    def close(self):
        """Close the database connection."""
        if self.connection and self.connection.is_connected():
            self.connection.close()
            print("MySQL connection closed.")
