# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DescribeDeployDetailsRequest(JDCloudRequest):
    """
    查询APP部署列表
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(DescribeDeployDetailsRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/hardwareId/{hardwareId}/os/{osId}/edgeApp:describeDeployDetails', 'POST', header, version)
        self.parameters = parameters


class DescribeDeployDetailsParameters(object):

    def __init__(self, instanceId, regionId, hardwareId, osId, appName, ):
        """
        :param instanceId: 设备归属的实例ID
        :param regionId: 设备归属的实例所在区域
        :param hardwareId: 硬件版本
        :param osId: OSID
        :param appName: Edge名称
        """

        self.instanceId = instanceId
        self.regionId = regionId
        self.hardwareId = hardwareId
        self.osId = osId
        self.appName = appName
        self.nowPage = None
        self.pageSize = None
        self.order = None
        self.property = None
        self.searchText = None

    def setNowPage(self, nowPage):
        """
        :param nowPage: (Optional) 当前的规则位置
        """
        self.nowPage = nowPage

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 显示多少个数据
        """
        self.pageSize = pageSize

    def setOrder(self, order):
        """
        :param order: (Optional) 排序方式
        """
        self.order = order

    def setProperty(self, property):
        """
        :param property: (Optional) 排序依据的关键词
        """
        self.property = property

    def setSearchText(self, searchText):
        """
        :param searchText: (Optional) 模糊搜索关键字
        """
        self.searchText = searchText

