# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class FindDeviceGroupLinkPageRequest(JDCloudRequest):
    """
    获取分组列表
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(FindDeviceGroupLinkPageRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/devicegrouplink:get', 'GET', header, version)
        self.parameters = parameters


class FindDeviceGroupLinkPageParameters(object):

    def __init__(self, instanceId, regionId, ):
        """
        :param instanceId: 设备归属的实例ID
        :param regionId: 设备归属的实例所在区域
        """

        self.instanceId = instanceId
        self.regionId = regionId
        self.productKey = None
        self.deviceName = None
        self.deviceCollectorType = None
        self.groupName = None
        self.userPin = None
        self.tag = None
        self.groupId = None
        self.manufacturer = None
        self.model = None
        self.orderId = None
        self.status = None
        self.pageNumber = None
        self.pageSize = None
        self.order = None
        self.direction = None

    def setProductKey(self, productKey):
        """
        :param productKey: (Optional) 产品Key
        """
        self.productKey = productKey

    def setDeviceName(self, deviceName):
        """
        :param deviceName: (Optional) 设备名称
        """
        self.deviceName = deviceName

    def setDeviceCollectorType(self, deviceCollectorType):
        """
        :param deviceCollectorType: (Optional) 采集器类型
        """
        self.deviceCollectorType = deviceCollectorType

    def setGroupName(self, groupName):
        """
        :param groupName: (Optional) 组名称
        """
        self.groupName = groupName

    def setUserPin(self, userPin):
        """
        :param userPin: (Optional) 查询的用户组
        """
        self.userPin = userPin

    def setTag(self, tag):
        """
        :param tag: (Optional) 组标签
        """
        self.tag = tag

    def setGroupId(self, groupId):
        """
        :param groupId: (Optional) 组ID
        """
        self.groupId = groupId

    def setManufacturer(self, manufacturer):
        """
        :param manufacturer: (Optional) 厂商名称
        """
        self.manufacturer = manufacturer

    def setModel(self, model):
        """
        :param model: (Optional) 设备型号
        """
        self.model = model

    def setOrderId(self, orderId):
        """
        :param orderId: (Optional) 订单号
        """
        self.orderId = orderId

    def setStatus(self, status):
        """
        :param status: (Optional) 设备状态
        """
        self.status = status

    def setPageNumber(self, pageNumber):
        """
        :param pageNumber: (Optional) 当前页码
        """
        self.pageNumber = pageNumber

    def setPageSize(self, pageSize):
        """
        :param pageSize: (Optional) 每页大小
        """
        self.pageSize = pageSize

    def setOrder(self, order):
        """
        :param order: (Optional) 排序字段
        """
        self.order = order

    def setDirection(self, direction):
        """
        :param direction: (Optional) 排序方式（asc desc）
        """
        self.direction = direction

