"""Stub file for cartesian.py"""
# ------------------- DO NOT EDIT ----------------------
# This file was generated by `scripts/pyi_generator.py`!
# ------------------------------------------------------

from typing import Any, Dict, List, Literal, Optional, Union, overload
from nextpy.components.component import Component
from nextpy.components.graphing.recharts.recharts import Recharts
from nextpy.core.vars import Var, BaseVar, ComputedVar
from nextpy.core.event import EventHandler, EventChain, EventSpec

class Axis(Recharts):
    @overload
    @classmethod
    def create(cls, *children, data_key: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, hide: Optional[Union[Var[bool], bool]] = None, orientation: Optional[Union[Var[Literal["top", "bottom"]], Literal["top", "bottom"]]] = None, type_: Optional[Union[Var[Literal["number", "category"]], Literal["number", "category"]]] = None, allow_decimals: Optional[Union[Var[bool], bool]] = None, allow_data_overflow: Optional[Union[Var[bool], bool]] = None, allow_duplicated_category: Optional[Union[Var[bool], bool]] = None, axis_line: Optional[Union[Var[bool], bool]] = None, tick_line: Optional[Union[Var[bool], bool]] = None, mirror: Optional[Union[Var[bool], bool]] = None, reversed: Optional[Union[Var[bool], bool]] = None, scale: Optional[Union[Var[Literal["auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utc", "sequential", "threshold"]], Literal["auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utc", "sequential", "threshold"]]] = None, unit: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, name: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Axis":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of a group of data which should be unique in an area chart.
            hide: If set true, the axis do not display in the chart.
            orientation: The orientation of axis 'top' | 'bottom'
            type_: The type of axis 'number' | 'category'
            allow_decimals: Allow the ticks of XAxis to be decimals or not.
            allow_data_overflow: When domain of the axis is specified and the type of the axis is 'number', if allowDataOverflow is set to be false, the domain will be adjusted when the minimum value of data is smaller than domain[0] or the maximum value of data is greater than domain[1] so that the axis displays all data values. If set to true, graphic elements (line, area, bars) will be clipped to conform to the specified domain.
            allow_duplicated_category: Allow the axis has duplicated categorys or not when the type of axis is "category".
            axis_line: If set false, no axis line will be drawn. If set a object, the option is the configuration of axis line.
            tick_line: If set false, no axis tick lines will be drawn. If set a object, the option is the configuration of tick lines.
            mirror: If set true, flips ticks around the axis line, displaying the labels inside the chart instead of outside.
            reversed: Reverse the ticks or not.
            scale: If 'auto' set, the scale function is decided by the type of chart, and the props type. 'auto' | 'linear' | 'pow' | 'sqrt' | 'log' | 'identity' | 'time' | 'band' | 'point' | 'ordinal' | 'quantile' | 'quantize' | 'utc' | 'sequential' | 'threshold' | Function
            unit: The unit of data displayed in the axis. This option will be used to represent an index unit in a scatter chart.
            name: The name of data displayed in the axis. This option will be used to represent an index in a scatter chart.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class XAxis(Axis):
    @overload
    @classmethod
    def create(cls, *children, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "XAxis":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class YAxis(Axis):
    @overload
    @classmethod
    def create(cls, *children, data_key: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "YAxis":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of data displayed in the axis.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class ZAxis(Recharts):
    @overload
    @classmethod
    def create(cls, *children, data_key: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, range: Optional[Union[Var[List[int]], List[int]]] = None, unit: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, name: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, scale: Optional[Union[Var[Literal["auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utc", "sequential", "threshold"]], Literal["auto", "linear", "pow", "sqrt", "log", "identity", "time", "band", "point", "ordinal", "quantile", "quantize", "utc", "sequential", "threshold"]]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "ZAxis":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            data_key: The key of data displayed in the axis.
            range: The range of axis.
            unit: The unit of data displayed in the axis. This option will be used to represent an index unit in a scatter chart.
            name: The name of data displayed in the axis. This option will be used to represent an index in a scatter chart.
            scale: If 'auto' set, the scale function is decided by the type of chart, and the props type.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Brush(Recharts):
    @overload
    @classmethod
    def create(cls, *children, stroke: Optional[Union[Var[str], str]] = None, data_key: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, x: Optional[Union[Var[int], int]] = None, y: Optional[Union[Var[int], int]] = None, width: Optional[Union[Var[int], int]] = None, height: Optional[Union[Var[int], int]] = None, data: Optional[Union[Var[List[Any]], List[Any]]] = None, traveller_width: Optional[Union[Var[int], int]] = None, gap: Optional[Union[Var[int], int]] = None, start_index: Optional[Union[Var[int], int]] = None, end_index: Optional[Union[Var[int], int]] = None, on_change: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Brush":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: Stroke color
            data_key: The key of data displayed in the axis.
            x: The x-coordinate of brush.
            y: The y-coordinate of brush.
            width: The width of brush.
            height: The height of brush.
            data: The data domain of brush, [min, max].
            traveller_width: The width of each traveller.
            gap: The data with gap of refreshing chart. If the option is not set, the chart will be refreshed every time
            start_index: The default start index of brush. If the option is not set, the start index will be 0.
            end_index: The default end index of brush. If the option is not set, the end index will be 1.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Cartesian(Recharts):
    @overload
    @classmethod
    def create(cls, *children, layout: Optional[Union[Var[Literal["horizontal", "vertical"]], Literal["horizontal", "vertical"]]] = None, data_key: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, x_axis_id: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, y_axis_id: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Cartesian":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            layout: The layout of bar in the chart, usually inherited from parent. 'horizontal' | 'vertical'
            data_key: The key of a group of data which should be unique in an area chart.
            x_axis_id: The id of x-axis which is corresponding to the data.
            y_axis_id: The id of y-axis which is corresponding to the data.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Area(Cartesian):
    @overload
    @classmethod
    def create(cls, *children, stroke: Optional[Union[Var[str], str]] = None, stroke_width: Optional[Union[Var[int], int]] = None, fill: Optional[Union[Var[str], str]] = None, type_: Optional[Union[Var[Literal["basis", "basisClosed", "basisOpen", "bumpX", "bumpY", "bump", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter"]], Literal["basis", "basisClosed", "basisOpen", "bumpX", "bumpY", "bump", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter"]]] = None, dot: Optional[Union[Var[bool], bool]] = None, active_dot: Optional[Union[Var[bool], bool]] = None, label: Optional[Union[Var[bool], bool]] = None, stack_id: Optional[Union[Var[str], str]] = None, valid_children: Optional[List[str]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Area":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: The color of the line stroke.
            stroke_width: The width of the line stroke.
            fill: The color of the area fill.
            type_: The interpolation type of area. And customized interpolation function can be set to type. 'basis' | 'basisClosed' | 'basisOpen' | 'bumpX' | 'bumpY' | 'bump' | 'linear' | 'linearClosed' | 'natural' | 'monotoneX' | 'monotoneY' | 'monotone' | 'step' | 'stepBefore' | 'stepAfter' |
            dot: If false set, dots will not be drawn. If true set, dots will be drawn which have the props calculated internally.
            active_dot: The dot is shown when user enter an area chart and this chart has tooltip. If false set, no active dot will not be drawn. If true set, active dot will be drawn which have the props calculated internally.
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally.
            stack_id: The stack id of area, when two areas have the same value axis and same stackId, then the two areas area stacked in order.
            valid_children: Valid children components
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Bar(Cartesian):
    @overload
    @classmethod
    def create(cls, *children, stroke: Optional[Union[Var[str], str]] = None, stroke_width: Optional[Union[Var[int], int]] = None, fill: Optional[Union[Var[str], str]] = None, background: Optional[Union[Var[bool], bool]] = None, label: Optional[Union[Var[bool], bool]] = None, stack_id: Optional[Union[Var[str], str]] = None, bar_size: Optional[Union[Var[int], int]] = None, max_bar_size: Optional[Union[Var[int], int]] = None, valid_children: Optional[List[str]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Bar":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: The color of the line stroke.
            stroke_width: The width of the line stroke.
            fill: The width of the line stroke.
            background: If false set, background of bars will not be drawn. If true set, background of bars will be drawn which have the props calculated internally.
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally.
            stack_id: The stack id of bar, when two areas have the same value axis and same stackId, then the two areas area stacked in order.
            bar_size: Size of the bar
            max_bar_size: Max size of the bar
            valid_children: Valid children components
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Line(Cartesian):
    @overload
    @classmethod
    def create(cls, *children, type_: Optional[Union[Var[Literal["basis", "basisClosed", "basisOpen", "bumpX", "bumpY", "bump", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter"]], Literal["basis", "basisClosed", "basisOpen", "bumpX", "bumpY", "bump", "linear", "linearClosed", "natural", "monotoneX", "monotoneY", "monotone", "step", "stepBefore", "stepAfter"]]] = None, stroke: Optional[Union[Var[str], str]] = None, stoke_width: Optional[Union[Var[int], int]] = None, dot: Optional[Union[Var[bool], bool]] = None, active_dot: Optional[Union[Var[bool], bool]] = None, label: Optional[Union[Var[bool], bool]] = None, hide: Optional[Union[Var[bool], bool]] = None, connect_nulls: Optional[Union[Var[bool], bool]] = None, valid_children: Optional[List[str]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Line":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            type_: The interpolation type of line. And customized interpolation function can be set to type. It's the same as type in Area.
            stroke: The color of the line stroke.
            stoke_width: The width of the line stroke.
            dot: The dot is shown when mouse enter a line chart and this chart has tooltip. If false set, no active dot will not be drawn. If true set, active dot will be drawn which have the props calculated internally.
            active_dot: The dot is shown when user enter an area chart and this chart has tooltip. If false set, no active dot will not be drawn. If true set, active dot will be drawn which have the props calculated internally.
            label: If false set, labels will not be drawn. If true set, labels will be drawn which have the props calculated internally.
            hide: Hides the line when true, useful when toggling visibility state via legend.
            connect_nulls: Whether to connect a graph line across null points.
            valid_children: Valid children components
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Scatter(Cartesian):
    @overload
    @classmethod
    def create(cls, *children, data: Optional[Union[Var[List[Dict[str, Any]]], List[Dict[str, Any]]]] = None, z_axis_id: Optional[Union[Var[str], str]] = None, line: Optional[Union[Var[bool], bool]] = None, shape: Optional[Union[Var[Literal["square", "circle", "cross", "diamond", "star", "triangle", "wye"]], Literal["square", "circle", "cross", "diamond", "star", "triangle", "wye"]]] = None, line_type: Optional[Union[Var[Literal["joint", "fitting"]], Literal["joint", "fitting"]]] = None, fill: Optional[Union[Var[str], str]] = None, name: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, valid_children: Optional[List[str]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Scatter":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            data: The source data, in which each element is an object.
            z_axis_id: The id of z-axis which is corresponding to the data.
            line: If false set, line will not be drawn. If true set, line will be drawn which have the props calculated internally.
            shape: If a string set, specified symbol will be used to show scatter item. 'circle' | 'cross' | 'diamond' | 'square' | 'star' | 'triangle' | 'wye'
            line_type: If 'joint' set, line will generated by just jointing all the points. If 'fitting' set, line will be generated by fitting algorithm. 'joint' | 'fitting'
            fill: The fill
            name: the name
            valid_children: Valid children components.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Funnel(Cartesian):
    @overload
    @classmethod
    def create(cls, *children, data: Optional[Union[Var[List[Dict[str, Any]]], List[Dict[str, Any]]]] = None, animation_begin: Optional[Union[Var[int], int]] = None, animation_duration: Optional[Union[Var[int], int]] = None, animation_easing: Optional[Union[Var[Literal["ease", "ease-in", "ease-out", "ease-in-out", "linear"]], Literal["ease", "ease-in", "ease-out", "ease-in-out", "linear"]]] = None, valid_children: Optional[List[str]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Funnel":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            data: The source data, in which each element is an object.
            animation_begin: Specifies when the animation should begin, the unit of this option is ms.
            animation_duration: Specifies the duration of animation, the unit of this option is ms.
            animation_easing: The type of easing function. 'ease' | 'ease-in' | 'ease-out' | 'ease-in-out' | 'linear'
            valid_children: Valid children components
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class ErrorBar(Recharts):
    @overload
    @classmethod
    def create(cls, *children, direction: Optional[Union[Var[Literal["x", "y", "both"]], Literal["x", "y", "both"]]] = None, data_key: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, width: Optional[Union[Var[int], int]] = None, stroke: Optional[Union[Var[str], str]] = None, stroke_width: Optional[Union[Var[int], int]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "ErrorBar":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            direction: The direction of error bar. 'x' | 'y' | 'both'
            data_key: The key of a group of data which should be unique in an area chart.
            width: The width of the error bar ends.
            stroke: The stroke color of error bar.
            stroke_width: The stroke width of error bar.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Reference(Recharts):
    @overload
    @classmethod
    def create(cls, *children, x_axis_id: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, y_axis_id: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, x: Optional[Union[Var[str], str]] = None, y: Optional[Union[Var[str], str]] = None, if_overflow: Optional[Union[Var[Literal["discard", "hidden", "visible", "extendDomain"]], Literal["discard", "hidden", "visible", "extendDomain"]]] = None, is_front: Optional[Union[Var[bool], bool]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Reference":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            x_axis_id: The id of x-axis which is corresponding to the data.
            y_axis_id: The id of y-axis which is corresponding to the data.
            x: If set a string or a number, a vertical line perpendicular to the x-axis specified by xAxisId will be drawn. If the specified x-axis is a number axis, the type of x must be Number. If the specified x-axis is a category axis, the value of x must be one of the categorys, otherwise no line will be drawn.
            y: If set a string or a number, a horizontal line perpendicular to the y-axis specified by yAxisId will be drawn. If the specified y-axis is a number axis, the type of y must be Number. If the specified y-axis is a category axis, the value of y must be one of the categorys, otherwise no line will be drawn.
            if_overflow: Defines how to draw the reference line if it falls partly outside the canvas. If set to 'discard', the reference line will not be drawn at all. If set to 'hidden', the reference line will be clipped to the canvas. If set to 'visible', the reference line will be drawn completely. If set to 'extendDomain', the domain of the overflown axis will be extended such that the reference line fits into the canvas.
            is_front: If set true, the line will be rendered in front of bars in BarChart, etc.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class ReferenceLine(Reference):
    @overload
    @classmethod
    def create(cls, *children, stroke_width: Optional[Union[Var[int], int]] = None, valid_children: Optional[List[str]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "ReferenceLine":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            stroke_width: The width of the stroke.
            valid_children: Valid children components
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class ReferenceDot(Reference):
    @overload
    @classmethod
    def create(cls, *children, valid_children: Optional[List[str]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "ReferenceDot":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            valid_children: Valid children components
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class ReferenceArea(Recharts):
    @overload
    @classmethod
    def create(cls, *children, stroke: Optional[Union[Var[str], str]] = None, fill: Optional[Union[Var[str], str]] = None, fill_opacity: Optional[Union[Var[float], float]] = None, x_axis_id: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, y_axis_id: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, x1: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, x2: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, y1: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, y2: Optional[Union[Var[Union[str, int]], Union[str, int]]] = None, if_overflow: Optional[Union[Var[Literal["discard", "hidden", "visible", "extendDomain"]], Literal["discard", "hidden", "visible", "extendDomain"]]] = None, is_front: Optional[Union[Var[bool], bool]] = None, valid_children: Optional[List[str]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "ReferenceArea":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            stroke: Stroke color
            fill: Fill color
            fill_opacity: The opacity of area.
            x_axis_id: The id of x-axis which is corresponding to the data.
            y_axis_id: The id of y-axis which is corresponding to the data.
            x1: A boundary value of the area. If the specified x-axis is a number axis, the type of x must be Number. If the specified x-axis is a category axis, the value of x must be one of the categorys. If one of x1 or x2 is invalidate, the area will cover along x-axis.
            x2: A boundary value of the area. If the specified x-axis is a number axis, the type of x must be Number. If the specified x-axis is a category axis, the value of x must be one of the categorys. If one of x1 or x2 is invalidate, the area will cover along x-axis.
            y1: A boundary value of the area. If the specified y-axis is a number axis, the type of y must be Number. If the specified y-axis is a category axis, the value of y must be one of the categorys. If one of y1 or y2 is invalidate, the area will cover along y-axis.
            y2: A boundary value of the area. If the specified y-axis is a number axis, the type of y must be Number. If the specified y-axis is a category axis, the value of y must be one of the categorys. If one of y1 or y2 is invalidate, the area will cover along y-axis.
            if_overflow: Defines how to draw the reference line if it falls partly outside the canvas. If set to 'discard', the reference line will not be drawn at all. If set to 'hidden', the reference line will be clipped to the canvas. If set to 'visible', the reference line will be drawn completely. If set to 'extendDomain', the domain of the overflown axis will be extended such that the reference line fits into the canvas.
            is_front: If set true, the line will be rendered in front of bars in BarChart, etc.
            valid_children: Valid children components
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class Grid(Recharts):
    @overload
    @classmethod
    def create(cls, *children, x: Optional[Union[Var[int], int]] = None, y: Optional[Union[Var[int], int]] = None, width: Optional[Union[Var[int], int]] = None, height: Optional[Union[Var[int], int]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "Grid":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            x: The x-coordinate of grid.
            y: The y-coordinate of grid.
            width: The width of grid.
            height: The height of grid.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class CartesianGrid(Grid):
    @overload
    @classmethod
    def create(cls, *children, horizontal: Optional[Union[Var[Dict[str, Any]], Dict[str, Any]]] = None, vertical: Optional[Union[Var[Dict[str, Any]], Dict[str, Any]]] = None, fill: Optional[Union[Var[str], str]] = None, fill_opacity: Optional[Union[Var[float], float]] = None, stroke_dasharray: Optional[Union[Var[str], str]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "CartesianGrid":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            horizontal: The horizontal line configuration.
            vertical: The vertical line configuration.
            fill: The background of grid.
            fill_opacity: The opacity of the background used to fill the space between grid lines
            stroke_dasharray: The pattern of dashes and gaps used to paint the lines of the grid
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...

class CartesianAxis(Grid):
    @overload
    @classmethod
    def create(cls, *children, orientation: Optional[Union[Var[Literal["top", "bottom", "left", "right"]], Literal["top", "bottom", "left", "right"]]] = None, axis_line: Optional[Union[Var[bool], bool]] = None, tick_line: Optional[Union[Var[bool], bool]] = None, tick_size: Optional[Union[Var[int], int]] = None, interval: Optional[Union[Var[Literal["preserveStart", "preserveEnd", "preserveStartEnd"]], Literal["preserveStart", "preserveEnd", "preserveStartEnd"]]] = None, ticks: Optional[Union[Var[bool], bool]] = None, label: Optional[Union[Var[str], str]] = None, mirror: Optional[Union[Var[bool], bool]] = None, tick_margin: Optional[Union[Var[int], int]] = None, on_blur: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_context_menu: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_double_click: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_focus: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_down: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_enter: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_leave: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_move: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_out: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_over: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_mouse_up: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_scroll: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, on_unmount: Optional[Union[EventHandler, EventSpec, List, function, BaseVar]] = None, **props) -> "CartesianAxis":  # type: ignore
        """Create the component.

        Args:
            *children: The children of the component.
            orientation: The orientation of axis 'top' | 'bottom' | 'left' | 'right'
            axis_line: If set false, no axis line will be drawn. If set a object, the option is the configuration of axis line.
            tick_line: If set false, no axis tick lines will be drawn. If set a object, the option is the configuration of tick lines.
            tick_size: The length of tick line.
            interval: If set 0, all the ticks will be shown. If set preserveStart", "preserveEnd" or "preserveStartEnd", the ticks which is to be shown or hidden will be calculated automatically.
            ticks: If set false, no ticks will be drawn.
            label: If set a string or a number, default label will be drawn, and the option is content.
            mirror: If set true, flips ticks around the axis line, displaying the labels inside the chart instead of outside.
            tick_margin: The margin between tick line and tick.
            **props: The props of the component.

        Returns:
            The component.

        Raises:
            TypeError: If an invalid child is passed.
        """
        ...
