from setuptools import setup
import os

base_dir = os.path.abspath(os.path.dirname(__file__))
with open(os.path.join(base_dir, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

about = {}
with open(os.path.join(base_dir, 'nso_jsonrpc_requester', 'version.py'), 'r', encoding='utf-8') as f:
    exec(f.read(), about)

packages = [
    'nso_jsonrpc_requester'
]

install_requires = [
    'requests ~= 2.25.0',
    'PyYAML ~= 5.4.0',
]

tests_require = [
    'pytest',
]

setup(
    name=about['__title__'],
    version=about['__version__'],
    python_requires='>=3.6',
    description=about['__description__'],
    long_description=long_description,
    long_description_content_type='text/markdown',
    keywords='cisco nso json rpc network engineer',
    url='https://nso-jsonrpc-requester.readthedocs.io',
    project_urls={
        'Documentation': 'https://nso-jsonrpc-requester.readthedocs.io/en/latest/',
        'Source': 'https://github.com/btr1975/nso_jsonrpc_requester',
        'Tracker': 'https://github.com/btr1975/nso_jsonrpc_requester/issues',
    },
    author=about['__maintainer__'],
    author_email=about['__email__'],
    license=about['__license__'],
    packages=packages,
    include_package_data=True,
    install_requires=install_requires,
    test_suite='pytest',
    tests_require=tests_require,
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'License :: OSI Approved :: MIT License',
        'Intended Audience :: Developers',
        'Natural Language :: English',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX',
        'Operating System :: POSIX :: BSD',
        'Operating System :: POSIX :: Linux',
        'Operating System :: Microsoft :: Windows',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3 :: Only',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
    ],
)
