# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['makenew_python_app', 'makenew_python_app.server']

package_data = \
{'': ['*']}

install_requires = \
['pinject>=0.14.1,<0.15.0',
 'pyhumps>=1.3.1,<2.0.0',
 'python-rapidjson>=0.9.1,<0.10.0',
 'structlog>=20.1.0,<21.0.0',
 'tornado>=6.0.4,<7.0.0']

setup_kwargs = {
    'name': 'makenew-python-app',
    'version': '1.4.0',
    'description': 'Package skeleton for a python app.',
    'long_description': 'Python App Skeleton\n===================\n\n|PyPI| |Docker| |Codecov| |CircleCI|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/makenew-python-app.svg\n   :target: https://pypi.python.org/pypi/makenew-python-app\n   :alt: PyPI\n.. |Docker| image:: https://img.shields.io/docker/pulls/makenew/python-app.svg\n   :target: https://hub.docker.com/r/makenew/python-app\n   :alt: Docker\n.. |Codecov| image:: https://img.shields.io/codecov/c/github/makenew/python-app.svg\n   :target: https://codecov.io/gh/makenew/python-app\n   :alt: Codecov\n.. |CircleCI| image:: https://img.shields.io/circleci/project/github/makenew/python-app.svg\n   :target: https://circleci.com/gh/makenew/python-app\n   :alt: CircleCI\n\nPackage skeleton for an Python app.\n\nDescription\n-----------\n\nBootstrap a new Python_ app in less than a minute.\n\n.. _Python: https://www.python.org/\n\nFeatures\n~~~~~~~~\n\n- Publishing to PyPI_.\n- Secure dependency management with Poetry_.\n- `Alpine Linux`_ based multi-stage Docker_ builds for optimized production images.\n- Images tagged using package version and commit checksum.\n- Images pushed to `Docker Hub`_, Heroku_, Bintray_ and the `Amazon EC2 Container Registry (ECR)`_.\n- Standardized JSON logging with structlog_.\n- Centralized dependency injection with pinject_.\n- Tornado_ with asyncio.\n- Linting with Pylint_.\n- Uncompromising code formatting with Black_.\n- pytest_ helps you write better programs.\n- Code coverage reporting with Codecov_.\n- Continuous unit and smoke testing and deployment with CircleCI_.\n- `Keep a CHANGELOG`_.\n- Consistent coding with EditorConfig_.\n- Badges from Shields.io_.\n\n.. _Alpine Linux: https://alpinelinux.org/\n.. _Amazon EC2 Container Registry (ECR): https://aws.amazon.com/ecr/\n.. _Bintray: https://bintray.com/\n.. _Black: https://black.readthedocs.io/en/stable/\n.. _Codecov: https://codecov.io/\n.. _Docker Hub: https://hub.docker.com/\n.. _Docker: https://www.docker.com/\n.. _EditorConfig: https://editorconfig.org/\n.. _Heroku: https://www.heroku.com/\n.. _Keep a CHANGELOG: https://keepachangelog.com/\n.. _PyPI: https://pypi.python.org/pypi\n.. _Pylint: https://www.pylint.org/\n.. _Shields.io: https://shields.io/\n.. _Tornado: https://www.tornadoweb.org/\n.. _pinject: https://pypi.org/project/pinject/\n.. _pytest: https://docs.pytest.org/\n.. _structlog: http://www.structlog.org/\n\nBootstrapping a New Project\n~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n1. Create an empty (**non-initialized**) repository on GitHub.\n2. Clone the master branch of this repository with\n\n   ::\n\n       $ git clone --single-branch https://github.com/makenew/python-app.git new-python-app\n       $ cd new-python-app\n\n   Optionally, reset to the latest\n   `release <https://github.com/makenew/python-app/releases>`__ with\n\n   ::\n\n       $ git reset --hard v1.2.0\n\n3. Run\n\n   ::\n\n       $ ./makenew.sh\n\n   This will replace the boilerplate, delete itself,\n   remove the git remote, remove upstream tags,\n   and stage changes for commit.\n\n4. Create the required CircleCI environment variables with\n\n   ::\n\n       $ .circleci/envvars.sh\n\n5. Review, commit, and push the changes to GitHub with\n\n   ::\n\n     $ git diff --cached\n     $ git commit -m "Replace makenew boilerplate"\n     $ git remote add origin git@github.com:<user>/<new-python-app>.git\n     $ git push -u origin master\n\n6. Ensure the CircleCI build passes,\n   then publish the initial version of the package with\n\n   ::\n\n     $ poetry install\n     $ poetry run bump2version patch\n     $ git push\n     $ git push --tags\n\nUpdating\n~~~~~~~~\n\nIf you want to pull in future updates from this skeleton,\nyou can fetch and merge in changes from this repository.\n\nAdd this as a new remote with\n\n::\n\n    $ git remote rename origin upstream\n\nand then configure your ``origin`` branch as normal.\n\nOtherwise, add this as a new remote with\n\n::\n\n    $ git remote add upstream git@github.com:makenew/python-app.git\n\nYou can then fetch and merge changes with\n\n::\n\n    $ git fetch --no-tags upstream\n    $ git merge upstream/master\n\nChangelog\n^^^^^^^^^\n\nNote that ``CHANGELOG.md`` is just a template for this skeleton. The\nactual changes for this project are documented in the commit history and\nsummarized under\n`Releases <https://github.com/makenew/python-app/releases>`__.\n\nUsage\n-----\n\nDocker container\n~~~~~~~~~~~~~~~~\n\nThe service is distributed as a Docker container on Docker Hub.\nTo run locally, add configuration to `config/local.json`,\nthen pull and run the image with\n\n::\n\n    $ docker run --read-only --init --publish 8080:8080 \\\n      --volume "$(pwd)/config/local.json:/usr/src/app/config/local.json" \\\n      makenew/python-app\n\nInstallation\n------------\n\nThis package is also registered on the `Python Package Index (PyPI)`_\nas makenew_python_app_.\n\nInstall it with\n\n::\n\n    $ poetry install makenew_python_app\n\n.. _makenew_python_app: https://pypi.python.org/pypi/makenew-python-app\n.. _Python Package Index (PyPI): https://pypi.python.org/\n\nDevelopment and Testing\n-----------------------\n\nQuickstart\n~~~~~~~~~~\n\n::\n\n    $ git clone https://github.com/makenew/python-app.git\n    $ cd python-app\n    $ poetry install\n\nRun each command below in a separate terminal window:\n\n::\n\n    $ make watch\n    $ make server\n\nPrimary development tasks are defined in the `Makefile`.\n\nSource Code\n~~~~~~~~~~~\n\nThe `source code`_ is hosted on GitHub.\nClone the project with\n\n::\n\n    $ git clone https://github.com/makenew/python-app.git\n\n.. _source code: https://github.com/makenew/python-app\n\nRequirements\n~~~~~~~~~~~~\n\nYou will need `Python 3`_ and Poetry_.\n\nInstall the development dependencies with\n\n::\n\n    $ poetry install\n\n.. _Poetry: https://poetry.eustace.io/\n.. _Python 3: https://www.python.org/\n\nTests\n~~~~~\n\nLint code with\n\n::\n\n    $ make lint\n\n\nRun tests with\n\n::\n\n    $ make test\n\nRun tests on chages with\n\n::\n\n    $ make watch\n\nPublishing\n~~~~~~~~~~\n\nUse the bump2version_ command to release a new version.\nPush the created git tag which will trigger a CircleCI publish job.\n\n.. _bump2version: https://github.com/c4urself/bump2version\n\nCircleCI Setup\n--------------\n\n*CircleCI should already be configured: this section is for reference only.*\n\nThe following environment variables must be set on CircleCI_:\nThese may be set manually or by running the script ``./.circleci/envvars.sh``.\n\n- ``TWINE_USERNAME``: Username for publishing on PyPI.\n- ``TWINE_PASSWORD``: Password for publishing on PyPI.\n- ``CODECOV_TOKEN``: Codecov token for uploading coverage reports (optional).\n\nCodecov\n~~~~~~~\n\nIf set, CircleCI_ will send code coverage reports to Codecov_.\n\n- ``CODECOV_TOKEN``: Codecov token for uploading coverage reports.\n\nDocker Hub\n~~~~~~~~~~\n\nIf set, CircleCI_ will build, tag, and push images to `Docker Hub`_.\n\n- ``DOCKERHUB_REPOSITORY``: Docker Hub repository name.\n- ``DOCKERHUB_USERNAME``: Docker Hub username.\n- ``DOCKERHUB_PASSWORD``: Docker Hub password.\n\nBintray\n~~~~~~~\n\nIf set, CircleCI_ will build, tag, and push images to Bintray_.\n\n- ``BINTRAY_REGISTRY``: Bintray registry name.\n- ``BINTRAY_REPOSITORY``: Bintray repository name.\n- ``BINTRAY_USERNAME``: Bintray username.\n- ``BINTRAY_PASSWORD``: Bintray password (your API key).\n\nAmazon EC2 Container Registry (ECR)\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nIf set, CircleCI_ will build, tag, and push images to `Amazon ECR`_.\n\n- ``AWS_ECR_REPOSITORY``: Amazon ECR repository name.\n- ``AWS_ACCOUNT_ID``: Amazon account ID.\n- ``AWS_DEFAULT_REGION``: AWS region.\n- ``AWS_ACCESS_KEY_ID``: AWS access key ID.\n- ``AWS_SECRET_ACCESS_KEY``: AWS secret access key.\n\nHeroku\n~~~~~~\n\nIf set, CircleCI_ will deploy images built from master directly to Heroku_.\n\n- ``HEROKU_APP``: Heroku application name.\n- ``HEROKU_TOKEN``: Heroku authentication token.\n\n.. _Amazon ECR: https://aws.amazon.com/ecr/\n.. _Bintray: https://bintray.com/\n.. _CircleCI: https://circleci.com/\n.. _CircleCI: https://circleci.com/\n.. _Codecov: https://codecov.io/\n.. _Docker Hub: https://hub.docker.com/\n.. _Heroku: https://www.heroku.com/\n\nDocker\n~~~~~~\n\nThe production Docker image is built on CircleCI from `.circleci/Dockerfile`:\nthis Dockerfile can only be used with the CircleCI workflow.\n\nIn rare cases, building an equivalent container locally may be useful.\nBuild and run this local container with\n\n\n::\n\n    $ docker build -t makenew/python-app .\n    $ docker run --read-only --init --publish 80:8080 makenew/python-app\n\nContributing\n------------\n\nPlease submit and comment on bug reports and feature requests.\n\nTo submit a patch:\n\n1. Fork it (https://github.com/makenew/python-app/fork).\n2. Create your feature branch (`git checkout -b my-new-feature`).\n3. Make changes.\n4. Commit your changes (`git commit -am \'Add some feature\'`).\n5. Push to the branch (`git push origin my-new-feature`).\n6. Create a new Pull Request.\n\nLicense\n-------\n\nThis Python app is licensed under the MIT license.\n\nWarranty\n--------\n\nThis software is provided by the copyright holders and contributors "as is" and\nany express or implied warranties, including, but not limited to, the implied\nwarranties of merchantability and fitness for a particular purpose are\ndisclaimed. In no event shall the copyright holder or contributors be liable for\nany direct, indirect, incidental, special, exemplary, or consequential damages\n(including, but not limited to, procurement of substitute goods or services;\nloss of use, data, or profits; or business interruption) however caused and on\nany theory of liability, whether in contract, strict liability, or tort\n(including negligence or otherwise) arising in any way out of the use of this\nsoftware, even if advised of the possibility of such damage.\n',
    'author': 'Evan Sosenko',
    'author_email': 'razorx@evansosenko.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/makenew/python-app',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '==3.8.3',
}


setup(**setup_kwargs)
