# Generate from JsonSchema

The codegen generate pydantic models from JSON Schema

## Example

```bash
$ datamodel-codegen  --input person.json --input-file-type jsonschema --output model.py
```

`person.json`:
```json
{
  "$id": "https://example.com/person.schema.json",
  "$schema": "http://json-schema.org/draft-07/schema#",
  "title": "Person",
  "type": "object",
  "properties": {
    "firstName": {
      "type": "string",
      "description": "The person's first name."
    },
    "lastName": {
      "type": "string",
      "description": "The person's last name."
    },
    "age": {
      "description": "Age in years which must be equal to or greater than zero.",
      "type": "integer",
      "minimum": 0
    },
    "friends": {
      "type": "array"
    },
    "comment": {
      "type": "null"
    }
  }
}
```


`model.py`:
```python
# generated by datamodel-codegen:
#   filename:  person.json
#   timestamp: 2020-04-27T16:12:27+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import BaseModel, Field, conint


class Person(BaseModel):
    firstName: Optional[str] = Field(None, description="The person's first name.")
    lastName: Optional[str] = Field(None, description="The person's last name.")
    age: Optional[conint(ge=0)] = Field(
        None, description='Age in years which must be equal to or greater than zero.'
    )
    friends: Optional[List] = None
    comment: Optional[Any] = None
```