# Visualization V2.0 - Visual Reference

**ASCII Diagrams and Layout Examples**

---

## Table of Contents

1. [User Flow Diagrams](#user-flow-diagrams)
2. [Layout Examples](#layout-examples)
3. [State Machine](#state-machine)
4. [Data Structures](#data-structures)
5. [Interaction Patterns](#interaction-patterns)

---

## User Flow Diagrams

### Flow 1: Navigate from Root to Function

```
┌─────────────────────────────────────────────────────────────────┐
│ STEP 1: Initial View (List)                                    │
│                                                                 │
│  Root Directories (Vertical List)                              │
│  ┌─────────────────┐                                           │
│  │  📁 src         │ ← User clicks here                        │
│  └─────────────────┘                                           │
│  ┌─────────────────┐                                           │
│  │  📁 tests       │                                           │
│  └─────────────────┘                                           │
│  ┌─────────────────┐                                           │
│  │  📁 docs        │                                           │
│  └─────────────────┘                                           │
│                                                                 │
│  Breadcrumb: [🏠 Root]                                         │
└─────────────────────────────────────────────────────────────────┘
                            │
                            │ Click "src"
                            ▼
┌─────────────────────────────────────────────────────────────────┐
│ STEP 2: Directory Expanded (Horizontal Fan)                    │
│                                                                 │
│                      ┌─────────────┐                           │
│                 ┌────│  📁 core    │                           │
│                 │    └─────────────┘                           │
│                 │                                               │
│                 │    ┌─────────────┐                           │
│                 ├────│  📁 cli     │                           │
│                 │    └─────────────┘                           │
│                 │                                               │
│  ┌──────────────┴─┐  ┌─────────────┐                          │
│  │  📁 src        ├──│  📁 utils   │                          │
│  │      +         │  └─────────────┘                          │
│  └──────────────┬─┘                                            │
│                 │    ┌─────────────┐                           │
│                 ├────│ 📄 main.py  │ ← User clicks here        │
│                 │    └─────────────┘                           │
│                 │                                               │
│                 │    ┌─────────────┐                           │
│                 └────│ 📄 config.py│                           │
│                      └─────────────┘                           │
│                                                                 │
│  Breadcrumb: [🏠 Root / src]                                   │
└─────────────────────────────────────────────────────────────────┘
                            │
                            │ Click "main.py"
                            ▼
┌─────────────────────────────────────────────────────────────────┐
│ STEP 3: File Expanded (AST Chunks + Call Edges)                │
│                                                                 │
│          ┌──────────┐                                          │
│      ┌───│ main()   │                                          │
│      │   └──────────┘                                          │
│      │        │                                                 │
│      │        │ calls (blue edge with arrow)                   │
│      │        ▼                                                 │
│      │   ┌──────────┐                                          │
│      ├───│ setup()  │                                          │
│      │   └──────────┘                                          │
│      │        │                                                 │
│      │        │ calls                                           │
│      │        ▼                                                 │
│  ┌───┴──────────┐   ┌──────────┐                              │
│  │ 📄 main.py   ├───│ Config   │ ← Class                      │
│  │      +       │   └──────────┘                              │
│  └───┬──────────┘        │                                     │
│      │                   │ calls                                │
│      │                   ▼                                      │
│      │              ┌──────────┐                               │
│      └──────────────│ load()   │                               │
│                     └──────────┘                               │
│                                                                 │
│  Breadcrumb: [🏠 Root / src / main.py]                         │
│                                                                 │
│  Content Pane (right side): Shows code for selected chunk      │
└─────────────────────────────────────────────────────────────────┘
```

---

### Flow 2: Sibling Directory Switch

```
┌─────────────────────────────────────────────────────────────────┐
│ STATE: Directory "src" Expanded                                 │
│                                                                 │
│           ┌────────┐                                            │
│       ┌───│ core   │                                            │
│       │   └────────┘                                            │
│   ┌───┴──┐                                                      │
│   │ src  ├───┬────┐                                            │
│   │  +   │   │cli │                                            │
│   └───┬──┘   └────┘                                            │
│       │                                                          │
│       └───┬─────────┐                                           │
│           │ main.py │                                           │
│           └─────────┘                                           │
│                                                                 │
│  User clicks sibling "tests" directory                         │
│                                 ↓                               │
└─────────────────────────────────────────────────────────────────┘
                                  │
                                  │ Close "src", Open "tests"
                                  ▼
┌─────────────────────────────────────────────────────────────────┐
│ STATE: Directory "tests" Expanded (src collapsed)               │
│                                                                 │
│          ┌────────────┐                                         │
│      ┌───│ unit/      │                                         │
│      │   └────────────┘                                         │
│  ┌───┴─────┐                                                    │
│  │ tests   ├───┬────────────┐                                  │
│  │   +     │   │integration/│                                  │
│  └───┬─────┘   └────────────┘                                  │
│      │                                                           │
│      └───┬──────────────────┐                                  │
│          │ test_main.py     │                                  │
│          └──────────────────┘                                  │
│                                                                 │
│  NOTE: "src" children are now hidden                           │
│  Only ONE sibling path visible at a time                       │
└─────────────────────────────────────────────────────────────────┘
```

---

## Layout Examples

### Example 1: Small Project (Root List)

```
Project Root: my-app/

┌─────────────────────────────────────────────────────────────────┐
│                                                                 │
│    List View (Alphabetically Sorted)                           │
│                                                                 │
│    x=100                                                        │
│    ↓                                                            │
│    ┌─────────────────┐  ← y=150 (first dir)                   │
│    │  📁 docs        │ +                                       │
│    └─────────────────┘                                         │
│                                                                 │
│    ┌─────────────────┐  ← y=200 (spacing=50px)                │
│    │  📁 src         │ +                                       │
│    └─────────────────┘                                         │
│                                                                 │
│    ┌─────────────────┐  ← y=250                                │
│    │  📁 tests       │ +                                       │
│    └─────────────────┘                                         │
│                                                                 │
│    ┌─────────────────┐  ← y=300 (first file after dirs)       │
│    │  📄 README.md   │                                         │
│    └─────────────────┘                                         │
│                                                                 │
│    ┌─────────────────┐  ← y=350                                │
│    │  📄 setup.py    │                                         │
│    └─────────────────┘                                         │
│                                                                 │
│  Spacing: 50px between nodes                                   │
│  Sorting: Directories first, then files (alphabetical)         │
└─────────────────────────────────────────────────────────────────┘
```

---

### Example 2: Directory Expanded (Horizontal Fan)

```
Directory: src/ (5 children)

┌─────────────────────────────────────────────────────────────────┐
│                                                                 │
│  Fan Layout (180° horizontal arc)                              │
│                                                                 │
│                          child[0] (leftmost)                   │
│                          ┌────────┐                             │
│                     ┌────│ cli/   │                             │
│                     │    └────────┘                             │
│                     │                                            │
│              angle=180°  child[1]                               │
│                     │    ┌────────┐                             │
│                     ├────│ core/  │                             │
│                     │    └────────┘                             │
│                     │                                            │
│           radius=200px   child[2] (center, angle=90°)          │
│                     │    ┌────────┐                             │
│  ┌──────────────────┴─┐  │ utils/ │                            │
│  │   src/             ├──┴────────┘                            │
│  │    +               │                                         │
│  └──────────────────┬─┘  child[3]                              │
│                     │    ┌────────┐                             │
│                     ├────│main.py │                             │
│                     │    └────────┘                             │
│                     │                                            │
│              angle=0°    child[4] (rightmost)                   │
│                     │    ┌────────┐                             │
│                     └────│config.py                             │
│                          └────────┘                             │
│                                                                 │
│  Radius: adaptive (200-400px based on child count)             │
│  Arc: 180° (horizontal left-to-right)                          │
│  Spacing: Even distribution across arc                         │
└─────────────────────────────────────────────────────────────────┘
```

**Angle Calculation**:
- child[0]: angle = 180° (π radians) → leftmost
- child[1]: angle = 135° (3π/4 radians)
- child[2]: angle = 90° (π/2 radians) → top center
- child[3]: angle = 45° (π/4 radians)
- child[4]: angle = 0° → rightmost

**Position Formula**:
```
x = parent.x + radius * cos(angle)
y = parent.y + radius * sin(angle)
```

---

### Example 3: File Expanded (AST Chunks)

```
File: main.py (Python file with 7 AST chunks)

┌─────────────────────────────────────────────────────────────────┐
│                                                                 │
│  AST Fan + Function Call Edges                                 │
│                                                                 │
│              [import]                                           │
│              ┌────────┐                                         │
│          ┌───│logging │ (import chunk)                         │
│          │   └────────┘                                         │
│          │                                                       │
│          │   [function]                                         │
│          │   ┌────────┐                                         │
│          ├───│ main() │                                         │
│          │   └───┬────┘                                         │
│          │       │                                               │
│          │       │ calls (blue edge)                            │
│          │       ▼                                               │
│          │   ┌────────┐                                         │
│  ┌───────┴──┐│ setup()│                                        │
│  │ main.py  ├┴───┬────┘                                        │
│  │    +     │    │                                              │
│  └───────┬──┘    │ calls                                        │
│          │       ▼                                               │
│          │   ┌────────┐                                         │
│          │   │Config  │ [class]                                │
│          │   └───┬────┘                                         │
│          │       │                                               │
│          │       │ contains (containment edge - NOT shown)     │
│          │       ▼                                               │
│          │   ┌────────┐                                         │
│          ├───│__init__│ [method]                                │
│          │   └────────┘                                         │
│          │                                                       │
│          │   ┌────────┐                                         │
│          └───│ load() │ [method]                                │
│              └────────┘                                         │
│                                                                 │
│  EDGE FILTERING:                                                │
│  ✅ Show: type='caller' (function calls)                       │
│  ❌ Hide: type='semantic', 'imports', 'containment'            │
│                                                                 │
│  Only edges where:                                              │
│   - source.file_path == target.file_path == 'main.py'         │
│   - link.type == 'caller'                                      │
└─────────────────────────────────────────────────────────────────┘
```

**Edge Types in AST View**:
| Type | Show? | Reason |
|------|-------|--------|
| `caller` | ✅ Yes | Explicit function calls (actionable) |
| `semantic` | ❌ No | Implicit similarity (noise) |
| `imports` | ❌ No | File-level dependency (not AST-level) |
| `containment` | ❌ No | Implied by layout (class contains methods) |

---

## State Machine

### Visualization State Diagram

```
┌─────────────────────────────────────────────────────────────────┐
│                         STATE MACHINE                           │
└─────────────────────────────────────────────────────────────────┘

     ┌───────────────────────────────────────────────┐
     │  INITIAL                                      │
     │  • layoutMode = 'list'                        │
     │  • visibleNodes = {root_dirs, root_files}     │
     │  • expansionPath = []                         │
     │  • activeSiblings = {}                        │
     └────────────┬──────────────────────────────────┘
                  │
                  │ event: Click directory D1
                  │ action: expandNode(D1)
                  ▼
     ┌───────────────────────────────────────────────┐
     │  DIR_EXPANDED                                 │
     │  • layoutMode = 'fan'                         │
     │  • visibleNodes += {D1.children}              │
     │  • expansionPath = [D1]                       │
     │  • activeSiblings[0] = D1                     │
     └────┬──────────────────┬────────────────────────┘
          │                  │
          │ Click sibling D2 │ Click file F1 in D1
          │                  │
          ▼                  ▼
     ┌────────────┐     ┌──────────────────────┐
     │ SIBLING    │     │ FILE_EXPANDED        │
     │ SWITCHED   │     │ • expansionPath =    │
     │            │     │   [D1, F1]           │
     │ • Close D1 │     │ • visibleNodes +=    │
     │ • Open D2  │     │   {F1.ast_chunks}    │
     │ • Return to│     │ • Show caller edges  │
     │   DIR_EXP  │     │   within F1          │
     └────────────┘     └──────┬───────────────┘
                                │
                                │ Click collapse on D1
                                │ action: collapseNode(D1)
                                ▼
                    ┌────────────────────────┐
                    │  COLLAPSED             │
                    │  • Remove F1 from path │
                    │  • Hide F1.ast_chunks  │
                    │  • Return to DIR_EXP   │
                    └────────┬───────────────┘
                             │
                             │ Click collapse on D1
                             │ OR Press Home key
                             ▼
                        Back to INITIAL state

┌─────────────────────────────────────────────────────────────────┐
│  State Invariants (must always be true):                       │
│                                                                 │
│  1. visibleNodes ⊇ expansionPath                               │
│     (All nodes in path must be visible)                        │
│                                                                 │
│  2. expansionPath.length ≤ max_depth                           │
│     (Finite depth, no infinite recursion)                      │
│                                                                 │
│  3. ∀ depth: activeSiblings[depth] ∈ visibleNodes              │
│     (Active sibling must be visible)                           │
│                                                                 │
│  4. layoutMode ∈ {'list', 'fan'}                               │
│     (Only two valid layout modes)                              │
│                                                                 │
│  5. If layoutMode == 'list' → expansionPath == []              │
│     (List mode means nothing expanded)                         │
└─────────────────────────────────────────────────────────────────┘
```

---

## Data Structures

### 1. Node Structure (Unchanged)

```javascript
{
  id: "func_abc123",               // Unique identifier
  name: "calculate_total",         // Display name
  type: "function",                // 'directory' | 'file' | 'function' | 'class' | 'method'
  file_path: "src/utils/math.py", // Absolute path
  start_line: 42,                  // Start line in file
  end_line: 58,                    // End line in file
  complexity: 5.2,                 // Cyclomatic complexity
  depth: 3,                        // Distance from root
  parent_id: "file_xyz789",        // Parent node ID (or null)
  content: "def calculate_total():\n    ...",  // Source code
  docstring: "Calculate the total sum...",     // Documentation
  language: "python",              // Programming language
  callers: [                       // External callers (if applicable)
    {
      file: "src/main.py",
      chunk_id: "func_def456",
      name: "main",
      type: "function"
    }
  ],
  x: 450.5,                        // D3 position (updated by layout)
  y: 320.8                         // D3 position (updated by layout)
}
```

### 2. Link Structure (Unchanged)

```javascript
{
  source: "func_abc123",  // Source node ID (or Node object after D3 processing)
  target: "func_def456",  // Target node ID (or Node object)
  type: "caller",         // 'caller' | 'semantic' | 'imports' | 'containment' | 'dir_hierarchy'
  is_cycle: false,        // True if part of circular dependency
  similarity: 0.85        // For semantic links only (0.0-1.0)
}
```

### 3. NEW: NodeState Structure

```javascript
{
  id: "dir_src",          // Node ID (matches Node.id)
  isExpanded: true,       // Has this node been expanded?
  isInFan: false,         // Is this node currently in a fan layout?
  layoutOverride: {       // Fixed position for list/fan layout
    x: 100,
    y: 200,
    fixed: true           // Don't apply force simulation
  },
  depth: 1,               // Distance from root
  parentId: "root",       // Parent node ID
  childrenIds: [          // Direct children IDs
    "file_main",
    "dir_cli",
    "dir_core"
  ]
}
```

### 4. NEW: Expansion Path

```javascript
expansionPath = [
  "dir_src",      // Root-level directory
  "dir_cli",      // Subdirectory of src
  "file_main.py"  // File in cli directory
]

// Represents: Root → src/ → cli/ → main.py
// Each element is a node ID
// Length indicates current depth
```

### 5. NEW: Active Siblings Map

```javascript
activeSiblings = new Map([
  [0, "dir_src"],    // At depth 0, "src" is expanded
  [1, "dir_cli"],    // At depth 1, "cli" is expanded
  [2, "file_main"]   // At depth 2, "main.py" is expanded
])

// Key: depth level (0, 1, 2, ...)
// Value: node ID of currently expanded sibling at that depth
// Used for sibling exclusivity (only one sibling expanded per depth)
```

---

## Interaction Patterns

### Pattern 1: Directory Expansion

```
┌─────────────────────────────────────────────────────────────────┐
│  USER ACTION: Click directory node                             │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  STEP 1: Check for active sibling at same depth                │
│                                                                 │
│  if (activeSiblings.has(node.depth)) {                         │
│    const siblingId = activeSiblings.get(node.depth);           │
│    if (siblingId !== node.id) {                                │
│      collapseNode(siblingId);  // Close sibling first          │
│    }                                                            │
│  }                                                              │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  STEP 2: Mark node as expanded                                 │
│                                                                 │
│  nodeStateManager.setExpanded(node.id, true);                  │
│  expansionPath.push(node.id);                                  │
│  activeSiblings.set(node.depth, node.id);                      │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  STEP 3: Find and show children                                │
│                                                                 │
│  const children = allLinks                                     │
│    .filter(l => l.source === node.id &&                        │
│                 l.type === 'dir_containment')                  │
│    .map(l => l.target);                                        │
│                                                                 │
│  children.forEach(child => {                                   │
│    visibleNodes.add(child.id);                                 │
│    nodeStateManager.setInFan(child.id, true);                  │
│  });                                                            │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  STEP 4: Calculate fan layout                                  │
│                                                                 │
│  const positions = calculateFanLayout(                         │
│    node,                                                       │
│    children,                                                   │
│    containerWidth,                                             │
│    containerHeight                                             │
│  );                                                            │
│                                                                 │
│  positions.forEach((pos, childId) => {                         │
│    layoutPositions.set(childId, pos);                          │
│  });                                                            │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  STEP 5: Render with animation                                 │
│                                                                 │
│  layoutMode = 'fan';                                           │
│  renderGraphWithTransition(750ms);                             │
└─────────────────────────────────────────────────────────────────┘
```

---

### Pattern 2: Breadcrumb Navigation

```
Expansion Path: [dir_src, dir_cli, file_main.py]

┌─────────────────────────────────────────────────────────────────┐
│  BREADCRUMB DISPLAY                                             │
│                                                                 │
│  [🏠 Root] / [src] / [cli] / [main.py]                         │
│      ↑         ↑      ↑         ↑                              │
│   onclick  onclick onclick  (current - not clickable)          │
└─────────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────────┐
│  USER ACTION: Click "cli" in breadcrumb                        │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  STEP 1: Find position in path                                 │
│                                                                 │
│  const clickedIndex = expansionPath.indexOf('dir_cli');        │
│  // clickedIndex = 1                                           │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  STEP 2: Collapse all descendants                              │
│                                                                 │
│  const toCollapse = expansionPath.slice(clickedIndex + 1);     │
│  // toCollapse = ['file_main.py']                              │
│                                                                 │
│  toCollapse.forEach(nodeId => {                                │
│    collapseNode(nodeId);                                       │
│  });                                                            │
└─────────────────────────────────────────────────────────────────┘
                            ↓
┌─────────────────────────────────────────────────────────────────┐
│  RESULT: Navigated to cli/ level                               │
│                                                                 │
│  Expansion Path: [dir_src, dir_cli]                            │
│  Breadcrumb: [🏠 Root] / [src] / [cli]                         │
│                                                                 │
│  Visible: src/, cli/ directory, and cli/'s children            │
│  Hidden: main.py and its AST chunks                            │
└─────────────────────────────────────────────────────────────────┘
```

---

### Pattern 3: Keyboard Shortcuts

```
┌─────────────────────────────────────────────────────────────────┐
│  KEYBOARD NAVIGATION                                            │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  [Escape]        Close content pane + collapse current node    │
│                                                                 │
│  [Backspace]     Navigate up one level in expansion path       │
│                                                                 │
│  [Home]          Reset to root list view                       │
│                                                                 │
│  [Alt + ←]       Navigate back in view history                 │
│                                                                 │
│  [Alt + →]       Navigate forward in view history              │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘

Example: Press Backspace

Current State:
  expansionPath = [dir_src, dir_cli, file_main]
  Breadcrumb: Root / src / cli / main.py

After Backspace:
  expansionPath = [dir_src, dir_cli]
  Breadcrumb: Root / src / cli
  Effect: Collapses file_main and its AST chunks
```

---

## Implementation Cheat Sheet

### Quick Reference: Key Functions

| Function | Purpose | Time Complexity |
|----------|---------|-----------------|
| `calculateListLayout()` | Position root nodes vertically | O(n log n) (sorting) |
| `calculateFanLayout()` | Position children in horizontal arc | O(n) |
| `expandNode()` | Show children in fan layout | O(n) where n=children |
| `collapseNode()` | Hide all descendants recursively | O(n) where n=descendants |
| `renderGraphWithTransition()` | Main render with animation | O(n + m) nodes + links |
| `getFilteredLinksForCurrentView()` | Filter edges by type and visibility | O(m) where m=links |
| `animateLayoutTransition()` | Smooth position transitions | O(n) |
| `detectAndResolveCollisions()` | Fix overlapping nodes | O(n log n) with spatial grid |

### Quick Reference: State Variables

| Variable | Type | Purpose |
|----------|------|---------|
| `allNodes` | Array<Node> | All nodes in graph (unchanged) |
| `allLinks` | Array<Link> | All edges in graph (unchanged) |
| `expansionPath` | Array<string> | Stack of expanded node IDs |
| `visibleNodes` | Set<string> | Currently visible node IDs |
| `nodeStates` | Map<string, NodeState> | Per-node expansion state |
| `layoutMode` | 'list' \| 'fan' | Current layout algorithm |
| `layoutPositions` | Map<string, {x, y}> | Fixed positions for nodes |
| `activeSiblings` | Map<number, string> | Expanded sibling at each depth |
| `highlightedNode` | Node \| null | Currently selected node |

---

**END OF VISUAL REFERENCE**

For detailed implementation, see: `VISUALIZATION_ARCHITECTURE_V2.md`
