# Deployment Documentation

This directory contains documentation related to deployment, releases, and distribution of MCP Vector Search.

## 📋 Contents

### Release Management
- **[CHANGELOG.md](CHANGELOG.md)** - Complete version history and release notes
- **[RELEASES.md](RELEASES.md)** - Release process and best practices
- **[VERSIONING_WORKFLOW.md](VERSIONING_WORKFLOW.md)** - Versioning system and workflow

### Distribution
- **[HOMEBREW_INTEGRATION.md](HOMEBREW_INTEGRATION.md)** - Homebrew formula automation
- **[HOMEBREW_QUICKSTART.md](HOMEBREW_QUICKSTART.md)** - Quick Homebrew setup guide

## 🎯 Quick Links

### For Maintainers
- [Release Process](RELEASES.md#release-workflow) - Step-by-step release guide
- [Version Management](VERSIONING_WORKFLOW.md#version-format) - Semantic versioning rules
- [Homebrew Updates](HOMEBREW_INTEGRATION.md#architecture) - Automated formula updates

### For Users
- [Version History](CHANGELOG.md) - What's new in each release
- [Homebrew Installation](HOMEBREW_QUICKSTART.md) - Install via Homebrew

## 🔗 Related Documentation

- **[Development Setup](../development/setup.md)** - Development environment
- **[Contributing Guide](../development/contributing.md)** - How to contribute
- **[Getting Started](../getting-started/README.md)** - User installation guide

---

**Last Updated**: December 2025
