"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const codepipeline = require("../lib");
class FakeSourceAction {
    constructor(props) {
        this.actionProperties = {
            ...props,
            category: codepipeline.ActionCategory.SOURCE,
            provider: 'Fake',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 1, maxOutputs: 4 },
            outputs: [props.output, ...props.extraOutputs || []],
        };
        this.variables = {
            firstVariable: core_1.Lazy.stringValue({ produce: () => `#{${this.actionProperties.variablesNamespace}.FirstVariable}` }),
        };
    }
    bind(_scope, _stage, _options) {
        return {};
    }
    onStateChange(_name, _target, _options) {
        throw new Error('onStateChange() is not available on FakeSourceAction');
    }
}
exports.FakeSourceAction = FakeSourceAction;
//# sourceMappingURL=data:application/json;base64,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