"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = actionProperties.runOrder === undefined ? 1 : actionProperties.runOrder;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = actionProperties.role !== undefined ? actionProperties.role : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnVsbC1hY3Rpb24tZGVzY3JpcHRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZ1bGwtYWN0aW9uLWRlc2NyaXB0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFXQTs7R0FFRztBQUNILE1BQWEsb0JBQW9CO0lBZ0IvQixZQUFZLEtBQWdDO1FBQzFDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixNQUFNLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDdkQsSUFBSSxDQUFDLFVBQVUsR0FBRyxnQkFBZ0IsQ0FBQyxVQUFVLENBQUM7UUFDOUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxnQkFBZ0IsQ0FBQyxRQUFRLENBQUM7UUFDMUMsSUFBSSxDQUFDLEtBQUssR0FBRyxnQkFBZ0IsQ0FBQyxLQUFLLElBQUksS0FBSyxDQUFDO1FBQzdDLElBQUksQ0FBQyxRQUFRLEdBQUcsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO1FBQzFDLElBQUksQ0FBQyxPQUFPLEdBQUcsZ0JBQWdCLENBQUMsT0FBTyxJQUFJLEdBQUcsQ0FBQztRQUMvQyxJQUFJLENBQUMsUUFBUSxHQUFHLGdCQUFnQixDQUFDLFFBQVEsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO1FBQ3hGLElBQUksQ0FBQyxjQUFjLEdBQUcsZ0JBQWdCLENBQUMsY0FBYyxDQUFDO1FBQ3RELElBQUksQ0FBQyxTQUFTLEdBQUcsZ0JBQWdCLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLE1BQU0sR0FBRyxvQkFBb0IsQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUM1RCxJQUFJLENBQUMsT0FBTyxHQUFHLG9CQUFvQixDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzlELElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLFlBQVksSUFBSSxnQkFBZ0IsQ0FBQyxNQUFNLENBQUM7UUFDNUQsSUFBSSxDQUFDLElBQUksR0FBRyxnQkFBZ0IsQ0FBQyxJQUFJLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFFM0YsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQztJQUN4RCxDQUFDO0NBQ0Y7QUFsQ0Qsb0RBa0NDO0FBRUQsU0FBUyxvQkFBb0IsQ0FBQyxTQUFzQjtJQUNsRCxNQUFNLEdBQUcsR0FBRyxJQUFJLEtBQUssRUFBWSxDQUFDO0lBQ2xDLEtBQUssTUFBTSxRQUFRLElBQUksU0FBUyxJQUFJLEVBQUUsRUFBRTtRQUN0QyxJQUFJLFFBQVEsQ0FBQyxZQUFZLEVBQUU7WUFDekIsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFlBQVksS0FBSyxRQUFRLENBQUMsWUFBWSxDQUFDLEVBQUU7Z0JBQzNELFNBQVM7YUFDVjtTQUNGO2FBQU07WUFDTCxJQUFJLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEtBQUssUUFBUSxDQUFDLEVBQUU7Z0JBQ2pDLFNBQVM7YUFDVjtTQUNGO1FBRUQsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztLQUNwQjtJQUNELE9BQU8sR0FBRyxDQUFDO0FBQ2IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCB7IEFjdGlvbkFydGlmYWN0Qm91bmRzLCBBY3Rpb25DYXRlZ29yeSwgQWN0aW9uQ29uZmlnLCBJQWN0aW9uIH0gZnJvbSAnLi9hY3Rpb24nO1xuaW1wb3J0IHsgQXJ0aWZhY3QgfSBmcm9tICcuL2FydGlmYWN0JztcblxuZXhwb3J0IGludGVyZmFjZSBGdWxsQWN0aW9uRGVzY3JpcHRvclByb3BzIHtcbiAgcmVhZG9ubHkgYWN0aW9uOiBJQWN0aW9uO1xuICByZWFkb25seSBhY3Rpb25Db25maWc6IEFjdGlvbkNvbmZpZztcbiAgcmVhZG9ubHkgYWN0aW9uUm9sZTogaWFtLklSb2xlIHwgdW5kZWZpbmVkO1xuICByZWFkb25seSBhY3Rpb25SZWdpb246IHN0cmluZyB8IHVuZGVmaW5lZDtcbn1cblxuLyoqXG4gKiBUaGlzIGNsYXNzIGlzIHByaXZhdGUgdG8gdGhlIGF3cy1jb2RlcGlwZWxpbmUgcGFja2FnZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEZ1bGxBY3Rpb25EZXNjcmlwdG9yIHtcbiAgcHVibGljIHJlYWRvbmx5IGFjdGlvbjogSUFjdGlvbjtcbiAgcHVibGljIHJlYWRvbmx5IGFjdGlvbk5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGNhdGVnb3J5OiBBY3Rpb25DYXRlZ29yeTtcbiAgcHVibGljIHJlYWRvbmx5IG93bmVyOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBwcm92aWRlcjogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgdmVyc2lvbjogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgcnVuT3JkZXI6IG51bWJlcjtcbiAgcHVibGljIHJlYWRvbmx5IGFydGlmYWN0Qm91bmRzOiBBY3Rpb25BcnRpZmFjdEJvdW5kcztcbiAgcHVibGljIHJlYWRvbmx5IG5hbWVzcGFjZT86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGlucHV0czogQXJ0aWZhY3RbXTtcbiAgcHVibGljIHJlYWRvbmx5IG91dHB1dHM6IEFydGlmYWN0W107XG4gIHB1YmxpYyByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSByb2xlPzogaWFtLklSb2xlO1xuICBwdWJsaWMgcmVhZG9ubHkgY29uZmlndXJhdGlvbjogYW55O1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBGdWxsQWN0aW9uRGVzY3JpcHRvclByb3BzKSB7XG4gICAgdGhpcy5hY3Rpb24gPSBwcm9wcy5hY3Rpb247XG4gICAgY29uc3QgYWN0aW9uUHJvcGVydGllcyA9IHByb3BzLmFjdGlvbi5hY3Rpb25Qcm9wZXJ0aWVzO1xuICAgIHRoaXMuYWN0aW9uTmFtZSA9IGFjdGlvblByb3BlcnRpZXMuYWN0aW9uTmFtZTtcbiAgICB0aGlzLmNhdGVnb3J5ID0gYWN0aW9uUHJvcGVydGllcy5jYXRlZ29yeTtcbiAgICB0aGlzLm93bmVyID0gYWN0aW9uUHJvcGVydGllcy5vd25lciB8fCAnQVdTJztcbiAgICB0aGlzLnByb3ZpZGVyID0gYWN0aW9uUHJvcGVydGllcy5wcm92aWRlcjtcbiAgICB0aGlzLnZlcnNpb24gPSBhY3Rpb25Qcm9wZXJ0aWVzLnZlcnNpb24gfHwgJzEnO1xuICAgIHRoaXMucnVuT3JkZXIgPSBhY3Rpb25Qcm9wZXJ0aWVzLnJ1bk9yZGVyID09PSB1bmRlZmluZWQgPyAxIDogYWN0aW9uUHJvcGVydGllcy5ydW5PcmRlcjtcbiAgICB0aGlzLmFydGlmYWN0Qm91bmRzID0gYWN0aW9uUHJvcGVydGllcy5hcnRpZmFjdEJvdW5kcztcbiAgICB0aGlzLm5hbWVzcGFjZSA9IGFjdGlvblByb3BlcnRpZXMudmFyaWFibGVzTmFtZXNwYWNlO1xuICAgIHRoaXMuaW5wdXRzID0gZGVkdXBsaWNhdGVBcnRpZmFjdHMoYWN0aW9uUHJvcGVydGllcy5pbnB1dHMpO1xuICAgIHRoaXMub3V0cHV0cyA9IGRlZHVwbGljYXRlQXJ0aWZhY3RzKGFjdGlvblByb3BlcnRpZXMub3V0cHV0cyk7XG4gICAgdGhpcy5yZWdpb24gPSBwcm9wcy5hY3Rpb25SZWdpb24gfHwgYWN0aW9uUHJvcGVydGllcy5yZWdpb247XG4gICAgdGhpcy5yb2xlID0gYWN0aW9uUHJvcGVydGllcy5yb2xlICE9PSB1bmRlZmluZWQgPyBhY3Rpb25Qcm9wZXJ0aWVzLnJvbGUgOiBwcm9wcy5hY3Rpb25Sb2xlO1xuXG4gICAgdGhpcy5jb25maWd1cmF0aW9uID0gcHJvcHMuYWN0aW9uQ29uZmlnLmNvbmZpZ3VyYXRpb247XG4gIH1cbn1cblxuZnVuY3Rpb24gZGVkdXBsaWNhdGVBcnRpZmFjdHMoYXJ0aWZhY3RzPzogQXJ0aWZhY3RbXSk6IEFydGlmYWN0W10ge1xuICBjb25zdCByZXQgPSBuZXcgQXJyYXk8QXJ0aWZhY3Q+KCk7XG4gIGZvciAoY29uc3QgYXJ0aWZhY3Qgb2YgYXJ0aWZhY3RzIHx8IFtdKSB7XG4gICAgaWYgKGFydGlmYWN0LmFydGlmYWN0TmFtZSkge1xuICAgICAgaWYgKHJldC5maW5kKGEgPT4gYS5hcnRpZmFjdE5hbWUgPT09IGFydGlmYWN0LmFydGlmYWN0TmFtZSkpIHtcbiAgICAgICAgY29udGludWU7XG4gICAgICB9XG4gICAgfSBlbHNlIHtcbiAgICAgIGlmIChyZXQuZmluZChhID0+IGEgPT09IGFydGlmYWN0KSkge1xuICAgICAgICBjb250aW51ZTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXQucHVzaChhcnRpZmFjdCk7XG4gIH1cbiAgcmV0dXJuIHJldDtcbn1cbiJdfQ==