# coding: utf-8

"""
    printnanny-api-client

    Official API client library for printnanny.ai  # noqa: E501

    The version of the OpenAPI document: 0.97.0
    Contact: leigh@printnanny.ai
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from printnanny_api_client.configuration import Configuration


class StripeSubscription(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'djstripe_id': 'int',
        'plan': 'StripePlan',
        'default_payment_method': 'StripePaymentMethod',
        'schedule': 'StripeSubscriptionSchedule',
        'is_period_current': 'bool',
        'is_status_current': 'bool',
        'is_status_temporarily_current': 'bool',
        'is_valid': 'bool',
        'djstripe_created': 'datetime',
        'djstripe_updated': 'datetime',
        'id': 'str',
        'livemode': 'bool',
        'created': 'datetime',
        'metadata': 'dict(str, object)',
        'description': 'str',
        'application_fee_percent': 'str',
        'billing_cycle_anchor': 'datetime',
        'billing_thresholds': 'dict(str, object)',
        'cancel_at': 'datetime',
        'cancel_at_period_end': 'bool',
        'canceled_at': 'datetime',
        'collection_method': 'CollectionMethodEnum',
        'current_period_end': 'datetime',
        'current_period_start': 'datetime',
        'days_until_due': 'int',
        'discount': 'dict(str, object)',
        'ended_at': 'datetime',
        'next_pending_invoice_item_invoice': 'datetime',
        'pending_invoice_item_interval': 'dict(str, object)',
        'pending_update': 'dict(str, object)',
        'quantity': 'int',
        'start_date': 'datetime',
        'status': 'StripeSubscriptionStatusEnum',
        'trial_end': 'datetime',
        'trial_start': 'datetime',
        'djstripe_owner_account': 'str',
        'customer': 'str',
        'default_source': 'str',
        'latest_invoice': 'str',
        'pending_setup_intent': 'str',
        'default_tax_rates': 'list[int]'
    }

    attribute_map = {
        'djstripe_id': 'djstripe_id',
        'plan': 'plan',
        'default_payment_method': 'default_payment_method',
        'schedule': 'schedule',
        'is_period_current': 'is_period_current',
        'is_status_current': 'is_status_current',
        'is_status_temporarily_current': 'is_status_temporarily_current',
        'is_valid': 'is_valid',
        'djstripe_created': 'djstripe_created',
        'djstripe_updated': 'djstripe_updated',
        'id': 'id',
        'livemode': 'livemode',
        'created': 'created',
        'metadata': 'metadata',
        'description': 'description',
        'application_fee_percent': 'application_fee_percent',
        'billing_cycle_anchor': 'billing_cycle_anchor',
        'billing_thresholds': 'billing_thresholds',
        'cancel_at': 'cancel_at',
        'cancel_at_period_end': 'cancel_at_period_end',
        'canceled_at': 'canceled_at',
        'collection_method': 'collection_method',
        'current_period_end': 'current_period_end',
        'current_period_start': 'current_period_start',
        'days_until_due': 'days_until_due',
        'discount': 'discount',
        'ended_at': 'ended_at',
        'next_pending_invoice_item_invoice': 'next_pending_invoice_item_invoice',
        'pending_invoice_item_interval': 'pending_invoice_item_interval',
        'pending_update': 'pending_update',
        'quantity': 'quantity',
        'start_date': 'start_date',
        'status': 'status',
        'trial_end': 'trial_end',
        'trial_start': 'trial_start',
        'djstripe_owner_account': 'djstripe_owner_account',
        'customer': 'customer',
        'default_source': 'default_source',
        'latest_invoice': 'latest_invoice',
        'pending_setup_intent': 'pending_setup_intent',
        'default_tax_rates': 'default_tax_rates'
    }

    def __init__(self, djstripe_id=None, plan=None, default_payment_method=None, schedule=None, is_period_current=None, is_status_current=None, is_status_temporarily_current=None, is_valid=None, djstripe_created=None, djstripe_updated=None, id=None, livemode=None, created=None, metadata=None, description=None, application_fee_percent=None, billing_cycle_anchor=None, billing_thresholds=None, cancel_at=None, cancel_at_period_end=None, canceled_at=None, collection_method=None, current_period_end=None, current_period_start=None, days_until_due=None, discount=None, ended_at=None, next_pending_invoice_item_invoice=None, pending_invoice_item_interval=None, pending_update=None, quantity=None, start_date=None, status=None, trial_end=None, trial_start=None, djstripe_owner_account=None, customer=None, default_source=None, latest_invoice=None, pending_setup_intent=None, default_tax_rates=None, local_vars_configuration=None):  # noqa: E501
        """StripeSubscription - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._djstripe_id = None
        self._plan = None
        self._default_payment_method = None
        self._schedule = None
        self._is_period_current = None
        self._is_status_current = None
        self._is_status_temporarily_current = None
        self._is_valid = None
        self._djstripe_created = None
        self._djstripe_updated = None
        self._id = None
        self._livemode = None
        self._created = None
        self._metadata = None
        self._description = None
        self._application_fee_percent = None
        self._billing_cycle_anchor = None
        self._billing_thresholds = None
        self._cancel_at = None
        self._cancel_at_period_end = None
        self._canceled_at = None
        self._collection_method = None
        self._current_period_end = None
        self._current_period_start = None
        self._days_until_due = None
        self._discount = None
        self._ended_at = None
        self._next_pending_invoice_item_invoice = None
        self._pending_invoice_item_interval = None
        self._pending_update = None
        self._quantity = None
        self._start_date = None
        self._status = None
        self._trial_end = None
        self._trial_start = None
        self._djstripe_owner_account = None
        self._customer = None
        self._default_source = None
        self._latest_invoice = None
        self._pending_setup_intent = None
        self._default_tax_rates = None
        self.discriminator = None

        self.djstripe_id = djstripe_id
        self.plan = plan
        self.default_payment_method = default_payment_method
        self.schedule = schedule
        self.is_period_current = is_period_current
        self.is_status_current = is_status_current
        self.is_status_temporarily_current = is_status_temporarily_current
        self.is_valid = is_valid
        self.djstripe_created = djstripe_created
        self.djstripe_updated = djstripe_updated
        self.id = id
        self.livemode = livemode
        self.created = created
        self.metadata = metadata
        self.description = description
        self.application_fee_percent = application_fee_percent
        self.billing_cycle_anchor = billing_cycle_anchor
        self.billing_thresholds = billing_thresholds
        self.cancel_at = cancel_at
        if cancel_at_period_end is not None:
            self.cancel_at_period_end = cancel_at_period_end
        self.canceled_at = canceled_at
        self.collection_method = collection_method
        self.current_period_end = current_period_end
        self.current_period_start = current_period_start
        self.days_until_due = days_until_due
        self.discount = discount
        self.ended_at = ended_at
        self.next_pending_invoice_item_invoice = next_pending_invoice_item_invoice
        self.pending_invoice_item_interval = pending_invoice_item_interval
        self.pending_update = pending_update
        self.quantity = quantity
        self.start_date = start_date
        self.status = status
        self.trial_end = trial_end
        self.trial_start = trial_start
        self.djstripe_owner_account = djstripe_owner_account
        self.customer = customer
        self.default_source = default_source
        self.latest_invoice = latest_invoice
        self.pending_setup_intent = pending_setup_intent
        if default_tax_rates is not None:
            self.default_tax_rates = default_tax_rates

    @property
    def djstripe_id(self):
        """Gets the djstripe_id of this StripeSubscription.  # noqa: E501


        :return: The djstripe_id of this StripeSubscription.  # noqa: E501
        :rtype: int
        """
        return self._djstripe_id

    @djstripe_id.setter
    def djstripe_id(self, djstripe_id):
        """Sets the djstripe_id of this StripeSubscription.


        :param djstripe_id: The djstripe_id of this StripeSubscription.  # noqa: E501
        :type djstripe_id: int
        """
        if self.local_vars_configuration.client_side_validation and djstripe_id is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_id`, must not be `None`")  # noqa: E501

        self._djstripe_id = djstripe_id

    @property
    def plan(self):
        """Gets the plan of this StripeSubscription.  # noqa: E501


        :return: The plan of this StripeSubscription.  # noqa: E501
        :rtype: StripePlan
        """
        return self._plan

    @plan.setter
    def plan(self, plan):
        """Sets the plan of this StripeSubscription.


        :param plan: The plan of this StripeSubscription.  # noqa: E501
        :type plan: StripePlan
        """
        if self.local_vars_configuration.client_side_validation and plan is None:  # noqa: E501
            raise ValueError("Invalid value for `plan`, must not be `None`")  # noqa: E501

        self._plan = plan

    @property
    def default_payment_method(self):
        """Gets the default_payment_method of this StripeSubscription.  # noqa: E501


        :return: The default_payment_method of this StripeSubscription.  # noqa: E501
        :rtype: StripePaymentMethod
        """
        return self._default_payment_method

    @default_payment_method.setter
    def default_payment_method(self, default_payment_method):
        """Sets the default_payment_method of this StripeSubscription.


        :param default_payment_method: The default_payment_method of this StripeSubscription.  # noqa: E501
        :type default_payment_method: StripePaymentMethod
        """
        if self.local_vars_configuration.client_side_validation and default_payment_method is None:  # noqa: E501
            raise ValueError("Invalid value for `default_payment_method`, must not be `None`")  # noqa: E501

        self._default_payment_method = default_payment_method

    @property
    def schedule(self):
        """Gets the schedule of this StripeSubscription.  # noqa: E501


        :return: The schedule of this StripeSubscription.  # noqa: E501
        :rtype: StripeSubscriptionSchedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this StripeSubscription.


        :param schedule: The schedule of this StripeSubscription.  # noqa: E501
        :type schedule: StripeSubscriptionSchedule
        """
        if self.local_vars_configuration.client_side_validation and schedule is None:  # noqa: E501
            raise ValueError("Invalid value for `schedule`, must not be `None`")  # noqa: E501

        self._schedule = schedule

    @property
    def is_period_current(self):
        """Gets the is_period_current of this StripeSubscription.  # noqa: E501


        :return: The is_period_current of this StripeSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._is_period_current

    @is_period_current.setter
    def is_period_current(self, is_period_current):
        """Sets the is_period_current of this StripeSubscription.


        :param is_period_current: The is_period_current of this StripeSubscription.  # noqa: E501
        :type is_period_current: bool
        """
        if self.local_vars_configuration.client_side_validation and is_period_current is None:  # noqa: E501
            raise ValueError("Invalid value for `is_period_current`, must not be `None`")  # noqa: E501

        self._is_period_current = is_period_current

    @property
    def is_status_current(self):
        """Gets the is_status_current of this StripeSubscription.  # noqa: E501


        :return: The is_status_current of this StripeSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._is_status_current

    @is_status_current.setter
    def is_status_current(self, is_status_current):
        """Sets the is_status_current of this StripeSubscription.


        :param is_status_current: The is_status_current of this StripeSubscription.  # noqa: E501
        :type is_status_current: bool
        """
        if self.local_vars_configuration.client_side_validation and is_status_current is None:  # noqa: E501
            raise ValueError("Invalid value for `is_status_current`, must not be `None`")  # noqa: E501

        self._is_status_current = is_status_current

    @property
    def is_status_temporarily_current(self):
        """Gets the is_status_temporarily_current of this StripeSubscription.  # noqa: E501


        :return: The is_status_temporarily_current of this StripeSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._is_status_temporarily_current

    @is_status_temporarily_current.setter
    def is_status_temporarily_current(self, is_status_temporarily_current):
        """Sets the is_status_temporarily_current of this StripeSubscription.


        :param is_status_temporarily_current: The is_status_temporarily_current of this StripeSubscription.  # noqa: E501
        :type is_status_temporarily_current: bool
        """
        if self.local_vars_configuration.client_side_validation and is_status_temporarily_current is None:  # noqa: E501
            raise ValueError("Invalid value for `is_status_temporarily_current`, must not be `None`")  # noqa: E501

        self._is_status_temporarily_current = is_status_temporarily_current

    @property
    def is_valid(self):
        """Gets the is_valid of this StripeSubscription.  # noqa: E501


        :return: The is_valid of this StripeSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._is_valid

    @is_valid.setter
    def is_valid(self, is_valid):
        """Sets the is_valid of this StripeSubscription.


        :param is_valid: The is_valid of this StripeSubscription.  # noqa: E501
        :type is_valid: bool
        """
        if self.local_vars_configuration.client_side_validation and is_valid is None:  # noqa: E501
            raise ValueError("Invalid value for `is_valid`, must not be `None`")  # noqa: E501

        self._is_valid = is_valid

    @property
    def djstripe_created(self):
        """Gets the djstripe_created of this StripeSubscription.  # noqa: E501


        :return: The djstripe_created of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._djstripe_created

    @djstripe_created.setter
    def djstripe_created(self, djstripe_created):
        """Sets the djstripe_created of this StripeSubscription.


        :param djstripe_created: The djstripe_created of this StripeSubscription.  # noqa: E501
        :type djstripe_created: datetime
        """
        if self.local_vars_configuration.client_side_validation and djstripe_created is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_created`, must not be `None`")  # noqa: E501

        self._djstripe_created = djstripe_created

    @property
    def djstripe_updated(self):
        """Gets the djstripe_updated of this StripeSubscription.  # noqa: E501


        :return: The djstripe_updated of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._djstripe_updated

    @djstripe_updated.setter
    def djstripe_updated(self, djstripe_updated):
        """Sets the djstripe_updated of this StripeSubscription.


        :param djstripe_updated: The djstripe_updated of this StripeSubscription.  # noqa: E501
        :type djstripe_updated: datetime
        """
        if self.local_vars_configuration.client_side_validation and djstripe_updated is None:  # noqa: E501
            raise ValueError("Invalid value for `djstripe_updated`, must not be `None`")  # noqa: E501

        self._djstripe_updated = djstripe_updated

    @property
    def id(self):
        """Gets the id of this StripeSubscription.  # noqa: E501


        :return: The id of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this StripeSubscription.


        :param id: The id of this StripeSubscription.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 255):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `255`")  # noqa: E501

        self._id = id

    @property
    def livemode(self):
        """Gets the livemode of this StripeSubscription.  # noqa: E501

        Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.  # noqa: E501

        :return: The livemode of this StripeSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._livemode

    @livemode.setter
    def livemode(self, livemode):
        """Sets the livemode of this StripeSubscription.

        Null here indicates that the livemode status is unknown or was previously unrecorded. Otherwise, this field indicates whether this record comes from Stripe test mode or live mode operation.  # noqa: E501

        :param livemode: The livemode of this StripeSubscription.  # noqa: E501
        :type livemode: bool
        """

        self._livemode = livemode

    @property
    def created(self):
        """Gets the created of this StripeSubscription.  # noqa: E501

        The datetime this object was created in stripe.  # noqa: E501

        :return: The created of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this StripeSubscription.

        The datetime this object was created in stripe.  # noqa: E501

        :param created: The created of this StripeSubscription.  # noqa: E501
        :type created: datetime
        """

        self._created = created

    @property
    def metadata(self):
        """Gets the metadata of this StripeSubscription.  # noqa: E501

        A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format.  # noqa: E501

        :return: The metadata of this StripeSubscription.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this StripeSubscription.

        A set of key/value pairs that you can attach to an object. It can be useful for storing additional information about an object in a structured format.  # noqa: E501

        :param metadata: The metadata of this StripeSubscription.  # noqa: E501
        :type metadata: dict(str, object)
        """

        self._metadata = metadata

    @property
    def description(self):
        """Gets the description of this StripeSubscription.  # noqa: E501

        A description of this object.  # noqa: E501

        :return: The description of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this StripeSubscription.

        A description of this object.  # noqa: E501

        :param description: The description of this StripeSubscription.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def application_fee_percent(self):
        """Gets the application_fee_percent of this StripeSubscription.  # noqa: E501

        A positive decimal that represents the fee percentage of the subscription invoice amount that will be transferred to the application owner's Stripe account each billing period.  # noqa: E501

        :return: The application_fee_percent of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._application_fee_percent

    @application_fee_percent.setter
    def application_fee_percent(self, application_fee_percent):
        """Sets the application_fee_percent of this StripeSubscription.

        A positive decimal that represents the fee percentage of the subscription invoice amount that will be transferred to the application owner's Stripe account each billing period.  # noqa: E501

        :param application_fee_percent: The application_fee_percent of this StripeSubscription.  # noqa: E501
        :type application_fee_percent: str
        """
        if (self.local_vars_configuration.client_side_validation and
                application_fee_percent is not None and not re.search(r'^-?\d{0,3}(?:\.\d{0,2})?$', application_fee_percent)):  # noqa: E501
            raise ValueError(r"Invalid value for `application_fee_percent`, must be a follow pattern or equal to `/^-?\d{0,3}(?:\.\d{0,2})?$/`")  # noqa: E501

        self._application_fee_percent = application_fee_percent

    @property
    def billing_cycle_anchor(self):
        """Gets the billing_cycle_anchor of this StripeSubscription.  # noqa: E501

        Determines the date of the first full invoice, and, for plans with `month` or `year` intervals, the day of the month for subsequent invoices.  # noqa: E501

        :return: The billing_cycle_anchor of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._billing_cycle_anchor

    @billing_cycle_anchor.setter
    def billing_cycle_anchor(self, billing_cycle_anchor):
        """Sets the billing_cycle_anchor of this StripeSubscription.

        Determines the date of the first full invoice, and, for plans with `month` or `year` intervals, the day of the month for subsequent invoices.  # noqa: E501

        :param billing_cycle_anchor: The billing_cycle_anchor of this StripeSubscription.  # noqa: E501
        :type billing_cycle_anchor: datetime
        """

        self._billing_cycle_anchor = billing_cycle_anchor

    @property
    def billing_thresholds(self):
        """Gets the billing_thresholds of this StripeSubscription.  # noqa: E501

        Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period.  # noqa: E501

        :return: The billing_thresholds of this StripeSubscription.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._billing_thresholds

    @billing_thresholds.setter
    def billing_thresholds(self, billing_thresholds):
        """Sets the billing_thresholds of this StripeSubscription.

        Define thresholds at which an invoice will be sent, and the subscription advanced to a new billing period.  # noqa: E501

        :param billing_thresholds: The billing_thresholds of this StripeSubscription.  # noqa: E501
        :type billing_thresholds: dict(str, object)
        """

        self._billing_thresholds = billing_thresholds

    @property
    def cancel_at(self):
        """Gets the cancel_at of this StripeSubscription.  # noqa: E501

        A date in the future at which the subscription will automatically get canceled.  # noqa: E501

        :return: The cancel_at of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._cancel_at

    @cancel_at.setter
    def cancel_at(self, cancel_at):
        """Sets the cancel_at of this StripeSubscription.

        A date in the future at which the subscription will automatically get canceled.  # noqa: E501

        :param cancel_at: The cancel_at of this StripeSubscription.  # noqa: E501
        :type cancel_at: datetime
        """

        self._cancel_at = cancel_at

    @property
    def cancel_at_period_end(self):
        """Gets the cancel_at_period_end of this StripeSubscription.  # noqa: E501

        If the subscription has been canceled with the ``at_period_end`` flag set to true, ``cancel_at_period_end`` on the subscription will be true. You can use this attribute to determine whether a subscription that has a status of active is scheduled to be canceled at the end of the current period.  # noqa: E501

        :return: The cancel_at_period_end of this StripeSubscription.  # noqa: E501
        :rtype: bool
        """
        return self._cancel_at_period_end

    @cancel_at_period_end.setter
    def cancel_at_period_end(self, cancel_at_period_end):
        """Sets the cancel_at_period_end of this StripeSubscription.

        If the subscription has been canceled with the ``at_period_end`` flag set to true, ``cancel_at_period_end`` on the subscription will be true. You can use this attribute to determine whether a subscription that has a status of active is scheduled to be canceled at the end of the current period.  # noqa: E501

        :param cancel_at_period_end: The cancel_at_period_end of this StripeSubscription.  # noqa: E501
        :type cancel_at_period_end: bool
        """

        self._cancel_at_period_end = cancel_at_period_end

    @property
    def canceled_at(self):
        """Gets the canceled_at of this StripeSubscription.  # noqa: E501

        If the subscription has been canceled, the date of that cancellation. If the subscription was canceled with ``cancel_at_period_end``, canceled_at will still reflect the date of the initial cancellation request, not the end of the subscription period when the subscription is automatically moved to a canceled state.  # noqa: E501

        :return: The canceled_at of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._canceled_at

    @canceled_at.setter
    def canceled_at(self, canceled_at):
        """Sets the canceled_at of this StripeSubscription.

        If the subscription has been canceled, the date of that cancellation. If the subscription was canceled with ``cancel_at_period_end``, canceled_at will still reflect the date of the initial cancellation request, not the end of the subscription period when the subscription is automatically moved to a canceled state.  # noqa: E501

        :param canceled_at: The canceled_at of this StripeSubscription.  # noqa: E501
        :type canceled_at: datetime
        """

        self._canceled_at = canceled_at

    @property
    def collection_method(self):
        """Gets the collection_method of this StripeSubscription.  # noqa: E501

        Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay this subscription at the end of the cycle using the default source attached to the customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions.  # noqa: E501

        :return: The collection_method of this StripeSubscription.  # noqa: E501
        :rtype: CollectionMethodEnum
        """
        return self._collection_method

    @collection_method.setter
    def collection_method(self, collection_method):
        """Sets the collection_method of this StripeSubscription.

        Either `charge_automatically`, or `send_invoice`. When charging automatically, Stripe will attempt to pay this subscription at the end of the cycle using the default source attached to the customer. When sending an invoice, Stripe will email your customer an invoice with payment instructions.  # noqa: E501

        :param collection_method: The collection_method of this StripeSubscription.  # noqa: E501
        :type collection_method: CollectionMethodEnum
        """

        self._collection_method = collection_method

    @property
    def current_period_end(self):
        """Gets the current_period_end of this StripeSubscription.  # noqa: E501

        End of the current period for which the subscription has been invoiced. At the end of this period, a new invoice will be created.  # noqa: E501

        :return: The current_period_end of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._current_period_end

    @current_period_end.setter
    def current_period_end(self, current_period_end):
        """Sets the current_period_end of this StripeSubscription.

        End of the current period for which the subscription has been invoiced. At the end of this period, a new invoice will be created.  # noqa: E501

        :param current_period_end: The current_period_end of this StripeSubscription.  # noqa: E501
        :type current_period_end: datetime
        """
        if self.local_vars_configuration.client_side_validation and current_period_end is None:  # noqa: E501
            raise ValueError("Invalid value for `current_period_end`, must not be `None`")  # noqa: E501

        self._current_period_end = current_period_end

    @property
    def current_period_start(self):
        """Gets the current_period_start of this StripeSubscription.  # noqa: E501

        Start of the current period for which the subscription has been invoiced.  # noqa: E501

        :return: The current_period_start of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._current_period_start

    @current_period_start.setter
    def current_period_start(self, current_period_start):
        """Sets the current_period_start of this StripeSubscription.

        Start of the current period for which the subscription has been invoiced.  # noqa: E501

        :param current_period_start: The current_period_start of this StripeSubscription.  # noqa: E501
        :type current_period_start: datetime
        """
        if self.local_vars_configuration.client_side_validation and current_period_start is None:  # noqa: E501
            raise ValueError("Invalid value for `current_period_start`, must not be `None`")  # noqa: E501

        self._current_period_start = current_period_start

    @property
    def days_until_due(self):
        """Gets the days_until_due of this StripeSubscription.  # noqa: E501

        Number of days a customer has to pay invoices generated by this subscription. This value will be `null` for subscriptions where `billing=charge_automatically`.  # noqa: E501

        :return: The days_until_due of this StripeSubscription.  # noqa: E501
        :rtype: int
        """
        return self._days_until_due

    @days_until_due.setter
    def days_until_due(self, days_until_due):
        """Sets the days_until_due of this StripeSubscription.

        Number of days a customer has to pay invoices generated by this subscription. This value will be `null` for subscriptions where `billing=charge_automatically`.  # noqa: E501

        :param days_until_due: The days_until_due of this StripeSubscription.  # noqa: E501
        :type days_until_due: int
        """
        if (self.local_vars_configuration.client_side_validation and
                days_until_due is not None and days_until_due > 2147483647):  # noqa: E501
            raise ValueError("Invalid value for `days_until_due`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                days_until_due is not None and days_until_due < -2147483648):  # noqa: E501
            raise ValueError("Invalid value for `days_until_due`, must be a value greater than or equal to `-2147483648`")  # noqa: E501

        self._days_until_due = days_until_due

    @property
    def discount(self):
        """Gets the discount of this StripeSubscription.  # noqa: E501


        :return: The discount of this StripeSubscription.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._discount

    @discount.setter
    def discount(self, discount):
        """Sets the discount of this StripeSubscription.


        :param discount: The discount of this StripeSubscription.  # noqa: E501
        :type discount: dict(str, object)
        """

        self._discount = discount

    @property
    def ended_at(self):
        """Gets the ended_at of this StripeSubscription.  # noqa: E501

        If the subscription has ended (either because it was canceled or because the customer was switched to a subscription to a new plan), the date the subscription ended.  # noqa: E501

        :return: The ended_at of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._ended_at

    @ended_at.setter
    def ended_at(self, ended_at):
        """Sets the ended_at of this StripeSubscription.

        If the subscription has ended (either because it was canceled or because the customer was switched to a subscription to a new plan), the date the subscription ended.  # noqa: E501

        :param ended_at: The ended_at of this StripeSubscription.  # noqa: E501
        :type ended_at: datetime
        """

        self._ended_at = ended_at

    @property
    def next_pending_invoice_item_invoice(self):
        """Gets the next_pending_invoice_item_invoice of this StripeSubscription.  # noqa: E501

        Specifies the approximate timestamp on which any pending invoice items will be billed according to the schedule provided at pending_invoice_item_interval.  # noqa: E501

        :return: The next_pending_invoice_item_invoice of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._next_pending_invoice_item_invoice

    @next_pending_invoice_item_invoice.setter
    def next_pending_invoice_item_invoice(self, next_pending_invoice_item_invoice):
        """Sets the next_pending_invoice_item_invoice of this StripeSubscription.

        Specifies the approximate timestamp on which any pending invoice items will be billed according to the schedule provided at pending_invoice_item_interval.  # noqa: E501

        :param next_pending_invoice_item_invoice: The next_pending_invoice_item_invoice of this StripeSubscription.  # noqa: E501
        :type next_pending_invoice_item_invoice: datetime
        """

        self._next_pending_invoice_item_invoice = next_pending_invoice_item_invoice

    @property
    def pending_invoice_item_interval(self):
        """Gets the pending_invoice_item_interval of this StripeSubscription.  # noqa: E501

        Specifies an interval for how often to bill for any pending invoice items. It is analogous to calling Create an invoice for the given subscription at the specified interval.  # noqa: E501

        :return: The pending_invoice_item_interval of this StripeSubscription.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._pending_invoice_item_interval

    @pending_invoice_item_interval.setter
    def pending_invoice_item_interval(self, pending_invoice_item_interval):
        """Sets the pending_invoice_item_interval of this StripeSubscription.

        Specifies an interval for how often to bill for any pending invoice items. It is analogous to calling Create an invoice for the given subscription at the specified interval.  # noqa: E501

        :param pending_invoice_item_interval: The pending_invoice_item_interval of this StripeSubscription.  # noqa: E501
        :type pending_invoice_item_interval: dict(str, object)
        """

        self._pending_invoice_item_interval = pending_invoice_item_interval

    @property
    def pending_update(self):
        """Gets the pending_update of this StripeSubscription.  # noqa: E501

        If specified, pending updates that will be applied to the subscription once the latest_invoice has been paid.  # noqa: E501

        :return: The pending_update of this StripeSubscription.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._pending_update

    @pending_update.setter
    def pending_update(self, pending_update):
        """Sets the pending_update of this StripeSubscription.

        If specified, pending updates that will be applied to the subscription once the latest_invoice has been paid.  # noqa: E501

        :param pending_update: The pending_update of this StripeSubscription.  # noqa: E501
        :type pending_update: dict(str, object)
        """

        self._pending_update = pending_update

    @property
    def quantity(self):
        """Gets the quantity of this StripeSubscription.  # noqa: E501

        The quantity applied to this subscription. This value will be `null` for multi-plan subscriptions  # noqa: E501

        :return: The quantity of this StripeSubscription.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this StripeSubscription.

        The quantity applied to this subscription. This value will be `null` for multi-plan subscriptions  # noqa: E501

        :param quantity: The quantity of this StripeSubscription.  # noqa: E501
        :type quantity: int
        """
        if (self.local_vars_configuration.client_side_validation and
                quantity is not None and quantity > 2147483647):  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                quantity is not None and quantity < -2147483648):  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must be a value greater than or equal to `-2147483648`")  # noqa: E501

        self._quantity = quantity

    @property
    def start_date(self):
        """Gets the start_date of this StripeSubscription.  # noqa: E501

        Date when the subscription was first created. The date might differ from the created date due to backdating.  # noqa: E501

        :return: The start_date of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this StripeSubscription.

        Date when the subscription was first created. The date might differ from the created date due to backdating.  # noqa: E501

        :param start_date: The start_date of this StripeSubscription.  # noqa: E501
        :type start_date: datetime
        """

        self._start_date = start_date

    @property
    def status(self):
        """Gets the status of this StripeSubscription.  # noqa: E501

        The status of this subscription.  # noqa: E501

        :return: The status of this StripeSubscription.  # noqa: E501
        :rtype: StripeSubscriptionStatusEnum
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this StripeSubscription.

        The status of this subscription.  # noqa: E501

        :param status: The status of this StripeSubscription.  # noqa: E501
        :type status: StripeSubscriptionStatusEnum
        """

        self._status = status

    @property
    def trial_end(self):
        """Gets the trial_end of this StripeSubscription.  # noqa: E501

        If the subscription has a trial, the end of that trial.  # noqa: E501

        :return: The trial_end of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._trial_end

    @trial_end.setter
    def trial_end(self, trial_end):
        """Sets the trial_end of this StripeSubscription.

        If the subscription has a trial, the end of that trial.  # noqa: E501

        :param trial_end: The trial_end of this StripeSubscription.  # noqa: E501
        :type trial_end: datetime
        """

        self._trial_end = trial_end

    @property
    def trial_start(self):
        """Gets the trial_start of this StripeSubscription.  # noqa: E501

        If the subscription has a trial, the beginning of that trial.  # noqa: E501

        :return: The trial_start of this StripeSubscription.  # noqa: E501
        :rtype: datetime
        """
        return self._trial_start

    @trial_start.setter
    def trial_start(self, trial_start):
        """Sets the trial_start of this StripeSubscription.

        If the subscription has a trial, the beginning of that trial.  # noqa: E501

        :param trial_start: The trial_start of this StripeSubscription.  # noqa: E501
        :type trial_start: datetime
        """

        self._trial_start = trial_start

    @property
    def djstripe_owner_account(self):
        """Gets the djstripe_owner_account of this StripeSubscription.  # noqa: E501

        The Stripe Account this object belongs to.  # noqa: E501

        :return: The djstripe_owner_account of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._djstripe_owner_account

    @djstripe_owner_account.setter
    def djstripe_owner_account(self, djstripe_owner_account):
        """Sets the djstripe_owner_account of this StripeSubscription.

        The Stripe Account this object belongs to.  # noqa: E501

        :param djstripe_owner_account: The djstripe_owner_account of this StripeSubscription.  # noqa: E501
        :type djstripe_owner_account: str
        """

        self._djstripe_owner_account = djstripe_owner_account

    @property
    def customer(self):
        """Gets the customer of this StripeSubscription.  # noqa: E501

        The customer associated with this subscription.  # noqa: E501

        :return: The customer of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._customer

    @customer.setter
    def customer(self, customer):
        """Sets the customer of this StripeSubscription.

        The customer associated with this subscription.  # noqa: E501

        :param customer: The customer of this StripeSubscription.  # noqa: E501
        :type customer: str
        """
        if self.local_vars_configuration.client_side_validation and customer is None:  # noqa: E501
            raise ValueError("Invalid value for `customer`, must not be `None`")  # noqa: E501

        self._customer = customer

    @property
    def default_source(self):
        """Gets the default_source of this StripeSubscription.  # noqa: E501

        The default payment source for the subscription. It must belong to the customer associated with the subscription and be in a chargeable state. If not set, defaults to the customer's default source.  # noqa: E501

        :return: The default_source of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._default_source

    @default_source.setter
    def default_source(self, default_source):
        """Sets the default_source of this StripeSubscription.

        The default payment source for the subscription. It must belong to the customer associated with the subscription and be in a chargeable state. If not set, defaults to the customer's default source.  # noqa: E501

        :param default_source: The default_source of this StripeSubscription.  # noqa: E501
        :type default_source: str
        """

        self._default_source = default_source

    @property
    def latest_invoice(self):
        """Gets the latest_invoice of this StripeSubscription.  # noqa: E501

        The most recent invoice this subscription has generated.  # noqa: E501

        :return: The latest_invoice of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._latest_invoice

    @latest_invoice.setter
    def latest_invoice(self, latest_invoice):
        """Sets the latest_invoice of this StripeSubscription.

        The most recent invoice this subscription has generated.  # noqa: E501

        :param latest_invoice: The latest_invoice of this StripeSubscription.  # noqa: E501
        :type latest_invoice: str
        """

        self._latest_invoice = latest_invoice

    @property
    def pending_setup_intent(self):
        """Gets the pending_setup_intent of this StripeSubscription.  # noqa: E501

        We can use this SetupIntent to collect user authentication when creating a subscription without immediate payment or updating a subscription's payment method, allowing you to optimize for off-session payments.  # noqa: E501

        :return: The pending_setup_intent of this StripeSubscription.  # noqa: E501
        :rtype: str
        """
        return self._pending_setup_intent

    @pending_setup_intent.setter
    def pending_setup_intent(self, pending_setup_intent):
        """Sets the pending_setup_intent of this StripeSubscription.

        We can use this SetupIntent to collect user authentication when creating a subscription without immediate payment or updating a subscription's payment method, allowing you to optimize for off-session payments.  # noqa: E501

        :param pending_setup_intent: The pending_setup_intent of this StripeSubscription.  # noqa: E501
        :type pending_setup_intent: str
        """

        self._pending_setup_intent = pending_setup_intent

    @property
    def default_tax_rates(self):
        """Gets the default_tax_rates of this StripeSubscription.  # noqa: E501

        The tax rates that will apply to any subscription item that does not have tax_rates set. Invoices created will have their default_tax_rates populated from the subscription.  # noqa: E501

        :return: The default_tax_rates of this StripeSubscription.  # noqa: E501
        :rtype: list[int]
        """
        return self._default_tax_rates

    @default_tax_rates.setter
    def default_tax_rates(self, default_tax_rates):
        """Sets the default_tax_rates of this StripeSubscription.

        The tax rates that will apply to any subscription item that does not have tax_rates set. Invoices created will have their default_tax_rates populated from the subscription.  # noqa: E501

        :param default_tax_rates: The default_tax_rates of this StripeSubscription.  # noqa: E501
        :type default_tax_rates: list[int]
        """

        self._default_tax_rates = default_tax_rates

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StripeSubscription):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StripeSubscription):
            return True

        return self.to_dict() != other.to_dict()
