from enum import Enum


class TokenType(str, Enum):
    """
    https://github.com/ocpi/ocpi/blob/480973547169dee2fe6d12b1a0fe604623efcbb5/mod_tokens.asciidoc#144-tokentype-enum
    """
    # One time use Token ID generated by a server (or App.)
    # The eMSP uses this to bind a Session to a customer, probably an app user.
    ad_hoc_user = 'AD_HOC_USER'
    # Token ID generated by a server (or App.) to identify a user of an App.
    # The same user uses the same Token for every Session.
    app_user = 'APP_USER'
    # Other type of token
    other = 'OTHER'
    # RFID Token
    rfid = 'RFID'
