# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.


class SnapshotTaskSummary(object):

    def __init__(self, taskId=None, jobId=None, videoId=None, snapshotType=None, status=None, outputBucket=None, outputFileKey=None, spriteFileKey=None, errorCode=None, errorMessage=None, createTime=None, updateTime=None):
        """
        :param taskId: (Optional) 任务ID
        :param jobId: (Optional) job ID
        :param videoId: (Optional) 视频ID
        :param snapshotType: (Optional) 模板类型。取值范围：
  sample - 采样截图模板
  sprite - 雪碧图模板

        :param status: (Optional) 任务状态。
- submitted
- processing
- succeeded
- failed

        :param outputBucket: (Optional) 输出对象存储空间
        :param outputFileKey: (Optional) 截图输出路径，包含占位符的截图输出路径。当前支持的占位符包括：
  {FILENAME} - 输入视频的简单文件名，如 "我和我的祖国"
  {TASKID} - 该截图任务的ID，如 "7234584d911b4e0db2fa13545c764898"
  {YEAR} - 四位数字年份，如 "2020"
  {MONTH} - 两位数字月份，如 "04"
  {DAY} - 两位数字日期，如 "15"
若未设置，则使用默认的输出路径：snapshot/{YEAR}/{MONTH}/{DAY}/{FILENAME}/ ，最终解析出的路径如 snapshot/2020/04/15/我和我的祖国/
为保证输出文件的唯一性，避免覆盖，系统会按照一定规则生成文件名，规则如下：
对于普通截图，生成 {TASKID}.{SEQUENCEID}.{EXTNAME} 规则的文件名；
对于雪碧图，生成 {TASKID}.{SEQUENCEID}-sprite.{EXTNAME} 规则的文件名；
其中 SEQUENCEID 为左补0的6位数字截图序号，EXTNAME 为截图模板中截图格式 format 字段对应的文件扩展名
综述，若未设置此字段，则最终输出的普通截图形如：snapshot/2020/04/15/我和我的祖国/7234584d911b4e0db2fa13545c764898.000001.jpg ; 雪碧图形如：snapshot/2020/04/15/我和我的祖国/7234584d911b4e0db2fa13545c764898-sprite.jpg

        :param spriteFileKey: (Optional) 对于雪碧图，生成 {TASKID}-sprite.{EXTNAME} 规则的文件名；

        :param errorCode: (Optional) 错误码
        :param errorMessage: (Optional) 错误信息
        :param createTime: (Optional) 创建时间
        :param updateTime: (Optional) 修改时间
        """

        self.taskId = taskId
        self.jobId = jobId
        self.videoId = videoId
        self.snapshotType = snapshotType
        self.status = status
        self.outputBucket = outputBucket
        self.outputFileKey = outputFileKey
        self.spriteFileKey = spriteFileKey
        self.errorCode = errorCode
        self.errorMessage = errorMessage
        self.createTime = createTime
        self.updateTime = updateTime
