# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class DeleteImageRequest(JDCloudRequest):
    """
    
删除一个私有镜像。

详细操作说明请参考帮助文档：[删除私有镜像](https://docs.jdcloud.com/cn/virtual-machines/delete-private-image)

## 接口说明
- 已共享的私有镜像在取消共享关系前不可以删除，如私有镜像已共享给其他用户，请取消共享后再进行删除。
- 本地系统盘镜像在有基于其创建的云主机时，将无法删除。
- 只能操作私有镜像。
- 私有镜像没有正在处理中的任务时才可以删除。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(DeleteImageRequest, self).__init__(
            '/regions/{regionId}/images/{imageId}', 'DELETE', header, version)
        self.parameters = parameters


class DeleteImageParameters(object):

    def __init__(self,regionId, imageId, ):
        """
        :param regionId: 地域ID。
        :param imageId: 镜像ID。
        """

        self.regionId = regionId
        self.imageId = imageId
        self.deleteSnapshot = None

    def setDeleteSnapshot(self, deleteSnapshot):
        """
        :param deleteSnapshot: (Optional) 删除镜像时是否删除关联的快照。默认为 `false`；如果指定为 `true`, 将会删除镜像关联的快照。

        """
        self.deleteSnapshot = deleteSnapshot

