# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateImageFromSnapshotsRequest(JDCloudRequest):
    """
    
基于快照制作私有镜像，支持指定单个快照创建系统盘镜像；指定多个快照组合创建整机镜像

## 接口说明
- 快照须为可用状态，且需有指定快照的权限，快照数量为1-8块。
- 单块快照创建镜像，设备名必须为vda；多块快照创建镜像，设备名必须包含vda。
- 设置云盘的容量需大于快照容量。
- 调用接口后，需要等待镜像状态变为 ready 后，才能正常使用镜像。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateImageFromSnapshotsRequest, self).__init__(
            '/regions/{regionId}/images:createImageFromSnapshots', 'POST', header, version)
        self.parameters = parameters


class CreateImageFromSnapshotsParameters(object):

    def __init__(self,regionId, name, platform, architecture, ):
        """
        :param regionId: 地域ID。
        :param name: 镜像名称，长度为2\~32个字符，只允许中文、数字、大小写字母、英文下划线（\_）、连字符（-）及点（.）。

        :param platform: 镜像的操作系统类型, 可选值：CentOS、Ubuntu、Windows Server、OpenEuler、Rocky Linux、Others Linux。

        :param architecture: 操作系统架构, 可选值：x86_64、arm64。

        """

        self.regionId = regionId
        self.name = name
        self.description = None
        self.platform = platform
        self.osVersion = None
        self.architecture = architecture
        self.cloudDisks = None
        self.clientToken = None

    def setDescription(self, description):
        """
        :param description: (Optional) 镜像描述，256字符以内。

        """
        self.description = description

    def setOsVersion(self, osVersion):
        """
        :param osVersion: (Optional) 操作系统版本。如：7.9

        """
        self.osVersion = osVersion

    def setCloudDisks(self, cloudDisks):
        """
        :param cloudDisks: (Optional) 云盘快照信息。

        """
        self.cloudDisks = cloudDisks

    def setClientToken(self, clientToken):
        """
        :param clientToken: (Optional) 用于保证请求的幂等性。由客户端生成，并确保不同请求中该参数唯一，长度不能超过64个字符。

        """
        self.clientToken = clientToken

