# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CopyImagesRequest(JDCloudRequest):
    """
    
镜像跨地域复制。

详细操作说明请参考帮助文档：[镜像复制](https://docs.jdcloud.com/cn/virtual-machines/copy-image)

## 接口说明
- 调用该接口将私有镜像复制到其它地域下。
- 只支持云盘系统盘的镜像。
- 不支持带有加密快照的镜像。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CopyImagesRequest, self).__init__(
            '/regions/{regionId}/images:copyImages', 'POST', header, version)
        self.parameters = parameters


class CopyImagesParameters(object):

    def __init__(self,regionId, sourceImageIds, destinationRegion):
        """
        :param regionId: 地域ID。
        :param sourceImageIds: 要复制的私有镜像ID列表，最多支持10个。
        :param destinationRegion: 目标地域。
        """

        self.regionId = regionId
        self.sourceImageIds = sourceImageIds
        self.destinationRegion = destinationRegion

