# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class CreateLogpushJobRequest(JDCloudRequest):
    """
    为域创建新的日志推送作业
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(CreateLogpushJobRequest, self).__init__(
            '/zones/{zone_identifier}/logpush$$jobs', 'POST', header, version)
        self.parameters = parameters


class CreateLogpushJobParameters(object):

    def __init__(self,zone_identifier, ):
        """
        :param zone_identifier: 
        """

        self.zone_identifier = zone_identifier
        self.zone_name = None
        self.destination_conf = None
        self.name = None
        self.enabled = None
        self.dataset = None
        self.logpull_options = None

    def setZone_name(self, zone_name):
        """
        :param zone_name: (Optional) 域名
        """
        self.zone_name = zone_name

    def setDestination_conf(self, destination_conf):
        """
        :param destination_conf: (Optional) 唯一标识数据推送目的地的字符串。可能包括目的地支持的其他参数。
例如：splunk://splunk.cf-analytics.com:8088/services/collector/raw?channel=xxx&header_Authorization=Splunk xxx&sourcetype=xxx&insecure-skip-verify=false

        """
        self.destination_conf = destination_conf

    def setName(self, name):
        """
        :param name: (Optional) 可选的用户可读的作业名称。不是独一无二的。使用户更容易识别工作。建议包含域名称。
        """
        self.name = name

    def setEnabled(self, enabled):
        """
        :param enabled: (Optional) 默认值false
        """
        self.enabled = enabled

    def setDataset(self, dataset):
        """
        :param dataset: (Optional) 要推送的数据集。合法值为：http/firewall。
        """
        self.dataset = dataset

    def setLogpull_options(self, logpull_options):
        """
        :param logpull_options: (Optional) 它指定了诸如请求的字段和时间戳格式之类的内容。例如：fields=fieldName1,fieldName2,fileNamek&timestamps=rfc3339&sample=0.1
        """
        self.logpull_options = logpull_options

