# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class AllocDedicatedHostsRequest(JDCloudRequest):
    """
    创建一台或多台指定机型的专有宿主机。<br>
创建专有宿主机必须指定专有宿主机池。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(AllocDedicatedHostsRequest, self).__init__(
            '/regions/{regionId}/dedicatedHosts', 'POST', header, version)
        self.parameters = parameters


class AllocDedicatedHostsParameters(object):

    def __init__(self,regionId, dedicatedHostSpec, ):
        """
        :param regionId: 地域ID
        :param dedicatedHostSpec: 描述专有宿主机配置

        """

        self.regionId = regionId
        self.dedicatedHostSpec = dedicatedHostSpec
        self.deployPolicy = None
        self.maxCount = None
        self.clientToken = None
        self.enableCpuTopology = None

    def setDeployPolicy(self, deployPolicy):
        """
        :param deployPolicy: (Optional) 是否支持AZ内专有宿主机强制均衡，默认为preferred--非强制，取值[preferred--非强制,required--强制]

        """
        self.deployPolicy = deployPolicy

    def setMaxCount(self, maxCount):
        """
        :param maxCount: (Optional) 购买云主机的数量；取值范围：[1,100]，默认为1。

        """
        self.maxCount = maxCount

    def setClientToken(self, clientToken):
        """
        :param clientToken: (Optional) 用于保证请求的幂等性。由客户端生成，长度不能超过64个字符。

        """
        self.clientToken = clientToken

    def setEnableCpuTopology(self, enableCpuTopology):
        """
        :param enableCpuTopology: (Optional) 是否开启cpu拓扑，true:开启，false:关闭，只有宿主机是非超卖模式，且没有资源的时候才能开启；开启后，该宿主机上的虚机可以配置cpu拓扑和NUMA映射等。

        """
        self.enableCpuTopology = enableCpuTopology

