# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class ReleaseAuthorizationTokenRequest(JDCloudRequest):
    """
    释放用户 registry 的 token。

    """

    def __init__(self, parameters, header=None, version="v1"):
        super(ReleaseAuthorizationTokenRequest, self).__init__(
            '/regions/{regionId}/registries/{registryName}:releaseAuthorizationToken', 'POST', header, version)
        self.parameters = parameters


class ReleaseAuthorizationTokenParameters(object):

    def __init__(self, regionId, registryName, ):
        """
        :param regionId: 地域 ID
        :param registryName: 注册表名称
        """

        self.regionId = regionId
        self.registryName = registryName
        self.authorizationToken = None
        self.forceAll = None

    def setAuthorizationToken(self, authorizationToken):
        """
        :param authorizationToken: (Optional) 准备释放的 token ID，功能为指定token释放。
        """
        self.authorizationToken = authorizationToken

    def setForceAll(self, forceAll):
        """
        :param forceAll: (Optional) true 表示强制删除用户当前registry下所有有效token的标志；false 表示删除所有有效token。
        """
        self.forceAll = forceAll

