"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeActivity = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 *
 * @deprecated use `StepFunctionsInvokeActivity`
 */
class InvokeActivity {
    constructor(activity, props = {}) {
        this.activity = activity;
        this.props = props;
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.InvokeActivity", "use `StepFunctionsInvokeActivity`");
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_InvokeActivityProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InvokeActivity);
            }
            throw error;
        }
    }
    bind(_task) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.InvokeActivity#bind", "use `StepFunctionsInvokeActivity`");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            resourceArn: this.activity.activityArn,
            metricDimensions: { ActivityArn: this.activity.activityArn },
            heartbeat: this.props.heartbeat,
            // No IAM permissions necessary, execution role implicitly has Activity permissions.
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
}
exports.InvokeActivity = InvokeActivity;
_a = JSII_RTTI_SYMBOL_1;
InvokeActivity[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.InvokeActivity", version: "1.164.0" };
//# sourceMappingURL=data:application/json;base64,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