# coding: utf-8

"""
    Fox API

     Warning: Please add a custom user agent header to your requests. This would help us fighting against DDoS attacks in future, while keeping your application's access to the API. In future, this may be a mandatory requirement.  To reduce the system load, the API endpoints are rate limited. The default limit is 30 requests per minute. Contact admin@orangefox.tech if you need a higher limit.  The requests may be logged for analytics and development purposes. 

    The version of the OpenAPI document: 5.2.5
    Contact: admin@orangefox.tech
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from foxclient.models.release_type import ReleaseType
from typing import Optional, Set
from typing_extensions import Self

class ShortReleaseResponse(BaseModel):
    """
    ShortReleaseResponse
    """ # noqa: E501
    id: StrictStr = Field(alias="_id")
    size: StrictInt
    id: StrictStr = Field(description="Release ID, that's how we indentify the release in the infrastructure")
    build_id: Optional[StrictStr] = None
    filename: StrictStr
    variant: StrictStr
    device_id: StrictStr
    var_date: Union[StrictFloat, StrictInt] = Field(alias="date")
    md5: StrictStr
    version: StrictStr
    type: ReleaseType
    maintainer_id: Optional[StrictStr] = None
    archived: StrictBool
    __properties: ClassVar[List[str]] = ["_id", "size", "id", "build_id", "filename", "variant", "device_id", "date", "md5", "version", "type", "maintainer_id", "archived"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ShortReleaseResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if build_id (nullable) is None
        # and model_fields_set contains the field
        if self.build_id is None and "build_id" in self.model_fields_set:
            _dict['build_id'] = None

        # set to None if maintainer_id (nullable) is None
        # and model_fields_set contains the field
        if self.maintainer_id is None and "maintainer_id" in self.model_fields_set:
            _dict['maintainer_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ShortReleaseResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "size": obj.get("size"),
            "id": obj.get("id"),
            "build_id": obj.get("build_id"),
            "filename": obj.get("filename"),
            "variant": obj.get("variant"),
            "device_id": obj.get("device_id"),
            "date": obj.get("date"),
            "md5": obj.get("md5"),
            "version": obj.get("version"),
            "type": obj.get("type"),
            "maintainer_id": obj.get("maintainer_id"),
            "archived": obj.get("archived")
        })
        return _obj


