# coding: utf-8

"""
    Fox API

     Warning: Please add a custom user agent header to your requests. This would help us fighting against DDoS attacks in future, while keeping your application's access to the API. In future, this may be a mandatory requirement.  To reduce the system load, the API endpoints are rate limited. The default limit is 30 requests per minute. Contact admin@orangefox.tech if you need a higher limit.  The requests may be logged for analytics and development purposes. 

    The version of the OpenAPI document: 5.2.5
    Contact: admin@orangefox.tech
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from foxclient.models.list_response_short_release_response import ListResponseShortReleaseResponse
from foxclient.models.release_response import ReleaseResponse
from foxclient.models.release_type import ReleaseType
from foxclient.models.releases_sort import ReleasesSort
from foxclient.models.response_get_releases import ResponseGetReleases

from foxclient.api_client import ApiClient, RequestSerialized
from foxclient.api_response import ApiResponse
from foxclient.rest import RESTResponseType


class ReleaseApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def get_release(
        self,
        release_id: Annotated[Optional[StrictStr], Field(description="Release ID")] = None,
        id: Annotated[Optional[StrictStr], Field(description="Release ID (deprecated)")] = None,
        build_id: Annotated[Optional[StrictStr], Field(description="Build ID, `ro.build.fox_id` prop")] = None,
        filename: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReleaseResponse:
        """Get Release

        Extended get device method, including the ability to get a device using device codename instead of the ID and Build ID.  Example: /device/get?codename=lavender  Calling this method without parameters will return the latest available release in the database  Warning: the filename identification is deprecated! Use /release/<release_id> instead!

        :param release_id: Release ID
        :type release_id: str
        :param id: Release ID (deprecated)
        :type id: str
        :param build_id: Build ID, `ro.build.fox_id` prop
        :type build_id: str
        :param filename:
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_release_serialize(
            release_id=release_id,
            id=id,
            build_id=build_id,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_release_with_http_info(
        self,
        release_id: Annotated[Optional[StrictStr], Field(description="Release ID")] = None,
        id: Annotated[Optional[StrictStr], Field(description="Release ID (deprecated)")] = None,
        build_id: Annotated[Optional[StrictStr], Field(description="Build ID, `ro.build.fox_id` prop")] = None,
        filename: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReleaseResponse]:
        """Get Release

        Extended get device method, including the ability to get a device using device codename instead of the ID and Build ID.  Example: /device/get?codename=lavender  Calling this method without parameters will return the latest available release in the database  Warning: the filename identification is deprecated! Use /release/<release_id> instead!

        :param release_id: Release ID
        :type release_id: str
        :param id: Release ID (deprecated)
        :type id: str
        :param build_id: Build ID, `ro.build.fox_id` prop
        :type build_id: str
        :param filename:
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_release_serialize(
            release_id=release_id,
            id=id,
            build_id=build_id,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_release_without_preload_content(
        self,
        release_id: Annotated[Optional[StrictStr], Field(description="Release ID")] = None,
        id: Annotated[Optional[StrictStr], Field(description="Release ID (deprecated)")] = None,
        build_id: Annotated[Optional[StrictStr], Field(description="Build ID, `ro.build.fox_id` prop")] = None,
        filename: Optional[StrictStr] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Release

        Extended get device method, including the ability to get a device using device codename instead of the ID and Build ID.  Example: /device/get?codename=lavender  Calling this method without parameters will return the latest available release in the database  Warning: the filename identification is deprecated! Use /release/<release_id> instead!

        :param release_id: Release ID
        :type release_id: str
        :param id: Release ID (deprecated)
        :type id: str
        :param build_id: Build ID, `ro.build.fox_id` prop
        :type build_id: str
        :param filename:
        :type filename: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_release_serialize(
            release_id=release_id,
            id=id,
            build_id=build_id,
            filename=filename,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_release_serialize(
        self,
        release_id,
        id,
        build_id,
        filename,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if release_id is not None:
            
            _query_params.append(('release_id', release_id))
            
        if id is not None:
            
            _query_params.append(('_id', id))
            
        if build_id is not None:
            
            _query_params.append(('build_id', build_id))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/releases/get',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_release_deprecated(
        self,
        release_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReleaseResponse:
        """(Deprecated) Get Release Short

        Gets release information using the release ID, nothing to discuss really.

        :param release_id: (required)
        :type release_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /releases/{release_id} is deprecated.", DeprecationWarning)

        _param = self._get_release_deprecated_serialize(
            release_id=release_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_release_deprecated_with_http_info(
        self,
        release_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReleaseResponse]:
        """(Deprecated) Get Release Short

        Gets release information using the release ID, nothing to discuss really.

        :param release_id: (required)
        :type release_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /releases/{release_id} is deprecated.", DeprecationWarning)

        _param = self._get_release_deprecated_serialize(
            release_id=release_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_release_deprecated_without_preload_content(
        self,
        release_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Get Release Short

        Gets release information using the release ID, nothing to discuss really.

        :param release_id: (required)
        :type release_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /releases/{release_id} is deprecated.", DeprecationWarning)

        _param = self._get_release_deprecated_serialize(
            release_id=release_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_release_deprecated_serialize(
        self,
        release_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if release_id is not None:
            _path_params['release_id'] = release_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/releases/{release_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_releases(
        self,
        id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Release IDs")] = None,
        id2: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Release IDs (deprecated)")] = None,
        build_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by Build IDs")] = None,
        device_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Device IDs")] = None,
        maintainer_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Maintainer IDs")] = None,
        codename: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device codenames")] = None,
        version: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by release version")] = None,
        type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type")] = None,
        archived: Annotated[Optional[StrictBool], Field(description="Filter by the archived status")] = None,
        freezed: Annotated[Optional[StrictBool], Field(description="Filter by the freezed status")] = None,
        after_release_id: Annotated[Optional[StrictStr], Field(description="Show releases after the provided one")] = None,
        after_date: Annotated[Optional[StrictInt], Field(description="Show releases after the provided timestamp")] = None,
        sort: Annotated[Optional[ReleasesSort], Field(description="Sort mode")] = None,
        group: Annotated[Optional[StrictBool], Field(description="Group releases by version + variant. This will change the response!")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResponseGetReleases:
        """Get Releases

        Lists releases.  This method contains a bunch of different parameters to filter releases for different cases. For example, you may use ?after_release_id param to get only releases that came after the last known one  (aka get updates).  You can filter releases by maintainer_id to get releases from a specific maintainer. This is the maintainer who released the build, not the current maintainer of the device.  Getting releases by device codename is obsolete thought. The reason for this is that devices could change  codenames eventually. Unfortunately, some OEMs and community make a total mess of them. Please use /device methods to determine the right device (preferably with the user decision), save the device ID  somewhere and use it afterward.  Version tag is deprecated for the same reason, it's not really consistent, as it might contain patch and mod  versions and very different by each maintainer.

        :param id: Filter by Release IDs
        :type id: List[Optional[str]]
        :param id2: Filter by Release IDs (deprecated)
        :type id2: List[Optional[str]]
        :param build_id: Filter by Build IDs
        :type build_id: List[str]
        :param device_id: Filter by Device IDs
        :type device_id: List[Optional[str]]
        :param maintainer_id: Filter by Maintainer IDs
        :type maintainer_id: List[Optional[str]]
        :param codename: Filter by device codenames
        :type codename: List[Optional[str]]
        :param version: Filter by release version
        :type version: List[Optional[str]]
        :param type: Filter by release type
        :type type: List[ReleaseType]
        :param archived: Filter by the archived status
        :type archived: bool
        :param freezed: Filter by the freezed status
        :type freezed: bool
        :param after_release_id: Show releases after the provided one
        :type after_release_id: str
        :param after_date: Show releases after the provided timestamp
        :type after_date: int
        :param sort: Sort mode
        :type sort: ReleasesSort
        :param group: Group releases by version + variant. This will change the response!
        :type group: bool
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_releases_serialize(
            id=id,
            id2=id2,
            build_id=build_id,
            device_id=device_id,
            maintainer_id=maintainer_id,
            codename=codename,
            version=version,
            type=type,
            archived=archived,
            freezed=freezed,
            after_release_id=after_release_id,
            after_date=after_date,
            sort=sort,
            group=group,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResponseGetReleases",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_releases_with_http_info(
        self,
        id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Release IDs")] = None,
        id2: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Release IDs (deprecated)")] = None,
        build_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by Build IDs")] = None,
        device_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Device IDs")] = None,
        maintainer_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Maintainer IDs")] = None,
        codename: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device codenames")] = None,
        version: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by release version")] = None,
        type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type")] = None,
        archived: Annotated[Optional[StrictBool], Field(description="Filter by the archived status")] = None,
        freezed: Annotated[Optional[StrictBool], Field(description="Filter by the freezed status")] = None,
        after_release_id: Annotated[Optional[StrictStr], Field(description="Show releases after the provided one")] = None,
        after_date: Annotated[Optional[StrictInt], Field(description="Show releases after the provided timestamp")] = None,
        sort: Annotated[Optional[ReleasesSort], Field(description="Sort mode")] = None,
        group: Annotated[Optional[StrictBool], Field(description="Group releases by version + variant. This will change the response!")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResponseGetReleases]:
        """Get Releases

        Lists releases.  This method contains a bunch of different parameters to filter releases for different cases. For example, you may use ?after_release_id param to get only releases that came after the last known one  (aka get updates).  You can filter releases by maintainer_id to get releases from a specific maintainer. This is the maintainer who released the build, not the current maintainer of the device.  Getting releases by device codename is obsolete thought. The reason for this is that devices could change  codenames eventually. Unfortunately, some OEMs and community make a total mess of them. Please use /device methods to determine the right device (preferably with the user decision), save the device ID  somewhere and use it afterward.  Version tag is deprecated for the same reason, it's not really consistent, as it might contain patch and mod  versions and very different by each maintainer.

        :param id: Filter by Release IDs
        :type id: List[Optional[str]]
        :param id2: Filter by Release IDs (deprecated)
        :type id2: List[Optional[str]]
        :param build_id: Filter by Build IDs
        :type build_id: List[str]
        :param device_id: Filter by Device IDs
        :type device_id: List[Optional[str]]
        :param maintainer_id: Filter by Maintainer IDs
        :type maintainer_id: List[Optional[str]]
        :param codename: Filter by device codenames
        :type codename: List[Optional[str]]
        :param version: Filter by release version
        :type version: List[Optional[str]]
        :param type: Filter by release type
        :type type: List[ReleaseType]
        :param archived: Filter by the archived status
        :type archived: bool
        :param freezed: Filter by the freezed status
        :type freezed: bool
        :param after_release_id: Show releases after the provided one
        :type after_release_id: str
        :param after_date: Show releases after the provided timestamp
        :type after_date: int
        :param sort: Sort mode
        :type sort: ReleasesSort
        :param group: Group releases by version + variant. This will change the response!
        :type group: bool
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_releases_serialize(
            id=id,
            id2=id2,
            build_id=build_id,
            device_id=device_id,
            maintainer_id=maintainer_id,
            codename=codename,
            version=version,
            type=type,
            archived=archived,
            freezed=freezed,
            after_release_id=after_release_id,
            after_date=after_date,
            sort=sort,
            group=group,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResponseGetReleases",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_releases_without_preload_content(
        self,
        id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Release IDs")] = None,
        id2: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Release IDs (deprecated)")] = None,
        build_id: Annotated[Optional[List[StrictStr]], Field(description="Filter by Build IDs")] = None,
        device_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Device IDs")] = None,
        maintainer_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by Maintainer IDs")] = None,
        codename: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device codenames")] = None,
        version: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by release version")] = None,
        type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type")] = None,
        archived: Annotated[Optional[StrictBool], Field(description="Filter by the archived status")] = None,
        freezed: Annotated[Optional[StrictBool], Field(description="Filter by the freezed status")] = None,
        after_release_id: Annotated[Optional[StrictStr], Field(description="Show releases after the provided one")] = None,
        after_date: Annotated[Optional[StrictInt], Field(description="Show releases after the provided timestamp")] = None,
        sort: Annotated[Optional[ReleasesSort], Field(description="Sort mode")] = None,
        group: Annotated[Optional[StrictBool], Field(description="Group releases by version + variant. This will change the response!")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Releases

        Lists releases.  This method contains a bunch of different parameters to filter releases for different cases. For example, you may use ?after_release_id param to get only releases that came after the last known one  (aka get updates).  You can filter releases by maintainer_id to get releases from a specific maintainer. This is the maintainer who released the build, not the current maintainer of the device.  Getting releases by device codename is obsolete thought. The reason for this is that devices could change  codenames eventually. Unfortunately, some OEMs and community make a total mess of them. Please use /device methods to determine the right device (preferably with the user decision), save the device ID  somewhere and use it afterward.  Version tag is deprecated for the same reason, it's not really consistent, as it might contain patch and mod  versions and very different by each maintainer.

        :param id: Filter by Release IDs
        :type id: List[Optional[str]]
        :param id2: Filter by Release IDs (deprecated)
        :type id2: List[Optional[str]]
        :param build_id: Filter by Build IDs
        :type build_id: List[str]
        :param device_id: Filter by Device IDs
        :type device_id: List[Optional[str]]
        :param maintainer_id: Filter by Maintainer IDs
        :type maintainer_id: List[Optional[str]]
        :param codename: Filter by device codenames
        :type codename: List[Optional[str]]
        :param version: Filter by release version
        :type version: List[Optional[str]]
        :param type: Filter by release type
        :type type: List[ReleaseType]
        :param archived: Filter by the archived status
        :type archived: bool
        :param freezed: Filter by the freezed status
        :type freezed: bool
        :param after_release_id: Show releases after the provided one
        :type after_release_id: str
        :param after_date: Show releases after the provided timestamp
        :type after_date: int
        :param sort: Sort mode
        :type sort: ReleasesSort
        :param group: Group releases by version + variant. This will change the response!
        :type group: bool
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_releases_serialize(
            id=id,
            id2=id2,
            build_id=build_id,
            device_id=device_id,
            maintainer_id=maintainer_id,
            codename=codename,
            version=version,
            type=type,
            archived=archived,
            freezed=freezed,
            after_release_id=after_release_id,
            after_date=after_date,
            sort=sort,
            group=group,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResponseGetReleases",
            '404': None,
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_releases_serialize(
        self,
        id,
        id2,
        build_id,
        device_id,
        maintainer_id,
        codename,
        version,
        type,
        archived,
        freezed,
        after_release_id,
        after_date,
        sort,
        group,
        skip,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'id': 'multi',
            '_id': 'multi',
            'build_id': 'multi',
            'device_id': 'multi',
            'maintainer_id': 'multi',
            'codename': 'multi',
            'version': 'multi',
            'type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if id2 is not None:
            
            _query_params.append(('_id', id2))
            
        if build_id is not None:
            
            _query_params.append(('build_id', build_id))
            
        if device_id is not None:
            
            _query_params.append(('device_id', device_id))
            
        if maintainer_id is not None:
            
            _query_params.append(('maintainer_id', maintainer_id))
            
        if codename is not None:
            
            _query_params.append(('codename', codename))
            
        if version is not None:
            
            _query_params.append(('version', version))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if archived is not None:
            
            _query_params.append(('archived', archived))
            
        if freezed is not None:
            
            _query_params.append(('freezed', freezed))
            
        if after_release_id is not None:
            
            _query_params.append(('after_release_id', after_release_id))
            
        if after_date is not None:
            
            _query_params.append(('after_date', after_date))
            
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if group is not None:
            
            _query_params.append(('group', group))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/releases/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_updates_deprecated(
        self,
        last_known_id: StrictStr,
        device_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device ID")] = None,
        type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type")] = None,
        release_type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type (legacy)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponseShortReleaseResponse:
        """(Deprecated) Get Updates

        Get updates method. Returns all new releases with release IDs.  For example, \"/updates/<id>\" will return a list of all releases that were created after. You can also use \"device_id\" or / and \"release_type\" params. The first one will filter releases by specific devices, the second one will filter by release type. This can be useful, for example, if you want to notify users only with stable releases for this specific device.  Warning: This method is obsolete! Please use /release/?after_release_id= instead!

        :param last_known_id: (required)
        :type last_known_id: str
        :param device_id: Filter by device ID
        :type device_id: List[Optional[str]]
        :param type: Filter by release type
        :type type: List[ReleaseType]
        :param release_type: Filter by release type (legacy)
        :type release_type: List[ReleaseType]
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /updates/{last_known_id} is deprecated.", DeprecationWarning)

        _param = self._get_updates_deprecated_serialize(
            last_known_id=last_known_id,
            device_id=device_id,
            type=type,
            release_type=release_type,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseShortReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_updates_deprecated_with_http_info(
        self,
        last_known_id: StrictStr,
        device_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device ID")] = None,
        type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type")] = None,
        release_type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type (legacy)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponseShortReleaseResponse]:
        """(Deprecated) Get Updates

        Get updates method. Returns all new releases with release IDs.  For example, \"/updates/<id>\" will return a list of all releases that were created after. You can also use \"device_id\" or / and \"release_type\" params. The first one will filter releases by specific devices, the second one will filter by release type. This can be useful, for example, if you want to notify users only with stable releases for this specific device.  Warning: This method is obsolete! Please use /release/?after_release_id= instead!

        :param last_known_id: (required)
        :type last_known_id: str
        :param device_id: Filter by device ID
        :type device_id: List[Optional[str]]
        :param type: Filter by release type
        :type type: List[ReleaseType]
        :param release_type: Filter by release type (legacy)
        :type release_type: List[ReleaseType]
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /updates/{last_known_id} is deprecated.", DeprecationWarning)

        _param = self._get_updates_deprecated_serialize(
            last_known_id=last_known_id,
            device_id=device_id,
            type=type,
            release_type=release_type,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseShortReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_updates_deprecated_without_preload_content(
        self,
        last_known_id: StrictStr,
        device_id: Annotated[Optional[List[Optional[StrictStr]]], Field(description="Filter by device ID")] = None,
        type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type")] = None,
        release_type: Annotated[Optional[List[ReleaseType]], Field(description="Filter by release type (legacy)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Skip query results")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Limit query results (0 means unlimited)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Get Updates

        Get updates method. Returns all new releases with release IDs.  For example, \"/updates/<id>\" will return a list of all releases that were created after. You can also use \"device_id\" or / and \"release_type\" params. The first one will filter releases by specific devices, the second one will filter by release type. This can be useful, for example, if you want to notify users only with stable releases for this specific device.  Warning: This method is obsolete! Please use /release/?after_release_id= instead!

        :param last_known_id: (required)
        :type last_known_id: str
        :param device_id: Filter by device ID
        :type device_id: List[Optional[str]]
        :param type: Filter by release type
        :type type: List[ReleaseType]
        :param release_type: Filter by release type (legacy)
        :type release_type: List[ReleaseType]
        :param skip: Skip query results
        :type skip: int
        :param limit: Limit query results (0 means unlimited)
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /updates/{last_known_id} is deprecated.", DeprecationWarning)

        _param = self._get_updates_deprecated_serialize(
            last_known_id=last_known_id,
            device_id=device_id,
            type=type,
            release_type=release_type,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponseShortReleaseResponse",
            '422': "HTTPValidationError",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_updates_deprecated_serialize(
        self,
        last_known_id,
        device_id,
        type,
        release_type,
        skip,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'device_id': 'multi',
            'type': 'multi',
            'release_type': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if last_known_id is not None:
            _path_params['last_known_id'] = last_known_id
        # process the query parameters
        if device_id is not None:
            
            _query_params.append(('device_id', device_id))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if release_type is not None:
            
            _query_params.append(('release_type', release_type))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/updates/{last_known_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


